/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemClock;
import android.text.format.Time;
import android.util.TimeFormatException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Strftime;

@Implements(value=Time.class)
public class ShadowTime {
    @RealObject
    private Time time;
    private static final long SECOND_IN_MILLIS = 1000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long DAY_IN_MILLIS = 86400000L;

    @Implementation(maxSdk=20)
    protected void setToNow() {
        this.time.set(SystemClock.currentThreadTimeMillis());
    }

    @Implementation(maxSdk=20)
    protected void __constructor__() {
        this.__constructor__(ShadowTime.getCurrentTimezone());
    }

    @Implementation(maxSdk=20)
    protected void __constructor__(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.time.timezone = timezone;
        this.time.year = 1970;
        this.time.monthDay = 1;
        this.time.isDst = -1;
    }

    @Implementation(maxSdk=20)
    protected void __constructor__(Time other) {
        this.set(other);
    }

    @Implementation(maxSdk=20)
    protected void set(Time other) {
        this.time.timezone = other.timezone;
        this.time.second = other.second;
        this.time.minute = other.minute;
        this.time.hour = other.hour;
        this.time.monthDay = other.monthDay;
        this.time.month = other.month;
        this.time.year = other.year;
        this.time.weekDay = other.weekDay;
        this.time.yearDay = other.yearDay;
        this.time.isDst = other.isDst;
        this.time.gmtoff = other.gmtoff;
    }

    @Implementation(maxSdk=20)
    protected static boolean isEpoch(Time time) {
        long millis = time.toMillis(true);
        return ShadowTime.getJulianDay(millis, 0L) == 2440588;
    }

    @Implementation(maxSdk=20)
    protected static int getJulianDay(long millis, long gmtoff) {
        long offsetMillis = gmtoff * 1000L;
        long julianDay = (millis + offsetMillis) / 86400000L;
        return (int)julianDay + 2440588;
    }

    @Implementation(maxSdk=20)
    protected long setJulianDay(int julianDay) {
        long millis = (long)(julianDay - 2440588) * 86400000L;
        this.set(millis);
        int approximateDay = ShadowTime.getJulianDay(millis, this.time.gmtoff);
        int diff = julianDay - approximateDay;
        this.time.monthDay += diff;
        this.time.hour = 0;
        this.time.minute = 0;
        this.time.second = 0;
        millis = this.time.normalize(true);
        return millis;
    }

    @Implementation(maxSdk=20)
    protected void set(long millis) {
        Calendar c = this.getCalendar();
        c.setTimeInMillis(millis);
        this.set(c.get(13), c.get(12), c.get(11), c.get(5), c.get(2), c.get(1));
    }

    @Implementation(maxSdk=20)
    protected long toMillis(boolean ignoreDst) {
        Calendar c = this.getCalendar();
        return c.getTimeInMillis();
    }

    @Implementation(maxSdk=20)
    protected void set(int second, int minute, int hour, int monthDay, int month, int year) {
        this.time.second = second;
        this.time.minute = minute;
        this.time.hour = hour;
        this.time.monthDay = monthDay;
        this.time.month = month;
        this.time.year = year;
        this.time.weekDay = 0;
        this.time.yearDay = 0;
        this.time.isDst = -1;
        this.time.gmtoff = 0L;
    }

    @Implementation(maxSdk=20)
    protected void set(int monthDay, int month, int year) {
        this.set(0, 0, 0, monthDay, month, year);
    }

    @Implementation(maxSdk=20)
    protected void clear(String timezone) {
        if (timezone == null) {
            throw new NullPointerException("timezone is null!");
        }
        this.time.timezone = timezone;
        this.time.allDay = false;
        this.time.second = 0;
        this.time.minute = 0;
        this.time.hour = 0;
        this.time.monthDay = 0;
        this.time.month = 0;
        this.time.year = 0;
        this.time.weekDay = 0;
        this.time.yearDay = 0;
        this.time.gmtoff = 0L;
        this.time.isDst = -1;
    }

    @Implementation(maxSdk=20)
    protected static String getCurrentTimezone() {
        return TimeZone.getDefault().getID();
    }

    @Implementation(maxSdk=20)
    protected void switchTimezone(String timezone) {
        long date = this.toMillis(true);
        long gmtoff = TimeZone.getTimeZone(timezone).getOffset(date);
        this.set(date + gmtoff);
        this.time.timezone = timezone;
        this.time.gmtoff = gmtoff / 1000L;
    }

    @Implementation(maxSdk=20)
    protected static int compare(Time a, Time b) {
        long bms;
        long ams = a.toMillis(false);
        if (ams == (bms = b.toMillis(false))) {
            return 0;
        }
        if (ams < bms) {
            return -1;
        }
        return 1;
    }

    @Implementation(maxSdk=20)
    protected boolean before(Time other) {
        return Time.compare((Time)this.time, (Time)other) < 0;
    }

    @Implementation(maxSdk=20)
    protected boolean after(Time other) {
        return Time.compare((Time)this.time, (Time)other) > 0;
    }

    @Implementation(maxSdk=20)
    protected boolean parse(String timeString) {
        TimeZone tz;
        if (timeString.endsWith("Z")) {
            timeString = timeString.substring(0, timeString.length() - 1);
            tz = TimeZone.getTimeZone("UTC");
        } else {
            tz = TimeZone.getTimeZone(this.time.timezone);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
        SimpleDateFormat dfShort = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
        df.setTimeZone(tz);
        dfShort.setTimeZone(tz);
        this.time.timezone = tz.getID();
        try {
            this.set(df.parse(timeString).getTime());
        }
        catch (ParseException e) {
            try {
                this.set(dfShort.parse(timeString).getTime());
            }
            catch (ParseException e2) {
                ShadowTime.throwTimeFormatException(e2.getLocalizedMessage());
            }
        }
        return "UTC".equals(tz.getID());
    }

    @Implementation(maxSdk=20)
    protected String format2445() {
        String value = this.format("%Y%m%dT%H%M%S");
        if ("UTC".equals(this.time.timezone)) {
            value = value + "Z";
        }
        return value;
    }

    @Implementation(maxSdk=20)
    protected String format3339(boolean allDay) {
        if (allDay) {
            return this.format("%Y-%m-%d");
        }
        if ("UTC".equals(this.time.timezone)) {
            return this.format("%Y-%m-%dT%H:%M:%S.000Z");
        }
        String base = this.format("%Y-%m-%dT%H:%M:%S.000");
        String sign = this.time.gmtoff < 0L ? "-" : "+";
        int offset = (int)Math.abs(this.time.gmtoff);
        int minutes = offset % 3600 / 60;
        int hours = offset / 3600;
        return String.format("%s%s%02d:%02d", base, sign, hours, minutes);
    }

    @Implementation(maxSdk=20)
    protected boolean nativeParse3339(String s) {
        int len = s.length();
        if (len < 10) {
            ShadowTime.throwTimeFormatException("String too short --- expected at least 10 characters.");
        }
        boolean inUtc = false;
        int n = ShadowTime.getChar(s, 0, 1000);
        n += ShadowTime.getChar(s, 1, 100);
        n += ShadowTime.getChar(s, 2, 10);
        this.time.year = n += ShadowTime.getChar(s, 3, 1);
        this.checkChar(s, 4, '-');
        n = ShadowTime.getChar(s, 5, 10);
        n += ShadowTime.getChar(s, 6, 1);
        this.time.month = --n;
        this.checkChar(s, 7, '-');
        n = ShadowTime.getChar(s, 8, 10);
        this.time.monthDay = n += ShadowTime.getChar(s, 9, 1);
        if (len >= 19) {
            this.checkChar(s, 10, 'T');
            this.time.allDay = false;
            n = ShadowTime.getChar(s, 11, 10);
            int hour = n += ShadowTime.getChar(s, 12, 1);
            this.checkChar(s, 13, ':');
            n = ShadowTime.getChar(s, 14, 10);
            int minute = n += ShadowTime.getChar(s, 15, 1);
            this.checkChar(s, 16, ':');
            n = ShadowTime.getChar(s, 17, 10);
            this.time.second = n += ShadowTime.getChar(s, 18, 1);
            int tzIndex = 19;
            if (tzIndex < len && s.charAt(tzIndex) == '.') {
                while (++tzIndex < len && Character.isDigit(s.charAt(tzIndex))) {
                }
            }
            int offset = 0;
            if (len > tzIndex) {
                char c = s.charAt(tzIndex);
                switch (c) {
                    case 'Z': {
                        offset = 0;
                        break;
                    }
                    case '-': {
                        offset = 1;
                        break;
                    }
                    case '+': {
                        offset = -1;
                        break;
                    }
                    default: {
                        ShadowTime.throwTimeFormatException(String.format("Unexpected character 0x%02d at position %d.  Expected + or -", c, tzIndex));
                    }
                }
                inUtc = true;
                if (offset != 0) {
                    if (len < tzIndex + 6) {
                        ShadowTime.throwTimeFormatException(String.format("Unexpected length; should be %d characters", tzIndex + 6));
                    }
                    n = ShadowTime.getChar(s, tzIndex + 1, 10);
                    n += ShadowTime.getChar(s, tzIndex + 2, 1);
                    hour += (n *= offset);
                    n = ShadowTime.getChar(s, tzIndex + 4, 10);
                    n += ShadowTime.getChar(s, tzIndex + 5, 1);
                    minute += (n *= offset);
                }
            }
            this.time.hour = hour;
            this.time.minute = minute;
            if (offset != 0) {
                this.time.normalize(false);
            }
        } else {
            this.time.allDay = true;
            this.time.hour = 0;
            this.time.minute = 0;
            this.time.second = 0;
        }
        this.time.weekDay = 0;
        this.time.yearDay = 0;
        this.time.isDst = -1;
        this.time.gmtoff = 0L;
        return inUtc;
    }

    @Implementation(minSdk=21)
    protected static int getChar(String s, int spos, int mul) {
        char c = s.charAt(spos);
        if (Character.isDigit(c)) {
            return Character.getNumericValue(c) * mul;
        }
        ShadowTime.throwTimeFormatException("Parse error at pos=" + spos);
        return -1;
    }

    @Implementation(minSdk=21)
    protected void checkChar(String s, int spos, char expected) {
        char c = s.charAt(spos);
        if (c != expected) {
            ShadowTime.throwTimeFormatException(String.format("Unexpected character 0x%02d at pos=%d.  Expected 0x%02d ('%c').", c, spos, (int)expected, Character.valueOf(expected)));
        }
    }

    private static void throwTimeFormatException(String optionalMessage) {
        throw (TimeFormatException)ReflectionHelpers.callConstructor(TimeFormatException.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)(optionalMessage == null ? "fail" : optionalMessage))});
    }

    @Implementation(maxSdk=20)
    protected String format(String format) {
        return Strftime.format((String)format, (Date)new Date(this.toMillis(false)), (Locale)Locale.getDefault(), (TimeZone)TimeZone.getTimeZone(this.time.timezone));
    }

    private Calendar getCalendar() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(this.time.timezone));
        c.set(this.time.year, this.time.month, this.time.monthDay, this.time.hour, this.time.minute, this.time.second);
        c.set(14, 0);
        return c;
    }
}

