/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAccessibilityWindowInfo;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=AccessibilityNodeInfo.class)
public class ShadowAccessibilityNodeInfo {
    private static final Map<StrictEqualityNodeWrapper, StackTraceElement[]> obtainedInstances = new HashMap<StrictEqualityNodeWrapper, StackTraceElement[]>();
    private static final SparseArray<StrictEqualityNodeWrapper> orderedInstances = new SparseArray();
    public static final Parcelable.Creator<AccessibilityNodeInfo> CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){

        public AccessibilityNodeInfo createFromParcel(Parcel source) {
            return ShadowAccessibilityNodeInfo.obtain(((StrictEqualityNodeWrapper)orderedInstances.get((int)source.readInt())).mInfo);
        }

        public AccessibilityNodeInfo[] newArray(int size) {
            return new AccessibilityNodeInfo[size];
        }
    };
    private static int sAllocationCount = 0;
    private static final int PASTEABLE_MASK = 64;
    private static final int TEXT_SELECTION_SETABLE_MASK = 256;
    private long mOriginNodeId;
    private List<AccessibilityNodeInfo> children;
    private List<Pair<Integer, Bundle>> performedActionAndArgsList;
    private AccessibilityNodeInfo parent;
    private AccessibilityNodeInfo labelFor;
    private AccessibilityNodeInfo labeledBy;
    private View view;
    private CharSequence text;
    private boolean refreshReturnValue = true;
    private AccessibilityWindowInfo accessibilityWindowInfo;
    private AccessibilityNodeInfo traversalAfter;
    private AccessibilityNodeInfo traversalBefore;
    private OnPerformActionListener actionListener;
    @RealObject
    private AccessibilityNodeInfo realAccessibilityNodeInfo;
    @ReflectorObject
    AccessibilityNodeInfoReflector accessibilityNodeInfoReflector;

    @Implementation
    protected void __constructor__() {
        ((AccessibilityNodeInfoReflector)Reflector.reflector(AccessibilityNodeInfoReflector.class)).setCreator(CREATOR);
        Shadow.invokeConstructor(AccessibilityNodeInfo.class, (Object)this.realAccessibilityNodeInfo, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    protected static AccessibilityNodeInfo obtain(AccessibilityNodeInfo info) {
        ShadowAccessibilityNodeInfo shadowInfo = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)info);
        AccessibilityNodeInfo obtainedInstance = shadowInfo.getClone();
        ++sAllocationCount;
        if (shadowInfo.mOriginNodeId == 0L) {
            shadowInfo.mOriginNodeId = sAllocationCount;
        }
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        orderedInstances.put(sAllocationCount, (Object)wrapper);
        return obtainedInstance;
    }

    @Implementation
    protected static AccessibilityNodeInfo obtain(View view) {
        AccessibilityNodeInfo obtainedInstance = (AccessibilityNodeInfo)ReflectionHelpers.callConstructor(AccessibilityNodeInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityNodeInfo shadowObtained = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)obtainedInstance);
        shadowObtained.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        shadowObtained.view = view;
        ++sAllocationCount;
        if (shadowObtained.mOriginNodeId == 0L) {
            shadowObtained.mOriginNodeId = sAllocationCount;
        }
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        orderedInstances.put(sAllocationCount, (Object)wrapper);
        return obtainedInstance;
    }

    @Implementation
    protected static AccessibilityNodeInfo obtain() {
        return ShadowAccessibilityNodeInfo.obtain(new View(RuntimeEnvironment.getApplication().getApplicationContext()));
    }

    @Implementation
    protected static AccessibilityNodeInfo obtain(View root, int virtualDescendantId) {
        AccessibilityNodeInfo node = ShadowAccessibilityNodeInfo.obtain(root);
        return node;
    }

    public static boolean areThereUnrecycledNodes(boolean printUnrecycledNodesToSystemErr) {
        if (printUnrecycledNodesToSystemErr) {
            for (StrictEqualityNodeWrapper wrapper : obtainedInstances.keySet()) {
                ShadowAccessibilityNodeInfo shadow = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)wrapper.mInfo);
                System.err.printf("Leaked contentDescription = %s. Stack trace:%n", shadow.realAccessibilityNodeInfo.getContentDescription());
                for (StackTraceElement stackTraceElement : obtainedInstances.get(wrapper)) {
                    System.err.println(stackTraceElement.toString());
                }
            }
        }
        return obtainedInstances.size() != 0;
    }

    @Resetter
    public static void resetObtainedInstances() {
        obtainedInstances.clear();
        orderedInstances.clear();
    }

    @Implementation
    protected void recycle() {
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(this.realAccessibilityNodeInfo);
        if (!obtainedInstances.containsKey(wrapper)) {
            throw new IllegalStateException();
        }
        if (this.labelFor != null) {
            this.labelFor.recycle();
        }
        if (this.labeledBy != null) {
            this.labeledBy.recycle();
        }
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            if (this.traversalAfter != null) {
                this.traversalAfter.recycle();
            }
            if (this.traversalBefore != null) {
                this.traversalBefore.recycle();
            }
        }
        obtainedInstances.remove(wrapper);
        int keyOfWrapper = -1;
        for (int i = 0; i < orderedInstances.size(); ++i) {
            int key = orderedInstances.keyAt(i);
            if (!((StrictEqualityNodeWrapper)orderedInstances.get(key)).equals(wrapper)) continue;
            keyOfWrapper = key;
            break;
        }
        orderedInstances.remove(keyOfWrapper);
    }

    @Implementation
    protected int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Implementation
    protected AccessibilityNodeInfo getChild(int index) {
        if (this.children == null) {
            return null;
        }
        AccessibilityNodeInfo child = this.children.get(index);
        if (child == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(child);
    }

    @Implementation
    protected AccessibilityNodeInfo getParent() {
        if (this.parent == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.parent);
    }

    @Implementation
    protected boolean refresh() {
        return this.refreshReturnValue;
    }

    public void setRefreshReturnValue(boolean refreshReturnValue) {
        this.refreshReturnValue = refreshReturnValue;
    }

    public boolean isPasteable() {
        return (this.accessibilityNodeInfoReflector.getBooleanProperties() & 0x40) != 0;
    }

    public boolean isTextSelectionSetable() {
        return (this.accessibilityNodeInfoReflector.getBooleanProperties() & 0x100) != 0;
    }

    public void setTextSelectionSetable(boolean isTextSelectionSetable) {
        this.accessibilityNodeInfoReflector.setBooleanProperty(256, isTextSelectionSetable);
    }

    public void setPasteable(boolean isPasteable) {
        this.accessibilityNodeInfoReflector.setBooleanProperty(64, isPasteable);
    }

    @Implementation
    protected void setText(CharSequence t) {
        this.text = t;
    }

    @Implementation
    protected CharSequence getText() {
        return this.text;
    }

    @Implementation
    protected AccessibilityNodeInfo getLabelFor() {
        if (this.labelFor == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.labelFor);
    }

    public void setLabelFor(AccessibilityNodeInfo info) {
        if (this.labelFor != null) {
            this.labelFor.recycle();
        }
        this.labelFor = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    protected AccessibilityNodeInfo getLabeledBy() {
        if (this.labeledBy == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.labeledBy);
    }

    public void setLabeledBy(AccessibilityNodeInfo info) {
        if (this.labeledBy != null) {
            this.labeledBy.recycle();
        }
        this.labeledBy = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation(minSdk=22)
    protected AccessibilityNodeInfo getTraversalAfter() {
        if (this.traversalAfter == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.traversalAfter);
    }

    @Implementation(minSdk=22)
    protected void setTraversalAfter(View view, int virtualDescendantId) {
        if (this.traversalAfter != null) {
            this.traversalAfter.recycle();
        }
        this.traversalAfter = ShadowAccessibilityNodeInfo.obtain(view);
    }

    public void setTraversalAfter(AccessibilityNodeInfo info) {
        if (this.traversalAfter != null) {
            this.traversalAfter.recycle();
        }
        this.traversalAfter = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation(minSdk=22)
    protected AccessibilityNodeInfo getTraversalBefore() {
        if (this.traversalBefore == null) {
            return null;
        }
        return ShadowAccessibilityNodeInfo.obtain(this.traversalBefore);
    }

    @Implementation(minSdk=22)
    protected void setTraversalBefore(View info, int virtualDescendantId) {
        if (this.traversalBefore != null) {
            this.traversalBefore.recycle();
        }
        this.traversalBefore = ShadowAccessibilityNodeInfo.obtain(info);
    }

    public void setTraversalBefore(AccessibilityNodeInfo info) {
        if (this.traversalBefore != null) {
            this.traversalBefore.recycle();
        }
        this.traversalBefore = ShadowAccessibilityNodeInfo.obtain(info);
    }

    @Implementation
    protected void setSource(View source) {
        this.view = source;
    }

    @Implementation
    protected void setSource(View root, int virtualDescendantId) {
        this.view = root;
    }

    @Implementation(minSdk=21)
    protected AccessibilityWindowInfo getWindow() {
        return this.accessibilityWindowInfo;
    }

    @Implementation
    protected int getWindowId() {
        return this.accessibilityWindowInfo == null ? -1 : this.accessibilityWindowInfo.getId();
    }

    public void setAccessibilityWindowInfo(AccessibilityWindowInfo info) {
        this.accessibilityWindowInfo = info;
    }

    @Implementation
    protected boolean performAction(int action) {
        return this.performAction(action, null);
    }

    @Implementation
    protected boolean performAction(int action, Bundle arguments) {
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        }
        this.performedActionAndArgsList.add((Pair<Integer, Bundle>)new Pair((Object)action, (Object)arguments));
        return this.actionListener == null || this.actionListener.onPerformAccessibilityAction(action, arguments);
    }

    @Implementation
    public boolean equals(Object object) {
        if (!(object instanceof AccessibilityNodeInfo)) {
            return false;
        }
        AccessibilityNodeInfo info = (AccessibilityNodeInfo)object;
        ShadowAccessibilityNodeInfo otherShadow = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)info);
        if (this.view != null) {
            return this.view == otherShadow.view;
        }
        if (this.mOriginNodeId != 0L) {
            return this.mOriginNodeId == otherShadow.mOriginNodeId;
        }
        throw new IllegalStateException("Node has neither an ID nor View");
    }

    @Implementation
    public int hashCode() {
        return 0;
    }

    public void addChild(AccessibilityNodeInfo child) {
        if (this.children == null) {
            this.children = new ArrayList<AccessibilityNodeInfo>();
        }
        this.children.add(child);
        ShadowAccessibilityNodeInfo shadowAccessibilityNodeInfo = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)child);
        shadowAccessibilityNodeInfo.parent = this.realAccessibilityNodeInfo;
    }

    @Implementation
    protected void addChild(View child) {
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain((View)child);
        this.addChild(node);
    }

    @Implementation
    protected void addChild(View root, int virtualDescendantId) {
        AccessibilityNodeInfo node = AccessibilityNodeInfo.obtain((View)root, (int)virtualDescendantId);
        this.addChild(node);
    }

    public List<Integer> getPerformedActions() {
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        }
        ArrayList<Integer> actionsOnly = new ArrayList<Integer>();
        Iterator<Pair<Integer, Bundle>> iter = this.performedActionAndArgsList.iterator();
        while (iter.hasNext()) {
            actionsOnly.add((Integer)iter.next().first);
        }
        return Collections.unmodifiableList(actionsOnly);
    }

    public List<Pair<Integer, Bundle>> getPerformedActionsWithArgs() {
        if (this.performedActionAndArgsList == null) {
            this.performedActionAndArgsList = new ArrayList<Pair<Integer, Bundle>>();
        }
        return Collections.unmodifiableList(this.performedActionAndArgsList);
    }

    private AccessibilityNodeInfo getClone() {
        AccessibilityNodeInfo newInfo = (AccessibilityNodeInfo)ReflectionHelpers.callConstructor(AccessibilityNodeInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityNodeInfo newShadow = (ShadowAccessibilityNodeInfo)Shadow.extract((Object)newInfo);
        newShadow.mOriginNodeId = this.mOriginNodeId;
        Rect boundsInScreen = new Rect();
        this.realAccessibilityNodeInfo.getBoundsInScreen(boundsInScreen);
        newInfo.setBoundsInScreen(boundsInScreen);
        newShadow.accessibilityNodeInfoReflector.setBooleanProperties(this.accessibilityNodeInfoReflector.getBooleanProperties());
        newInfo.setContentDescription(this.realAccessibilityNodeInfo.getContentDescription());
        newShadow.text = this.text;
        newShadow.performedActionAndArgsList = this.performedActionAndArgsList;
        newShadow.parent = this.parent;
        newInfo.setClassName(this.realAccessibilityNodeInfo.getClassName());
        newShadow.labelFor = this.labelFor == null ? null : ShadowAccessibilityNodeInfo.obtain(this.labelFor);
        newShadow.labeledBy = this.labeledBy == null ? null : ShadowAccessibilityNodeInfo.obtain(this.labeledBy);
        newShadow.view = this.view;
        newShadow.actionListener = this.actionListener;
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            newShadow.accessibilityNodeInfoReflector.setActionsList(new ArrayList<AccessibilityNodeInfo.AccessibilityAction>(this.realAccessibilityNodeInfo.getActionList()));
        } else {
            newShadow.accessibilityNodeInfoReflector.setActionsMask(this.realAccessibilityNodeInfo.getActions());
        }
        if (this.children != null) {
            newShadow.children = new ArrayList<AccessibilityNodeInfo>();
            newShadow.children.addAll(this.children);
        } else {
            newShadow.children = null;
        }
        newShadow.refreshReturnValue = this.refreshReturnValue;
        newInfo.setMovementGranularities(this.realAccessibilityNodeInfo.getMovementGranularities());
        newInfo.setPackageName(this.realAccessibilityNodeInfo.getPackageName());
        newInfo.setViewIdResourceName(this.realAccessibilityNodeInfo.getViewIdResourceName());
        newInfo.setTextSelection(this.realAccessibilityNodeInfo.getTextSelectionStart(), this.realAccessibilityNodeInfo.getTextSelectionEnd());
        newInfo.setCollectionInfo(this.realAccessibilityNodeInfo.getCollectionInfo());
        newInfo.setCollectionItemInfo(this.realAccessibilityNodeInfo.getCollectionItemInfo());
        newInfo.setInputType(this.realAccessibilityNodeInfo.getInputType());
        newInfo.setLiveRegion(this.realAccessibilityNodeInfo.getLiveRegion());
        newInfo.setRangeInfo(this.realAccessibilityNodeInfo.getRangeInfo());
        newShadow.realAccessibilityNodeInfo.getExtras().putAll(this.realAccessibilityNodeInfo.getExtras());
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            newInfo.setMaxTextLength(this.realAccessibilityNodeInfo.getMaxTextLength());
            newInfo.setError(this.realAccessibilityNodeInfo.getError());
        }
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            newShadow.traversalAfter = this.traversalAfter == null ? null : ShadowAccessibilityNodeInfo.obtain(this.traversalAfter);
            AccessibilityNodeInfo accessibilityNodeInfo = newShadow.traversalBefore = this.traversalBefore == null ? null : ShadowAccessibilityNodeInfo.obtain(this.traversalBefore);
        }
        if (RuntimeEnvironment.getApiLevel() >= 21 && this.accessibilityWindowInfo != null) {
            newShadow.accessibilityWindowInfo = ShadowAccessibilityWindowInfo.obtain(this.accessibilityWindowInfo);
        }
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            newInfo.setDrawingOrder(this.realAccessibilityNodeInfo.getDrawingOrder());
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            newInfo.setHintText(this.realAccessibilityNodeInfo.getHintText());
        }
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            newInfo.setTooltipText(this.realAccessibilityNodeInfo.getTooltipText());
            newInfo.setPaneTitle(this.realAccessibilityNodeInfo.getPaneTitle());
        }
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            newInfo.setStateDescription(this.realAccessibilityNodeInfo.getStateDescription());
        }
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            newInfo.setContainerTitle(this.realAccessibilityNodeInfo.getContainerTitle());
        }
        return newInfo;
    }

    @Implementation
    protected int describeContents() {
        return 0;
    }

    @Implementation
    protected void writeToParcel(Parcel dest, int flags) {
        StrictEqualityNodeWrapper wrapper = new StrictEqualityNodeWrapper(this.realAccessibilityNodeInfo);
        int keyOfWrapper = -1;
        for (int i = 0; i < orderedInstances.size(); ++i) {
            if (!((StrictEqualityNodeWrapper)orderedInstances.valueAt(i)).equals(wrapper)) continue;
            keyOfWrapper = orderedInstances.keyAt(i);
            break;
        }
        dest.writeInt(keyOfWrapper);
    }

    public void setOnPerformActionListener(OnPerformActionListener listener) {
        this.actionListener = listener;
    }

    @Implementation
    public String toString() {
        return "ShadowAccessibilityNodeInfo@" + System.identityHashCode(this) + ":{text:" + this.text + ", className:" + this.realAccessibilityNodeInfo.getClassName() + "}";
    }

    @ForType(value=AccessibilityNodeInfo.class)
    static interface AccessibilityNodeInfoReflector {
        @Static
        @Accessor(value="CREATOR")
        public void setCreator(Parcelable.Creator<AccessibilityNodeInfo> var1);

        @Static
        public AccessibilityNodeInfo.AccessibilityAction getActionSingleton(int var1);

        @Accessor(value="mBooleanProperties")
        public int getBooleanProperties();

        @Accessor(value="mBooleanProperties")
        public void setBooleanProperties(int var1);

        public void setBooleanProperty(int var1, boolean var2);

        @Accessor(value="mActions")
        public void setActionsList(ArrayList<AccessibilityNodeInfo.AccessibilityAction> var1);

        @Accessor(value="mActions")
        public void setActionsMask(int var1);

        @Direct
        public void getBoundsInScreen(Rect var1);

        @Direct
        public void getBoundsInParent(Rect var1);

        @Direct
        public void setBoundsInScreen(Rect var1);

        @Direct
        public void setBoundsInParent(Rect var1);
    }

    private static class StrictEqualityNodeWrapper {
        public final AccessibilityNodeInfo mInfo;

        public StrictEqualityNodeWrapper(AccessibilityNodeInfo info) {
            this.mInfo = info;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof StrictEqualityNodeWrapper)) {
                return false;
            }
            StrictEqualityNodeWrapper wrapper = (StrictEqualityNodeWrapper)object;
            return this.mInfo == wrapper.mInfo;
        }

        public int hashCode() {
            return this.mInfo.hashCode();
        }
    }

    public static interface OnPerformActionListener {
        public boolean onPerformAccessibilityAction(int var1, Bundle var2);
    }
}

