/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.icu.util.ULocale;
import java.util.Locale;
import libcore.icu.ICU;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=ICU.class, isInAndroidSdk=false)
public class ShadowICU {
    @Implementation
    public static String addLikelySubtags(String languageTag) {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            return ULocale.addLikelySubtags((ULocale)ULocale.forLanguageTag((String)languageTag)).toLanguageTag();
        }
        Locale locale = Locale.forLanguageTag(languageTag);
        if (locale.getScript().isEmpty() && locale.getLanguage().equals(new Locale("ar").getLanguage())) {
            locale = new Locale.Builder().setLanguageTag(languageTag).setScript("Arab").build();
        }
        return locale.toLanguageTag();
    }

    @Implementation(minSdk=21)
    public static String getBestDateTimePattern(String skeleton, Locale locale) {
        switch (skeleton) {
            case "jmm": {
                return ShadowICU.getjmmPattern(locale);
            }
            case "yMMMd": {
                return "MMM d, y";
            }
            case "yMMMMEEEEd": {
                return "EEEE, MMMM d, y";
            }
            case "yMMMM": {
                return "MMMM y";
            }
        }
        return skeleton;
    }

    @Implementation(maxSdk=20)
    public static String getBestDateTimePattern(String skeleton, String locale) {
        return skeleton;
    }

    private static String getjmmPattern(Locale locale) {
        if (locale.equals(new Locale("pt", "BR")) || locale.equals(Locale.UK)) {
            return "H:mm";
        }
        return "h:mm a";
    }
}

