/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.input.InputManagerGlobal;
import android.util.SparseArray;
import android.view.InputDevice;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=InputManagerGlobal.class, isInAndroidSdk=false, minSdk=34)
public class ShadowInputManagerGlobal {
    @RealObject
    InputManagerGlobal realInputManager;

    @Implementation
    protected int[] getInputDeviceIds() {
        return new int[0];
    }

    @Implementation
    protected void populateInputDevicesLocked() throws ClassNotFoundException {
        if (ReflectionHelpers.getField((Object)this.realInputManager, (String)"mInputDevicesChangedListener") == null) {
            ReflectionHelpers.setField((Object)this.realInputManager, (String)"mInputDevicesChangedListener", (Object)ReflectionHelpers.callConstructor(Class.forName("android.hardware.input.InputManagerGlobal$InputDevicesChangedListener"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        }
        if (this.getInputDevices() == null) {
            int[] ids = this.realInputManager.getInputDeviceIds();
            SparseArray inputDevices = new SparseArray();
            for (int i = 0; i < ids.length; ++i) {
                inputDevices.put(ids[i], null);
            }
            this.setInputDevices((SparseArray<InputDevice>)inputDevices);
        }
    }

    private SparseArray<InputDevice> getInputDevices() {
        return ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).getInputDevices();
    }

    private void setInputDevices(SparseArray<InputDevice> devices) {
        ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).setInputDevices(devices);
    }

    @ForType(value=InputManagerGlobal.class)
    static interface InputManagerReflector {
        @Accessor(value="mInputDevices")
        public SparseArray<InputDevice> getInputDevices();

        @Accessor(value="mInputDevices")
        public void setInputDevices(SparseArray<InputDevice> var1);
    }
}

