/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.Image;
import android.media.ImageReader;
import android.view.Surface;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.ImageReaderNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowImageReader;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;

@Implements(value=ImageReader.class, minSdk=29, looseSignatures=true, isInAndroidSdk=false, shadowPicker=Picker.class, callNativeMethodsByDefault=true)
public class ShadowNativeImageReader {
    @ReflectorObject
    private ImageReaderReflector imageReaderReflector;
    private final ImageReaderNatives natives = new ImageReaderNatives();

    @Implementation(minSdk=35)
    protected static void __staticInitializer__() {
    }

    @Implementation(maxSdk=32)
    protected synchronized void nativeInit(Object weakSelf, int w, int h, int fmt, int maxImgs, long consumerUsage) {
        this.natives.nativeInit(weakSelf, w, h, fmt, maxImgs, consumerUsage);
        this.imageReaderReflector.setMemberNativeContext(this.natives.mNativeContext);
    }

    @Implementation(minSdk=33, maxSdk=34)
    protected synchronized void nativeInit(Object weakSelf, int w, int h, int maxImgs, long consumerUsage, int hardwareBufferFormat, int dataSpace) {
        int fmt = hardwareBufferFormat;
        this.natives.nativeInit(weakSelf, w, h, fmt, maxImgs, consumerUsage);
        this.imageReaderReflector.setMemberNativeContext(this.natives.mNativeContext);
    }

    @Implementation(maxSdk=34)
    protected void nativeClose() {
        this.natives.nativeClose();
    }

    @Implementation(maxSdk=34)
    protected void nativeReleaseImage(Image i) {
        this.natives.nativeReleaseImage(i);
    }

    @Implementation(maxSdk=34)
    protected Surface nativeGetSurface() {
        return this.natives.nativeGetSurface();
    }

    @Implementation(maxSdk=32)
    protected int nativeDetachImage(Image i) {
        return this.natives.nativeDetachImage(i);
    }

    @Implementation(maxSdk=34)
    protected void nativeDiscardFreeBuffers() {
        this.natives.nativeDiscardFreeBuffers();
    }

    @Implementation(maxSdk=32)
    protected int nativeImageSetup(Image i) {
        return this.natives.nativeImageSetup(i);
    }

    @Implementation(minSdk=33, maxSdk=33)
    protected int nativeImageSetup(Image i, boolean legacyValidateImageFormat) {
        return this.natives.nativeImageSetup(i);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected Object nativeImageSetup(Object i) {
        return this.natives.nativeImageSetup((Image)i);
    }

    @Implementation(maxSdk=34)
    protected static void nativeClassInit() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        ImageReaderNatives.nativeClassInit();
    }

    @ForType(value=ImageReader.class)
    static interface ImageReaderReflector {
        @Accessor(value="mNativeContext")
        public void setMemberNativeContext(long var1);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowImageReader.class, ShadowNativeImageReader.class);
        }

        @Override
        protected int getMinApiLevel() {
            return 31;
        }
    }
}

