/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.app.AlertDialog;
import android.app.Application;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.Toast;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowActivityThread;
import org.robolectric.shadows.ShadowAlertDialog;
import org.robolectric.shadows.ShadowContextImpl;
import org.robolectric.shadows.ShadowContextWrapper;
import org.robolectric.shadows.ShadowDialog;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.shadows.ShadowLegacyLooper;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPopupMenu;
import org.robolectric.shadows.ShadowWindowOnBackInvokedDispatcher;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Application.class)
public class ShadowApplication
extends ShadowContextWrapper {
    @RealObject
    private Application realApplication;
    private final List<Toast> shownToasts = new ArrayList<Toast>();
    private ShadowPopupMenu latestPopupMenu;
    private PopupWindow latestPopupWindow;
    private ListPopupWindow latestListPopupWindow;

    @Deprecated
    public static void runBackgroundTasks() {
        Shadows.shadowOf(RuntimeEnvironment.getApplication()).getBackgroundThreadScheduler().advanceBy(0L);
    }

    public static void setProcessName(String processName) {
        ShadowActivityThread.ActivityThreadReflector activityThread = (ShadowActivityThread.ActivityThreadReflector)Reflector.reflector(ShadowActivityThread.ActivityThreadReflector.class, (Object)ShadowActivityThread.currentActivityThread());
        ((ShadowActivityThread.AppBindDataReflector)Reflector.reflector(ShadowActivityThread.AppBindDataReflector.class, (Object)activityThread.getBoundApplication())).setProcessName(processName);
    }

    public void callAttach(Context context) {
        ReflectionHelpers.callInstanceMethod(Application.class, (Object)this.realApplication, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    public List<Toast> getShownToasts() {
        return this.shownToasts;
    }

    @Deprecated
    public Scheduler getBackgroundThreadScheduler() {
        ShadowLooper.assertLooperMode(LooperMode.Mode.LEGACY);
        return ShadowLegacyLooper.getBackgroundThreadScheduler();
    }

    public void setUnbindServiceCallsOnServiceDisconnected(boolean flag) {
        ShadowApplication.getShadowInstrumentation().setUnbindServiceCallsOnServiceDisconnected(flag);
    }

    public void setComponentNameAndServiceForBindService(ComponentName name, IBinder service) {
        ShadowApplication.getShadowInstrumentation().setComponentNameAndServiceForBindService(name, service);
    }

    public void setComponentNameAndServiceForBindServiceForIntent(Intent intent, ComponentName name, IBinder service) {
        ShadowApplication.getShadowInstrumentation().setComponentNameAndServiceForBindServiceForIntent(intent, name, service);
    }

    public void assertNoBroadcastListenersOfActionRegistered(ContextWrapper context, String action) {
        ShadowApplication.getShadowInstrumentation().assertNoBroadcastListenersOfActionRegistered(context, action);
    }

    public List<ServiceConnection> getBoundServiceConnections() {
        return ShadowApplication.getShadowInstrumentation().getBoundServiceConnections();
    }

    public void setUnbindServiceShouldThrowIllegalArgument(boolean flag) {
        ShadowApplication.getShadowInstrumentation().setUnbindServiceShouldThrowIllegalArgument(flag);
    }

    public void setThrowInBindService(SecurityException e) {
        ShadowApplication.getShadowInstrumentation().setThrowInBindService(e);
    }

    public void setBindServiceCallsOnServiceConnectedDirectly(boolean callDirectly) {
        ShadowApplication.getShadowInstrumentation().setBindServiceCallsOnServiceConnectedDirectly(callDirectly);
    }

    public List<ServiceConnection> getUnboundServiceConnections() {
        return ShadowApplication.getShadowInstrumentation().getUnboundServiceConnections();
    }

    @Deprecated
    public boolean hasReceiverForIntent(Intent intent) {
        return ShadowApplication.getShadowInstrumentation().hasReceiverForIntent(intent);
    }

    @Deprecated
    public List<BroadcastReceiver> getReceiversForIntent(Intent intent) {
        return ShadowApplication.getShadowInstrumentation().getReceiversForIntent(intent);
    }

    public ImmutableList<Wrapper> getRegisteredReceivers() {
        return ShadowApplication.getShadowInstrumentation().getRegisteredReceivers();
    }

    public void clearRegisteredReceivers() {
        ShadowApplication.getShadowInstrumentation().clearRegisteredReceivers();
    }

    @Deprecated
    public ShadowAlertDialog getLatestAlertDialog() {
        AlertDialog dialog = ShadowAlertDialog.getLatestAlertDialog();
        return dialog == null ? null : (ShadowAlertDialog)Shadow.extract((Object)dialog);
    }

    @Deprecated
    public ShadowDialog getLatestDialog() {
        Dialog dialog = ShadowDialog.getLatestDialog();
        return dialog == null ? null : (ShadowDialog)Shadow.extract((Object)dialog);
    }

    public void declareActionUnbindable(String action) {
        ShadowApplication.getShadowInstrumentation().declareActionUnbindable(action);
    }

    public void declareComponentUnbindable(ComponentName component) {
        ShadowApplication.getShadowInstrumentation().declareComponentUnbindable(component);
    }

    public void checkActivities(boolean checkActivities) {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        shadowInstrumentation.checkActivities(checkActivities);
    }

    @Deprecated
    public ShadowPopupMenu getLatestPopupMenu() {
        return this.latestPopupMenu;
    }

    protected void setLatestPopupMenu(ShadowPopupMenu latestPopupMenu) {
        this.latestPopupMenu = latestPopupMenu;
    }

    public PopupWindow getLatestPopupWindow() {
        return this.latestPopupWindow;
    }

    protected void setLatestPopupWindow(PopupWindow latestPopupWindow) {
        this.latestPopupWindow = latestPopupWindow;
    }

    public ListPopupWindow getLatestListPopupWindow() {
        return this.latestListPopupWindow;
    }

    protected void setLatestListPopupWindow(ListPopupWindow latestListPopupWindow) {
        this.latestListPopupWindow = latestListPopupWindow;
    }

    @Deprecated
    public void setSystemService(String key, Object service) {
        ShadowContextImpl shadowContext = (ShadowContextImpl)Shadow.extract((Object)this.realApplication.getBaseContext());
        shadowContext.setSystemService(key, service);
    }

    public static void setEnableOnBackInvokedCallback(boolean isEnabled) {
        if (Build.VERSION.SDK_INT >= 34) {
            ShadowWindowOnBackInvokedDispatcher.setEnablePredictiveBack(isEnabled);
            RuntimeEnvironment.getApplication().getApplicationInfo().setEnableOnBackInvokedCallback(isEnabled);
        }
    }

    public static final class Wrapper {
        public BroadcastReceiver broadcastReceiver;
        public IntentFilter intentFilter;
        public Context context;
        public Throwable exception;
        public String broadcastPermission;
        public Handler scheduler;
        public int flags;

        public Wrapper(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, Context context, String broadcastPermission, Handler scheduler, int flags) {
            this.broadcastReceiver = broadcastReceiver;
            this.intentFilter = intentFilter;
            this.context = context;
            this.broadcastPermission = broadcastPermission;
            this.scheduler = scheduler;
            this.flags = flags;
            this.exception = new Throwable();
        }

        public BroadcastReceiver getBroadcastReceiver() {
            return this.broadcastReceiver;
        }

        public IntentFilter getIntentFilter() {
            return this.intentFilter;
        }

        public Context getContext() {
            return this.context;
        }

        public String toString() {
            return "Wrapper[receiver=[" + this.broadcastReceiver + "], context=[" + this.context + "], intentFilter=[" + this.intentFilter + "]]";
        }
    }
}

