/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothCodecConfig;
import android.bluetooth.BluetoothCodecStatus;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Parcelable;
import android.util.Log;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.versioning.AndroidVersions;

@Implements(value=BluetoothA2dp.class)
public class ShadowBluetoothA2dp {
    private static final String TAG = "BluetoothA2dp";
    private static final boolean VERIFY_DEVICE_NOT_NULL_IS_STATIC = ShadowBluetoothA2dp.verifyDeviceNotNullIsStatic();
    @RealObject
    protected BluetoothA2dp realObject;
    private final Map<BluetoothDevice, Integer> bluetoothDevices = new HashMap<BluetoothDevice, Integer>();
    private final Map<BluetoothDevice, BluetoothCodecStatus> codecStatusMap = new HashMap<BluetoothDevice, BluetoothCodecStatus>();
    private final Map<BluetoothDevice, BluetoothCodecConfig> codecConfigPreferenceMap = new HashMap<BluetoothDevice, BluetoothCodecConfig>();
    private final Map<BluetoothDevice, Integer> optionalCodecPreferenceStatusMap = new HashMap<BluetoothDevice, Integer>();
    private int dynamicBufferSupportType = 0;
    private final int[] bufferLengthMillisArray = new int[6];
    private BluetoothDevice activeBluetoothDevice;

    public void addDevice(BluetoothDevice bluetoothDevice, int connectionState) {
        this.bluetoothDevices.put(bluetoothDevice, connectionState);
    }

    public void removeDevice(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevices.remove(bluetoothDevice);
    }

    @Implementation
    protected List<BluetoothDevice> getConnectedDevices() {
        return this.getDevicesMatchingConnectionStates(new int[]{2});
    }

    @Implementation
    protected List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        ArrayList<BluetoothDevice> deviceList = new ArrayList<BluetoothDevice>();
        for (Map.Entry<BluetoothDevice, Integer> entry : this.bluetoothDevices.entrySet()) {
            for (int state : states) {
                if (entry.getValue() != state) continue;
                deviceList.add(entry.getKey());
            }
        }
        return ImmutableList.copyOf(deviceList);
    }

    @Implementation
    protected int getConnectionState(BluetoothDevice device) {
        return this.bluetoothDevices.containsKey(device) ? this.bluetoothDevices.get(device) : 0;
    }

    public void setDynamicBufferSupport(int type) {
        this.dynamicBufferSupportType = type;
    }

    @Implementation(minSdk=31)
    protected int getDynamicBufferSupport() {
        return this.dynamicBufferSupportType;
    }

    @Implementation(minSdk=31)
    protected boolean setBufferLengthMillis(int codec, int value) {
        if (codec >= this.bufferLengthMillisArray.length || codec < 0 || value < 0) {
            return false;
        }
        this.bufferLengthMillisArray[codec] = value;
        return true;
    }

    public int getBufferLengthMillis(int codec) {
        return this.bufferLengthMillisArray[codec];
    }

    @Nullable
    @Implementation(minSdk=28)
    protected BluetoothDevice getActiveDevice() {
        return this.activeBluetoothDevice;
    }

    @Implementation(minSdk=28)
    protected boolean setActiveDevice(@Nullable BluetoothDevice bluetoothDevice) {
        this.activeBluetoothDevice = bluetoothDevice;
        Intent intent = new Intent("android.bluetooth.a2dp.profile.action.ACTIVE_DEVICE_CHANGED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)this.activeBluetoothDevice);
        RuntimeEnvironment.getApplication().sendBroadcast(intent);
        return true;
    }

    @Implementation(minSdk=33)
    @Nullable
    protected BluetoothCodecStatus getCodecStatus(BluetoothDevice device) {
        return this.codecStatusMap.get(device);
    }

    public void setCodecStatus(BluetoothDevice device, BluetoothCodecStatus codecStatus) {
        this.codecStatusMap.put(device, codecStatus);
    }

    @Nullable
    public BluetoothCodecConfig getCodecConfigPreference(BluetoothDevice device) {
        return this.codecConfigPreferenceMap.get(device);
    }

    @Implementation(minSdk=33)
    protected void setCodecConfigPreference(BluetoothDevice device, BluetoothCodecConfig codecConfig) {
        this.codecConfigPreferenceMap.put(device, codecConfig);
    }

    @Implementation(minSdk=30)
    protected int isOptionalCodecsEnabled(BluetoothDevice device) {
        this.verifyDeviceNotNull(device, "isOptionalCodecsEnabled");
        if (this.optionalCodecPreferenceStatusMap.containsKey(device)) {
            return this.optionalCodecPreferenceStatusMap.get(device);
        }
        return -1;
    }

    @Implementation(minSdk=30)
    protected void setOptionalCodecsEnabled(BluetoothDevice device, int value) {
        this.verifyDeviceNotNull(device, "setOptionalCodecsEnabled");
        if (value != -1 && value != 0 && value != 1) {
            Log.e((String)TAG, (String)("Invalid value passed to setOptionalCodecsEnabled: " + value));
            return;
        }
        this.optionalCodecPreferenceStatusMap.put(device, value);
    }

    private static boolean verifyDeviceNotNullIsStatic() {
        Method m = null;
        try {
            m = BluetoothA2dp.class.getDeclaredMethod("verifyDeviceNotNull", BluetoothDevice.class, String.class);
            return Modifier.isStatic(m.getModifiers());
        }
        catch (NoSuchMethodException e) {
            if (AndroidVersions.CURRENT.getSdkInt() >= 30) {
                throw new RuntimeException("Method verifyDeviceNotNull not found in BluetoothA2dp", e);
            }
            return false;
        }
    }

    @Implementation(minSdk=30, maxSdk=36, methodName="verifyDeviceNotNull")
    protected void verifyDeviceNotNull(BluetoothDevice device, String methodName) {
        if (VERIFY_DEVICE_NOT_NULL_IS_STATIC) {
            ((BluetoothA2dpReflector)Reflector.reflector(BluetoothA2dpReflector.class)).verifyDeviceNotNull(device, methodName);
        } else {
            ((BluetoothA2dpReflector)Reflector.reflector(BluetoothA2dpReflector.class, (Object)this.realObject)).verifyDeviceNotNull(device, methodName);
        }
    }

    @Implementation(minSdk=36, methodName="verifyDeviceNotNull")
    protected static void verifyDeviceNotNullBaklava(BluetoothDevice device, String methodName) {
        ((BluetoothA2dpReflector)Reflector.reflector(BluetoothA2dpReflector.class)).verifyDeviceNotNull(device, methodName);
    }

    @ForType(value=BluetoothA2dp.class)
    private static interface BluetoothA2dpReflector {
        @Direct
        public void verifyDeviceNotNull(BluetoothDevice var1, String var2);
    }
}

