/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=BroadcastReceiver.class)
public class ShadowBroadcastReceiver {
    @RealObject
    BroadcastReceiver receiver;
    private AtomicBoolean abort = new AtomicBoolean(false);
    private boolean wentAsync = false;
    private BroadcastReceiver.PendingResult originalPendingResult;

    @Implementation
    protected void abortBroadcast() {
        this.abort.set(true);
    }

    @Implementation
    protected void onReceive(Context context, Intent intent) {
        if (this.abort == null || !this.abort.get()) {
            this.receiver.onReceive(context, intent);
        }
    }

    public void onReceive(Context context, Intent intent, AtomicBoolean abort) {
        this.abort = abort;
        this.onReceive(context, intent);
        if (this.receiver.getPendingResult() != null) {
            this.receiver.getPendingResult().finish();
        }
    }

    @Implementation
    protected BroadcastReceiver.PendingResult goAsync() {
        this.originalPendingResult = this.receiver.getPendingResult();
        this.wentAsync = true;
        return ((BroadcastReceiverReflector)Reflector.reflector(BroadcastReceiverReflector.class, (Object)this.receiver)).goAsync();
    }

    public boolean wentAsync() {
        return this.wentAsync;
    }

    public boolean isBroadcastAborted() {
        return this.abort.get();
    }

    public BroadcastReceiver.PendingResult getOriginalPendingResult() {
        if (this.wentAsync) {
            return this.originalPendingResult;
        }
        return this.receiver.getPendingResult();
    }

    @ForType(value=BroadcastReceiver.class)
    static interface BroadcastReceiverReflector {
        @Direct
        public BroadcastReceiver.PendingResult goAsync();
    }
}

