/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import java.time.Duration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Choreographer.class, shadowPicker=ShadowChoreographer.Picker.class, isInAndroidSdk=false)
public class ShadowLegacyChoreographer
extends ShadowChoreographer {
    private long nanoTime = 0L;
    private static long FRAME_INTERVAL = Duration.ofMillis(10L).toNanos();
    private static final Thread MAIN_THREAD = Thread.currentThread();
    private static ThreadLocal<Choreographer> instance = ThreadLocal.withInitial(() -> ShadowLegacyChoreographer.makeChoreographer());
    private final Handler handler = new Handler(Looper.myLooper());
    private static volatile int postCallbackDelayMillis = 0;
    private static volatile int postFrameCallbackDelayMillis = 0;

    private static Choreographer makeChoreographer() {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            throw new IllegalStateException("The current thread must have a looper!");
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            return (Choreographer)ReflectionHelpers.callConstructor(Choreographer.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Looper.class, (Object)looper), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
        }
        return (Choreographer)ReflectionHelpers.callConstructor(Choreographer.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Looper.class, (Object)looper)});
    }

    public static void setPostCallbackDelay(int delayMillis) {
        postCallbackDelayMillis = delayMillis;
    }

    public static void setPostFrameCallbackDelay(int delayMillis) {
        postFrameCallbackDelayMillis = delayMillis;
    }

    @Implementation
    protected static Choreographer getInstance() {
        return instance.get();
    }

    @Implementation
    protected void postCallback(int callbackType, Runnable action, Object token) {
        this.postCallbackDelayed(callbackType, action, token, postCallbackDelayMillis);
    }

    @Implementation
    protected void postCallbackDelayed(int callbackType, Runnable action, Object token, long delayMillis) {
        this.handler.postDelayed(action, delayMillis);
    }

    @Implementation
    protected void removeCallbacks(int callbackType, Runnable action, Object token) {
        this.handler.removeCallbacks(action, token);
    }

    @Implementation
    protected void postFrameCallback(Choreographer.FrameCallback callback) {
        this.postFrameCallbackDelayed(callback, postFrameCallbackDelayMillis);
    }

    @Implementation
    protected void postFrameCallbackDelayed(Choreographer.FrameCallback callback, long delayMillis) {
        this.handler.postAtTime(() -> callback.doFrame(this.getFrameTimeNanos()), (Object)callback, SystemClock.uptimeMillis() + delayMillis);
    }

    @Implementation
    protected void removeFrameCallback(Choreographer.FrameCallback callback) {
        this.handler.removeCallbacksAndMessages((Object)callback);
    }

    @Implementation
    protected long getFrameTimeNanos() {
        long now = this.nanoTime;
        this.nanoTime += FRAME_INTERVAL;
        return now;
    }

    public static long getFrameInterval() {
        return FRAME_INTERVAL;
    }

    public static void setFrameInterval(long frameInterval) {
        FRAME_INTERVAL = frameInterval;
    }

    @Resetter
    public static synchronized void reset() {
        if (Thread.currentThread() != MAIN_THREAD) {
            throw new RuntimeException("You should only call this from the main thread!");
        }
        instance = ThreadLocal.withInitial(() -> ShadowLegacyChoreographer.makeChoreographer());
        FRAME_INTERVAL = Duration.ofMillis(10L).toNanos();
        postCallbackDelayMillis = 0;
        postFrameCallbackDelayMillis = 0;
    }
}

