/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.QueuedWork;
import android.os.Handler;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=QueuedWork.class, isInAndroidSdk=false)
public class ShadowQueuedWork {
    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            ShadowQueuedWork.resetStateApi26();
        } else {
            QueuedWork.waitToFinish();
            ((QueuedWorkReflector)Reflector.reflector(QueuedWorkReflector.class)).setSingleThreadExecutor(null);
        }
    }

    private static void resetStateApi26() {
        Handler queuedWorkHandler = (Handler)ReflectionHelpers.getStaticField(QueuedWork.class, (String)"sHandler");
        if (queuedWorkHandler != null) {
            queuedWorkHandler.removeCallbacksAndMessages(null);
        }
        QueuedWorkReflector queuedWorkReflector = (QueuedWorkReflector)Reflector.reflector(QueuedWorkReflector.class);
        queuedWorkReflector.getFinishers().clear();
        queuedWorkReflector.getWork().clear();
        queuedWorkReflector.setNumWaits(0);
    }

    @ForType(value=QueuedWork.class)
    static interface QueuedWorkReflector {
        @Static
        @Accessor(value="sFinishers")
        public LinkedList<Runnable> getFinishers();

        @Static
        @Accessor(value="sSingleThreadExecutor")
        public void setSingleThreadExecutor(ExecutorService var1);

        @Static
        @Accessor(value="sWork")
        public LinkedList<Runnable> getWork();

        @Static
        @Accessor(value="mNumWaits")
        public void setNumWaits(int var1);

        @Static
        @Accessor(value="sHandler")
        public void setHandler(Handler var1);

        @Static
        public void add(Runnable var1);
    }
}

