/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowContextWrapper;

@Implements(value=Service.class)
public class ShadowService
extends ShadowContextWrapper {
    @RealObject
    Service realService;
    private int lastForegroundNotificationId;
    private Notification lastForegroundNotification;
    private boolean lastForegroundNotificationAttached = false;
    private boolean selfStopped = false;
    private boolean foregroundStopped;
    private boolean notificationShouldRemoved;
    private Exception exceptionForStartForeground = null;
    private int stopSelfId;
    private int stopSelfResultId;
    private int foregroundServiceType;

    @Implementation
    protected void onDestroy() {
        if (this.lastForegroundNotificationAttached) {
            this.lastForegroundNotificationAttached = false;
            this.removeForegroundNotification();
        }
    }

    @Implementation
    protected void stopSelf() {
        this.selfStopped = true;
    }

    @Implementation
    protected void stopSelf(int id2) {
        this.selfStopped = true;
        this.stopSelfId = id2;
    }

    @Implementation
    protected boolean stopSelfResult(int id2) {
        this.selfStopped = true;
        this.stopSelfResultId = id2;
        return true;
    }

    @Implementation
    protected void startForeground(int id2, Notification notification) throws Exception {
        if (this.exceptionForStartForeground != null) {
            throw this.exceptionForStartForeground;
        }
        this.foregroundStopped = false;
        this.lastForegroundNotificationId = id2;
        this.lastForegroundNotification = notification;
        this.lastForegroundNotificationAttached = true;
        notification.flags |= 0x40;
        NotificationManager nm = (NotificationManager)RuntimeEnvironment.getApplication().getSystemService("notification");
        nm.notify(id2, notification);
        this.foregroundServiceType = 0;
    }

    @Implementation(minSdk=29)
    protected void startForeground(int id2, Notification notification, int foregroundServiceType) throws Exception {
        this.startForeground(id2, notification);
        this.foregroundServiceType = foregroundServiceType;
    }

    @Implementation
    protected void stopForeground(boolean removeNotification) {
        this.foregroundStopped = true;
        this.notificationShouldRemoved = removeNotification;
        if (removeNotification) {
            this.removeForegroundNotification();
        }
    }

    @Implementation(minSdk=29)
    protected int getForegroundServiceType() {
        return this.foregroundServiceType;
    }

    @Implementation(minSdk=24)
    protected void stopForeground(int flags) {
        if ((flags & 2) != 0) {
            this.lastForegroundNotificationAttached = false;
        }
        this.stopForeground((flags & 1) != 0);
    }

    private void removeForegroundNotification() {
        NotificationManager nm = (NotificationManager)RuntimeEnvironment.getApplication().getSystemService("notification");
        nm.cancel(this.lastForegroundNotificationId);
        this.lastForegroundNotification = null;
        this.lastForegroundNotificationAttached = false;
    }

    public int getLastForegroundNotificationId() {
        return this.lastForegroundNotificationId;
    }

    public Notification getLastForegroundNotification() {
        return this.lastForegroundNotification;
    }

    public boolean isLastForegroundNotificationAttached() {
        return this.lastForegroundNotificationAttached;
    }

    public boolean isStoppedBySelf() {
        return this.selfStopped;
    }

    public boolean isForegroundStopped() {
        return this.foregroundStopped;
    }

    public boolean getNotificationShouldRemoved() {
        return this.notificationShouldRemoved;
    }

    public int getStopSelfId() {
        return this.stopSelfId;
    }

    public int getStopSelfResultId() {
        return this.stopSelfResultId;
    }

    public void setThrowInStartForeground(Exception e) {
        this.exceptionForStartForeground = e;
    }
}

