/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SimpleClock;
import android.os.SystemClock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.shadows.LooperShadowPicker;
import org.robolectric.shadows.ShadowLegacySystemClock;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPausedSystemClock;
import org.robolectric.shadows.ShadowSystem;

@Implements(value=SystemClock.class, shadowPicker=Picker.class)
public abstract class ShadowSystemClock {
    protected static boolean networkTimeAvailable = true;
    private static boolean gnssTimeAvailable = true;

    public static long currentTimeMillis() {
        return ShadowLegacySystemClock.currentTimeMillis();
    }

    @Deprecated
    public static long nanoTime() {
        return ShadowSystem.nanoTime();
    }

    public static void setNanoTime(long nanoTime) {
        ShadowLooper.assertLooperMode(LooperMode.Mode.LEGACY);
        ShadowLegacySystemClock.setNanoTime(nanoTime);
    }

    public static void setNetworkTimeAvailable(boolean available) {
        networkTimeAvailable = available;
    }

    public static void advanceBy(long time, TimeUnit unit) {
        ShadowSystemClock.advanceBy(Duration.of(time, unit.toChronoUnit()));
    }

    public static void advanceBy(Duration duration) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.LEGACY) {
            SystemClock.setCurrentTimeMillis((long)(SystemClock.uptimeMillis() + duration.toMillis()));
        } else {
            ShadowPausedSystemClock.internalAdvanceBy(duration);
        }
    }

    public static void simulateDeepSleep(Duration duration) {
        ShadowLooper.assertLooperMode(LooperMode.Mode.PAUSED);
        ShadowPausedSystemClock.deepSleep(duration.toMillis());
    }

    @Implementation(minSdk=29)
    protected static @ClassName(value="java.time.Clock") Object currentGnssTimeClock() {
        if (gnssTimeAvailable) {
            return new SimpleClock(ZoneOffset.UTC){

                public long millis() {
                    return SystemClock.uptimeMillis();
                }
            };
        }
        throw new DateTimeException("Gnss based time is not available.");
    }

    public static void setGnssTimeAvailable(boolean available) {
        gnssTimeAvailable = available;
    }

    public static void reset() {
        networkTimeAvailable = true;
        gnssTimeAvailable = true;
    }

    public static class Picker
    extends LooperShadowPicker<ShadowSystemClock> {
        public Picker() {
            super(ShadowLegacySystemClock.class, ShadowPausedSystemClock.class);
        }
    }
}

