/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.speech.tts.Voice;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowMediaPlayer;
import org.robolectric.shadows.util.DataSource;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=TextToSpeech.class)
public class ShadowTextToSpeech {
    private static final Set<Locale> languageAvailabilities = new HashSet<Locale>();
    private static final Set<Voice> voices = new HashSet<Voice>();
    private static TextToSpeech lastTextToSpeechInstance;
    @RealObject
    private TextToSpeech tts;
    private Context context;
    private TextToSpeech.OnInitListener listener;
    private String lastSpokenText;
    private boolean shutdown = false;
    private boolean stopped = true;
    private int queueMode = -1;
    private Locale language = null;
    private File lastSynthesizeToFile;
    private String lastSynthesizeToFileText;
    private Voice currentVoice = null;
    private int synthesizeToFileResult = 0;
    private boolean completeSynthesis = false;
    private final List<String> spokenTextList = new ArrayList<String>();

    @Implementation
    protected void __constructor__(Context context, TextToSpeech.OnInitListener listener, String engine, String packageName, boolean useFallback) {
        this.context = context;
        this.listener = listener;
        lastTextToSpeechInstance = this.tts;
        Shadow.invokeConstructor(TextToSpeech.class, (Object)this.tts, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(TextToSpeech.OnInitListener.class, (Object)listener), ReflectionHelpers.ClassParameter.from(String.class, (Object)engine), ReflectionHelpers.ClassParameter.from(String.class, (Object)packageName), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)useFallback)});
    }

    public void simulateSynthesizeToFileResult(int result) {
        this.synthesizeToFileResult = result;
        this.completeSynthesis = true;
    }

    @Implementation
    protected int initTts() {
        return 0;
    }

    @Implementation
    protected int speak(String text, int queueMode, HashMap<String, String> params) {
        return ((TextToSpeechReflector)Reflector.reflector(TextToSpeechReflector.class, (Object)this.tts)).speak(text, queueMode, params);
    }

    @Implementation
    protected int speak(CharSequence text, int queueMode, Bundle params, String utteranceId) {
        this.stopped = false;
        this.lastSpokenText = text.toString();
        this.spokenTextList.add(text.toString());
        this.queueMode = queueMode;
        if (utteranceId != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(() -> {
                UtteranceProgressListener utteranceProgressListener = this.getUtteranceProgressListener();
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onStart(utteranceId);
                }
                handler.post(() -> {
                    UtteranceProgressListener utteranceProgressListener2 = this.getUtteranceProgressListener();
                    if (utteranceProgressListener2 != null) {
                        utteranceProgressListener2.onDone(utteranceId);
                    }
                });
            });
        }
        return 0;
    }

    @Implementation
    protected void shutdown() {
        this.shutdown = true;
    }

    @Implementation
    protected int stop() {
        this.stopped = true;
        return 0;
    }

    @Implementation
    protected int isLanguageAvailable(Locale lang) {
        for (Locale locale : languageAvailabilities) {
            try {
                if (!locale.getISO3Language().equals(lang.getISO3Language())) continue;
                if (locale.getISO3Country().equals(lang.getISO3Country())) {
                    if (locale.getVariant().equals(lang.getVariant())) {
                        return 2;
                    }
                    return 1;
                }
                return 0;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return -2;
    }

    @Implementation
    protected int setLanguage(Locale locale) {
        this.language = locale;
        int languageAvailability = this.isLanguageAvailable(locale);
        if (languageAvailability >= 0 && this.currentVoice == null) {
            this.setVoice(new Voice(locale.toLanguageTag(), locale, 300, 300, false, new HashSet()));
        }
        return languageAvailability;
    }

    @Implementation
    protected int synthesizeToFile(CharSequence text, Bundle params, File file, String utteranceId) throws IOException {
        this.lastSynthesizeToFileText = text.toString();
        if (!Boolean.getBoolean("robolectric.enableShadowTtsSynthesisToFileWriteToFileSuppression")) {
            this.lastSynthesizeToFile = file;
            try (PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8.name());){
                writer.println(text);
            }
            ShadowMediaPlayer.addMediaInfo(DataSource.toDataSource(file.getAbsolutePath()), new ShadowMediaPlayer.MediaInfo());
        }
        UtteranceProgressListener utteranceProgressListener = this.getUtteranceProgressListener();
        if (this.completeSynthesis && utteranceProgressListener != null && !Boolean.getBoolean("robolectric.enableShadowTtsSynthesisToFileCallbackSuppression")) {
            switch (this.synthesizeToFileResult) {
                case 0: {
                    utteranceProgressListener.onStart(utteranceId);
                    utteranceProgressListener.onDone(utteranceId);
                    break;
                }
                default: {
                    utteranceProgressListener.onError(utteranceId, this.synthesizeToFileResult);
                }
            }
        }
        return 0;
    }

    @Implementation
    protected int setVoice(Voice voice) {
        this.currentVoice = voice;
        return 0;
    }

    @Implementation
    protected Voice getVoice() {
        return this.currentVoice;
    }

    @Implementation
    protected Set<Voice> getVoices() {
        return voices;
    }

    public UtteranceProgressListener getUtteranceProgressListener() {
        return (UtteranceProgressListener)ReflectionHelpers.getField((Object)this.tts, (String)"mUtteranceProgressListener");
    }

    public Context getContext() {
        return this.context;
    }

    public TextToSpeech.OnInitListener getOnInitListener() {
        return this.listener;
    }

    public String getLastSpokenText() {
        return this.lastSpokenText;
    }

    public void clearLastSpokenText() {
        this.lastSpokenText = null;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getQueueMode() {
        return this.queueMode;
    }

    public Locale getCurrentLanguage() {
        return this.language;
    }

    public String getLastSynthesizeToFileText() {
        return this.lastSynthesizeToFileText;
    }

    public File getLastSynthesizeToFile() {
        return this.lastSynthesizeToFile;
    }

    public ImmutableList<String> getSpokenTextList() {
        return ImmutableList.copyOf(this.spokenTextList);
    }

    public static void addLanguageAvailability(Locale locale) {
        languageAvailabilities.add(locale);
    }

    public static void addVoice(Voice voice) {
        voices.add(voice);
    }

    public Voice getCurrentVoice() {
        return this.currentVoice;
    }

    public static TextToSpeech getLastTextToSpeechInstance() {
        return lastTextToSpeechInstance;
    }

    @Resetter
    public static void reset() {
        languageAvailabilities.clear();
        voices.clear();
        lastTextToSpeechInstance = null;
    }

    @ForType(value=TextToSpeech.class)
    static interface TextToSpeechReflector {
        @Direct
        public int speak(String var1, int var2, HashMap<?, ?> var3);
    }
}

