/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.SecurityParams;
import android.net.wifi.WifiConfiguration;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=WifiConfiguration.class)
public class ShadowWifiConfiguration {
    @RealObject
    private WifiConfiguration realObject;
    private int securityType = -1;

    public WifiConfiguration copy() {
        return new WifiConfiguration(this.realObject);
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected void setSecurityParams(int securityType) {
        ((WifiConfigurationReflector)Reflector.reflector(WifiConfigurationReflector.class, (Object)this.realObject)).setSecurityParams(securityType);
        this.securityType = securityType;
    }

    public Set<Integer> getSecurityTypes() {
        if (RuntimeEnvironment.getApiLevel() == 30) {
            return ImmutableSet.of((Object)this.securityType);
        }
        List<Object> params = ((WifiConfigurationReflector)Reflector.reflector(WifiConfigurationReflector.class, (Object)this.realObject)).getSecurityParams();
        return params.stream().map(s -> ((SecurityParams)s).getSecurityType()).collect(Collectors.toSet());
    }

    @ForType(value=WifiConfiguration.class)
    static interface WifiConfigurationReflector {
        @Accessor(value="mSecurityParamsList")
        public List<Object> getSecurityParams();

        @Direct
        public void setSecurityParams(int var1);
    }
}

