/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Parcel;
import android.os.health.HealthStats;
import android.os.health.TimerStat;
import android.util.ArrayMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

final class HealthStatsBuilder {
    private String dataType = null;
    private final HashMap<Integer, TimerStat> timerMap = new HashMap();
    private final HashMap<Integer, Long> measurementMap = new HashMap();
    private final HashMap<Integer, ArrayMap<String, HealthStats>> statsMap = new HashMap();
    private final HashMap<Integer, ArrayMap<String, TimerStat>> timersMap = new HashMap();
    private final HashMap<Integer, ArrayMap<String, Long>> measurementsMap = new HashMap();

    public static HealthStatsBuilder newBuilder() {
        return new HealthStatsBuilder();
    }

    @CanIgnoreReturnValue
    public HealthStatsBuilder setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    @CanIgnoreReturnValue
    public HealthStatsBuilder addTimerStat(int key, TimerStat value) {
        this.timerMap.put(key, value);
        return this;
    }

    @CanIgnoreReturnValue
    public HealthStatsBuilder addMeasurement(int key, long value) {
        this.measurementMap.put(key, value);
        return this;
    }

    @CanIgnoreReturnValue
    public HealthStatsBuilder addStats(int key, ArrayMap<String, HealthStats> value) {
        this.statsMap.put(key, (ArrayMap<String, HealthStats>)new ArrayMap(value));
        return this;
    }

    @CanIgnoreReturnValue
    public HealthStatsBuilder addTimers(int key, ArrayMap<String, TimerStat> value) {
        this.timersMap.put(key, (ArrayMap<String, TimerStat>)new ArrayMap(value));
        return this;
    }

    @CanIgnoreReturnValue
    public HealthStatsBuilder addMeasurements(int key, ArrayMap<String, Long> value) {
        this.measurementsMap.put(key, (ArrayMap<String, Long>)new ArrayMap(value));
        return this;
    }

    public HealthStats build() {
        HealthStats result = new HealthStats(Parcel.obtain());
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setDataType(this.dataType);
        int[] mTimerKeys = HealthStatsBuilder.toSortedIntArray(this.timerMap.keySet());
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setTimerKeys(mTimerKeys);
        int[] mTimerCounts = new int[mTimerKeys.length];
        long[] mTimerTimes = new long[mTimerKeys.length];
        for (int i = 0; i < mTimerKeys.length; ++i) {
            TimerStat timerStat = this.timerMap.get(mTimerKeys[i]);
            mTimerCounts[i] = timerStat.getCount();
            mTimerTimes[i] = timerStat.getTime();
        }
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setTimerCounts(mTimerCounts);
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setTimerTimes(mTimerTimes);
        int[] mMeasurementKeys = HealthStatsBuilder.toSortedIntArray(this.measurementMap.keySet());
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setMeasurementKeys(mMeasurementKeys);
        long[] mMeasurementValues = new long[mMeasurementKeys.length];
        for (int i = 0; i < mMeasurementKeys.length; ++i) {
            long measurementValue;
            mMeasurementValues[i] = measurementValue = this.measurementMap.get(mMeasurementKeys[i]).longValue();
        }
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setMeasurementValues(mMeasurementValues);
        int[] mStatsKeys = HealthStatsBuilder.toSortedIntArray(this.statsMap.keySet());
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setStatsKeys(mStatsKeys);
        ArrayMap[] mStatsValues = new ArrayMap[mStatsKeys.length];
        for (int i = 0; i < mStatsKeys.length; ++i) {
            ArrayMap<String, HealthStats> stats;
            mStatsValues[i] = stats = this.statsMap.get(mStatsKeys[i]);
        }
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setStatsValues(mStatsValues);
        int[] mTimersKeys = HealthStatsBuilder.toSortedIntArray(this.timersMap.keySet());
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setTimersKeys(mTimersKeys);
        ArrayMap[] mTimersValues = new ArrayMap[mTimersKeys.length];
        for (int i = 0; i < mTimersKeys.length; ++i) {
            ArrayMap<String, TimerStat> timers;
            mTimersValues[i] = timers = this.timersMap.get(mTimersKeys[i]);
        }
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setTimersValues(mTimersValues);
        int[] mMeasurementsKeys = HealthStatsBuilder.toSortedIntArray(this.measurementsMap.keySet());
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setMeasurementsKeys(mMeasurementsKeys);
        ArrayMap[] mMeasurementsValues = new ArrayMap[mMeasurementsKeys.length];
        for (int i = 0; i < mMeasurementsKeys.length; ++i) {
            ArrayMap<String, Long> measurements;
            mMeasurementsValues[i] = measurements = this.measurementsMap.get(mMeasurementsKeys[i]);
        }
        ((HealthStatsReflector)Reflector.reflector(HealthStatsReflector.class, (Object)result)).setMeasurementsValues(mMeasurementsValues);
        return result;
    }

    private HealthStatsBuilder() {
    }

    @VisibleForTesting
    static int[] toSortedIntArray(Set<Integer> set) {
        int[] result = new int[set.size()];
        Object[] inputObjArray = set.toArray();
        for (int i = 0; i < inputObjArray.length; ++i) {
            result[i] = (Integer)inputObjArray[i];
        }
        Arrays.sort(result);
        return result;
    }

    @ForType(value=HealthStats.class)
    private static interface HealthStatsReflector {
        @Accessor(value="mDataType")
        public void setDataType(String var1);

        @Accessor(value="mTimerKeys")
        public void setTimerKeys(int[] var1);

        @Accessor(value="mTimerCounts")
        public void setTimerCounts(int[] var1);

        @Accessor(value="mTimerTimes")
        public void setTimerTimes(long[] var1);

        @Accessor(value="mMeasurementKeys")
        public void setMeasurementKeys(int[] var1);

        @Accessor(value="mMeasurementValues")
        public void setMeasurementValues(long[] var1);

        @Accessor(value="mStatsKeys")
        public void setStatsKeys(int[] var1);

        @Accessor(value="mStatsValues")
        public void setStatsValues(ArrayMap<String, HealthStats>[] var1);

        @Accessor(value="mTimersKeys")
        public void setTimersKeys(int[] var1);

        @Accessor(value="mTimersValues")
        public void setTimersValues(ArrayMap<String, TimerStat>[] var1);

        @Accessor(value="mMeasurementsKeys")
        public void setMeasurementsKeys(int[] var1);

        @Accessor(value="mMeasurementsValues")
        public void setMeasurementsValues(ArrayMap<String, Long>[] var1);
    }
}

