/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.InputMethod;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import com.android.internal.inputmethod.RemoteAccessibilityInputConnection;
import com.google.auto.value.AutoValue;
import java.util.List;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AutoValue_ShadowAccessibilityInputConnection_CommitTextArgs;
import org.robolectric.shadows.AutoValue_ShadowAccessibilityInputConnection_SurroundingTextArgs;
import org.robolectric.shadows.ShadowRemoteAccessibilityInputConnection;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=InputMethod.AccessibilityInputConnection.class, minSdk=33, isInAndroidSdk=false)
public class ShadowAccessibilityInputConnection {
    @RealObject
    private InputMethod.AccessibilityInputConnection realInputConnection;

    public List<CommitTextArgs> getCommitTextArguments() {
        return this.getRemote().getCommitTextArguments();
    }

    public void setSurroundingText(SurroundingText surroundingText) {
        this.getRemote().setSurroundingText(surroundingText);
    }

    public List<SurroundingTextArgs> getSurroundingTextArguments() {
        return this.getRemote().getSurroundingTextArguments();
    }

    public List<Integer> getContextMenuActions() {
        return this.getRemote().getContextMenuActions();
    }

    public List<Integer> getEditorActions() {
        return this.getRemote().getEditorActions();
    }

    public List<KeyEvent> getKeyEvents() {
        return this.getRemote().getKeyEvents();
    }

    public List<Pair<Integer, Integer>> getSetSelections() {
        return this.getRemote().getSetSelections();
    }

    private ShadowRemoteAccessibilityInputConnection getRemote() {
        return (ShadowRemoteAccessibilityInputConnection)Shadow.extract((Object)((AccessibilityInputConnectionReflector)Reflector.reflector(AccessibilityInputConnectionReflector.class, (Object)this.realInputConnection)).getIc());
    }

    @ForType(value=InputMethod.AccessibilityInputConnection.class)
    static interface AccessibilityInputConnectionReflector {
        @Accessor(value="mIc")
        public RemoteAccessibilityInputConnection getIc();
    }

    @AutoValue
    public static abstract class CommitTextArgs {
        static CommitTextArgs create(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
            return new AutoValue_ShadowAccessibilityInputConnection_CommitTextArgs(text, newCursorPosition, textAttribute);
        }

        public abstract CharSequence text();

        public abstract int newCursorPosition();

        public abstract TextAttribute textAttribute();
    }

    @AutoValue
    public static abstract class SurroundingTextArgs {
        static SurroundingTextArgs create(int beforeLength, int afterLength, int flags) {
            return new AutoValue_ShadowAccessibilityInputConnection_SurroundingTextArgs(beforeLength, afterLength, flags);
        }

        public abstract int beforeLength();

        public abstract int afterLength();

        public abstract int flags();
    }
}

