/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.IAccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=AccountManager.class)
public class ShadowAccountManager {
    private final List<Account> accounts = new ArrayList<Account>();
    private final Map<Account, Map<String, String>> authTokens = new HashMap<Account, Map<String, String>>();
    private final Map<String, AuthenticatorDescription> authenticators = new LinkedHashMap<String, AuthenticatorDescription>();
    private final Map<OnAccountsUpdateListener, Set<String>> listeners = new LinkedHashMap<OnAccountsUpdateListener, Set<String>>();
    private final Map<Account, Map<String, String>> userData = new HashMap<Account, Map<String, String>>();
    private final Map<Account, String> passwords = new HashMap<Account, String>();
    private final Map<Account, Set<String>> accountFeatures = new HashMap<Account, Set<String>>();
    private final Map<Account, Set<String>> packageVisibleAccounts = new HashMap<Account, Set<String>>();
    private final List<Bundle> addAccountOptionsList = new ArrayList<Bundle>();
    private static Handler mainHandler;
    private static RoboAccountManagerFuture pendingAddFuture;
    private static boolean authenticationErrorOnNextResponse;
    private static Intent removeAccountIntent;
    private final Map<Account, String> previousNames = new HashMap<Account, String>();

    @Resetter
    public static void reset() {
        if (mainHandler != null) {
            mainHandler.removeCallbacksAndMessages(null);
            mainHandler = null;
        }
        if (pendingAddFuture != null) {
            pendingAddFuture.cancel(true);
            pendingAddFuture = null;
        }
        authenticationErrorOnNextResponse = false;
        removeAccountIntent = null;
    }

    @Implementation
    protected void __constructor__(Context context, IAccountManager service) {
        mainHandler = new Handler(context.getMainLooper());
    }

    @Implementation
    protected static AccountManager get(Context context) {
        return (AccountManager)context.getSystemService("account");
    }

    @Implementation
    protected Account[] getAccounts() {
        return this.accounts.toArray(new Account[0]);
    }

    @Implementation
    protected Account[] getAccountsByType(String type) {
        if (type == null) {
            return this.getAccounts();
        }
        ArrayList<Account> accountsByType = new ArrayList<Account>();
        for (Account a : this.accounts) {
            if (!type.equals(a.type)) continue;
            accountsByType.add(a);
        }
        return accountsByType.toArray(new Account[0]);
    }

    @Implementation
    protected synchronized void setAuthToken(Account account, String tokenType, String authToken) {
        if (this.accounts.contains(account)) {
            Map<String, String> tokenMap = this.authTokens.get(account);
            if (tokenMap == null) {
                tokenMap = new HashMap<String, String>();
                this.authTokens.put(account, tokenMap);
            }
            tokenMap.put(tokenType, authToken);
        }
    }

    @Implementation
    protected String peekAuthToken(Account account, String tokenType) {
        Map<String, String> tokenMap = this.authTokens.get(account);
        if (tokenMap != null) {
            return tokenMap.get(tokenType);
        }
        return null;
    }

    @Implementation
    protected boolean addAccountExplicitly(Account account, String password, Bundle userdata) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        for (Account a : this.getAccountsByType(account.type)) {
            if (!a.name.equals(account.name)) continue;
            return false;
        }
        if (!this.accounts.add(account)) {
            return false;
        }
        this.setPassword(account, password);
        if (userdata != null) {
            for (String key : userdata.keySet()) {
                this.setUserData(account, key, userdata.get(key).toString());
            }
        }
        this.notifyListeners(account);
        return true;
    }

    @Implementation
    protected String blockingGetAuthToken(Account account, String authTokenType, boolean notifyAuthFailure) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        Map<String, String> tokensForAccount = this.authTokens.get(account);
        if (tokensForAccount == null) {
            return null;
        }
        return tokensForAccount.get(authTokenType);
    }

    @Implementation
    protected AccountManagerFuture<Boolean> removeAccount(final Account account, AccountManagerCallback<Boolean> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return this.start(new BaseRoboAccountManagerFuture<Boolean>(callback, handler){

            @Override
            public Boolean doWork() {
                return ShadowAccountManager.this.removeAccountExplicitly(account);
            }
        });
    }

    @Implementation(minSdk=22)
    protected AccountManagerFuture<Bundle> removeAccount(final Account account, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return this.start(new BaseRoboAccountManagerFuture<Bundle>(callback, handler){

            @Override
            public Bundle doWork() {
                Bundle result = new Bundle();
                if (removeAccountIntent == null) {
                    result.putBoolean("booleanResult", ShadowAccountManager.this.removeAccountExplicitly(account));
                } else {
                    result.putBoolean("booleanResult", false);
                    result.putParcelable("intent", (Parcelable)removeAccountIntent);
                }
                return result;
            }
        });
    }

    @Implementation(minSdk=22)
    protected boolean removeAccountExplicitly(Account account) {
        this.passwords.remove(account);
        this.userData.remove(account);
        if (this.accounts.remove(account)) {
            this.notifyListeners(account);
            return true;
        }
        return false;
    }

    public void removeAllAccounts() {
        this.passwords.clear();
        this.userData.clear();
        this.accounts.clear();
    }

    @Implementation
    protected AuthenticatorDescription[] getAuthenticatorTypes() {
        return this.authenticators.values().toArray(new AuthenticatorDescription[0]);
    }

    @Implementation
    protected void addOnAccountsUpdatedListener(OnAccountsUpdateListener listener, Handler handler, boolean updateImmediately) {
        this.addOnAccountsUpdatedListener(listener, handler, updateImmediately, null);
    }

    @Implementation(minSdk=26)
    protected void addOnAccountsUpdatedListener(@Nullable OnAccountsUpdateListener listener, @Nullable Handler handler, boolean updateImmediately, @Nullable String[] accountTypes) {
        if (this.listeners.containsKey(listener)) {
            return;
        }
        HashSet<String> types = null;
        if (accountTypes != null) {
            types = new HashSet<String>(Arrays.asList(accountTypes));
        }
        this.listeners.put(listener, types);
        if (updateImmediately) {
            this.notifyListener(listener, types, this.getAccounts());
        }
    }

    @Implementation
    protected void removeOnAccountsUpdatedListener(OnAccountsUpdateListener listener) {
        this.listeners.remove(listener);
    }

    @Implementation
    protected String getUserData(Account account, String key) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (!this.userData.containsKey(account)) {
            return null;
        }
        Map<String, String> userDataMap = this.userData.get(account);
        if (userDataMap.containsKey(key)) {
            return userDataMap.get(key);
        }
        return null;
    }

    @Implementation
    protected void setUserData(Account account, String key, String value) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (!this.userData.containsKey(account)) {
            this.userData.put(account, new HashMap());
        }
        Map<String, String> userDataMap = this.userData.get(account);
        if (value == null) {
            userDataMap.remove(key);
        } else {
            userDataMap.put(key, value);
        }
    }

    @Implementation
    protected void setPassword(Account account, String password) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (password == null) {
            this.passwords.remove(account);
        } else {
            this.passwords.put(account, password);
        }
    }

    @Implementation
    protected void clearPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        this.passwords.remove(account);
    }

    @Implementation
    protected String getPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (this.passwords.containsKey(account)) {
            return this.passwords.get(account);
        }
        return null;
    }

    @Implementation
    protected void invalidateAuthToken(String accountType, String authToken) {
        Account[] accountsByType;
        for (Account account : accountsByType = this.getAccountsByType(accountType)) {
            Map<String, String> tokenMap = this.authTokens.get(account);
            if (tokenMap == null) continue;
            Iterator<Map.Entry<String, String>> it = tokenMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> map = it.next();
                if (!map.getValue().equals(authToken)) continue;
                it.remove();
            }
            this.authTokens.put(account, tokenMap);
        }
    }

    @Implementation(minSdk=26)
    protected AccountManagerFuture<Bundle> startAddAccountSession(final String accountType, String authTokenType, String[] requiredFeatures, Bundle options, final Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Bundle>(callback, handler){

            @Override
            public Bundle doWork() throws AuthenticatorException {
                if (!ShadowAccountManager.this.authenticators.containsKey(accountType)) {
                    throw new AuthenticatorException("No authenticator specified for " + accountType);
                }
                Bundle resultBundle = new Bundle();
                if (activity == null) {
                    Intent resultIntent = new Intent();
                    resultBundle.putParcelable("intent", (Parcelable)resultIntent);
                } else {
                    Bundle accountSessionBundle = new Bundle();
                    accountSessionBundle.putString("accountType", accountType);
                    resultBundle.putBundle("accountSessionBundle", Bundle.EMPTY);
                }
                return resultBundle;
            }
        });
    }

    @Implementation(minSdk=26)
    protected AccountManagerFuture<Bundle> finishSession(final Bundle sessionBundle, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Bundle>(callback, handler){

            @Override
            public Bundle doWork() {
                return sessionBundle;
            }
        });
    }

    private void notifyListener(OnAccountsUpdateListener listener, @Nullable Set<String> accountTypesToReportOn, Account[] allAccounts) {
        if (accountTypesToReportOn != null) {
            ArrayList<Account> filtered = new ArrayList<Account>();
            for (Account account : allAccounts) {
                if (!accountTypesToReportOn.contains(account.type)) continue;
                filtered.add(account);
            }
            listener.onAccountsUpdated(filtered.toArray(new Account[0]));
        } else {
            listener.onAccountsUpdated(allAccounts);
        }
    }

    private void notifyListeners(Account changedAccount) {
        Account[] accounts = this.getAccounts();
        for (Map.Entry<OnAccountsUpdateListener, Set<String>> entry : this.listeners.entrySet()) {
            OnAccountsUpdateListener listener = entry.getKey();
            Set<String> types = entry.getValue();
            if (types != null && !types.contains(changedAccount.type)) continue;
            this.notifyListener(listener, types, accounts);
        }
    }

    public void addAccount(Account account) {
        this.accounts.add(account);
        if (pendingAddFuture != null) {
            pendingAddFuture.resultBundle.putString("authAccount", account.name);
            this.start(pendingAddFuture);
            pendingAddFuture = null;
        }
        this.notifyListeners(account);
    }

    public void addAccount(Account account, String ... visibleToPackages) {
        this.addAccount(account);
        HashSet value = new HashSet();
        Collections.addAll(value, visibleToPackages);
        this.packageVisibleAccounts.put(account, value);
    }

    public Bundle getNextAddAccountOptions() {
        if (this.addAccountOptionsList.isEmpty()) {
            return null;
        }
        return this.addAccountOptionsList.remove(0);
    }

    public Bundle peekNextAddAccountOptions() {
        if (this.addAccountOptionsList.isEmpty()) {
            return null;
        }
        return this.addAccountOptionsList.get(0);
    }

    @Implementation
    protected AccountManagerFuture<Bundle> addAccount(String accountType, String authTokenType, String[] requiredFeatures, Bundle addAccountOptions, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        this.addAccountOptionsList.add(addAccountOptions);
        if (activity == null) {
            RoboAccountManagerFuture future = new RoboAccountManagerFuture(callback, handler, accountType, null);
            this.start(future);
            return future;
        }
        pendingAddFuture = new RoboAccountManagerFuture(callback, handler, accountType, activity);
        return pendingAddFuture;
    }

    public void setFeatures(Account account, String[] accountFeatures) {
        HashSet<String> featureSet = new HashSet<String>(Arrays.asList(accountFeatures));
        this.accountFeatures.put(account, featureSet);
    }

    public void addAuthenticator(AuthenticatorDescription authenticator) {
        this.authenticators.put(authenticator.type, authenticator);
    }

    public void addAuthenticator(String type) {
        this.addAuthenticator(AuthenticatorDescription.newKey((String)type));
    }

    public void setPreviousAccountName(Account account, String previousName) {
        this.previousNames.put(account, previousName);
    }

    @Implementation
    protected String getPreviousName(Account account) {
        return this.previousNames.get(account);
    }

    @Implementation
    protected AccountManagerFuture<Bundle> getAuthToken(final Account account, final String authTokenType, Bundle options, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Bundle>(callback, handler){

            @Override
            public Bundle doWork() throws AuthenticatorException {
                return ShadowAccountManager.this.getAuthToken(account, authTokenType);
            }
        });
    }

    @Implementation
    protected AccountManagerFuture<Bundle> getAuthToken(final Account account, final String authTokenType, Bundle options, boolean notifyAuthFailure, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Bundle>(callback, handler){

            @Override
            public Bundle doWork() throws AuthenticatorException {
                return ShadowAccountManager.this.getAuthToken(account, authTokenType);
            }
        });
    }

    private Bundle getAuthToken(Account account, String authTokenType) throws AuthenticatorException {
        Bundle result = new Bundle();
        String authToken = this.blockingGetAuthToken(account, authTokenType, false);
        result.putString("authAccount", account.name);
        result.putString("accountType", account.type);
        result.putString("authtoken", authToken);
        if (authToken != null) {
            return result;
        }
        if (!this.authenticators.containsKey(account.type)) {
            throw new AuthenticatorException("No authenticator specified for " + account.type);
        }
        Intent resultIntent = new Intent();
        result.putParcelable("intent", (Parcelable)resultIntent);
        return result;
    }

    @Implementation
    protected AccountManagerFuture<Boolean> hasFeatures(final Account account, final String[] features, AccountManagerCallback<Boolean> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Boolean>(callback, handler){

            @Override
            public Boolean doWork() {
                Set availableFeatures = (Set)ShadowAccountManager.this.accountFeatures.get(account);
                for (String feature : features) {
                    if (availableFeatures.contains(feature)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Implementation
    protected AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(final String type, final String[] features, AccountManagerCallback<Account[]> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Account[]>(callback, handler){

            @Override
            public Account[] doWork() throws AuthenticatorException {
                Account[] accountsByType;
                if (authenticationErrorOnNextResponse) {
                    ShadowAccountManager.this.setAuthenticationErrorOnNextResponse(false);
                    throw new AuthenticatorException();
                }
                ArrayList<Account> result = new ArrayList<Account>();
                for (Account account : accountsByType = ShadowAccountManager.this.getAccountsByType(type)) {
                    Set featureSet = (Set)ShadowAccountManager.this.accountFeatures.get(account);
                    if (features != null && (featureSet == null || !featureSet.containsAll(Arrays.asList(features)))) continue;
                    result.add(account);
                }
                return result.toArray(new Account[0]);
            }
        });
    }

    private <T extends BaseRoboAccountManagerFuture> T start(T future) {
        future.start();
        return future;
    }

    @Implementation
    protected Account[] getAccountsByTypeForPackage(String type, String packageName) {
        Account[] accountsByType;
        ArrayList<Account> result = new ArrayList<Account>();
        for (Account account : accountsByType = this.getAccountsByType(type)) {
            if (!this.packageVisibleAccounts.containsKey(account) || !this.packageVisibleAccounts.get(account).contains(packageName)) continue;
            result.add(account);
        }
        return result.toArray(new Account[0]);
    }

    public void setAuthenticationErrorOnNextResponse(boolean authenticationErrorOnNextResponse) {
        ShadowAccountManager.authenticationErrorOnNextResponse = authenticationErrorOnNextResponse;
    }

    public void setRemoveAccountIntent(Intent removeAccountIntent) {
        ShadowAccountManager.removeAccountIntent = removeAccountIntent;
    }

    public Map<OnAccountsUpdateListener, Set<String>> getListeners() {
        return this.listeners;
    }

    static {
        authenticationErrorOnNextResponse = false;
    }

    private class RoboAccountManagerFuture
    extends BaseRoboAccountManagerFuture<Bundle> {
        private final String accountType;
        private final Activity activity;
        private final Bundle resultBundle;

        RoboAccountManagerFuture(AccountManagerCallback<Bundle> callback, Handler handler, String accountType, Activity activity) {
            super(callback, handler);
            this.accountType = accountType;
            this.activity = activity;
            this.resultBundle = new Bundle();
        }

        @Override
        public Bundle doWork() throws AuthenticatorException {
            if (!ShadowAccountManager.this.authenticators.containsKey(this.accountType)) {
                throw new AuthenticatorException("No authenticator specified for " + this.accountType);
            }
            this.resultBundle.putString("accountType", this.accountType);
            if (this.activity == null) {
                Intent resultIntent = new Intent();
                this.resultBundle.putParcelable("intent", (Parcelable)resultIntent);
            } else if (this.callback == null) {
                this.resultBundle.putString("authAccount", "some_user@gmail.com");
            }
            return this.resultBundle;
        }
    }

    private static abstract class BaseRoboAccountManagerFuture<T>
    implements AccountManagerFuture<T> {
        protected final AccountManagerCallback<T> callback;
        private final Handler handler;
        protected T result;
        private Exception exception;
        private boolean started = false;

        BaseRoboAccountManagerFuture(AccountManagerCallback<T> callback, Handler handler) {
            this.callback = callback;
            this.handler = handler == null ? mainHandler : handler;
        }

        void start() {
            if (this.started) {
                return;
            }
            this.started = true;
            try {
                this.result = this.doWork();
            }
            catch (AuthenticatorException | OperationCanceledException | IOException e) {
                this.exception = e;
            }
            if (this.callback != null) {
                this.handler.post(() -> this.callback.run((AccountManagerFuture)this));
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return this.result != null || this.exception != null || this.isCancelled();
        }

        public T getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            this.start();
            if (this.exception instanceof OperationCanceledException) {
                throw new OperationCanceledException((Throwable)this.exception);
            }
            if (this.exception instanceof IOException) {
                throw new IOException(this.exception);
            }
            if (this.exception instanceof AuthenticatorException) {
                throw new AuthenticatorException((Throwable)this.exception);
            }
            return this.result;
        }

        public T getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            return this.getResult();
        }

        public abstract T doWork() throws OperationCanceledException, IOException, AuthenticatorException;
    }
}

