/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.util.LongSparseArray;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowResources;
import org.robolectric.shadows.ShadowResourcesImpl;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ResourcesImpl.class, isInAndroidSdk=false, minSdk=24, shadowPicker=ShadowResourcesImpl.Picker.class)
public class ShadowArscResourcesImpl
extends ShadowResourcesImpl {
    private static List<LongSparseArray<?>> resettableArrays;
    @RealObject
    ResourcesImpl realResourcesImpl;

    private static List<LongSparseArray<?>> obtainResettableArrays() {
        Field[] allFields;
        ArrayList resettableArrays = new ArrayList();
        for (Field field : allFields = Resources.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(LongSparseArray.class)) continue;
            field.setAccessible(true);
            try {
                LongSparseArray longSparseArray = (LongSparseArray)field.get(null);
                if (longSparseArray == null) continue;
                resettableArrays.add(longSparseArray);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return resettableArrays;
    }

    @Implementation(maxSdk=23)
    public AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        InputStream inputStream = ((ResourcesImplReflector)Reflector.reflector(ResourcesImplReflector.class, (Object)this.realResourcesImpl)).openRawResource(id2);
        if (!(inputStream instanceof FileInputStream)) {
            return null;
        }
        FileInputStream fis = (FileInputStream)inputStream;
        try {
            return new AssetFileDescriptor(ParcelFileDescriptor.dup((FileDescriptor)fis.getFD()), 0L, fis.getChannel().size());
        }
        catch (IOException e) {
            throw this.newNotFoundException(id2);
        }
    }

    private Resources.NotFoundException newNotFoundException(int id2) {
        return new Resources.NotFoundException("resource ID #0x" + Integer.toHexString(id2));
    }

    @Implementation(maxSdk=25)
    public Drawable loadDrawable(Resources wrapper, TypedValue value, int id2, Resources.Theme theme, boolean useCache) throws Resources.NotFoundException {
        Drawable drawable2 = ((ResourcesImplReflector)Reflector.reflector(ResourcesImplReflector.class, (Object)this.realResourcesImpl)).loadDrawable(wrapper, value, id2, theme, useCache);
        ShadowResources.setCreatedFromResId(wrapper, id2, drawable2);
        return drawable2;
    }

    @Implementation(minSdk=26)
    public Drawable loadDrawable(Resources wrapper, TypedValue value, int id2, int density, Resources.Theme theme) {
        Drawable drawable2 = ((ResourcesImplReflector)Reflector.reflector(ResourcesImplReflector.class, (Object)this.realResourcesImpl)).loadDrawable(wrapper, value, id2, density, theme);
        ShadowResources.setCreatedFromResId(wrapper, id2, drawable2);
        return drawable2;
    }

    @ForType(value=ResourcesImpl.class)
    static interface ResourcesImplReflector {
        @Direct
        public InputStream openRawResource(int var1);

        @Direct
        public Drawable loadDrawable(Resources var1, TypedValue var2, int var3, Resources.Theme var4, boolean var5);

        @Direct
        public Drawable loadDrawable(Resources var1, TypedValue var2, int var3, int var4, Resources.Theme var5);
    }
}

