/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSurfaceView;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=GLSurfaceView.class)
public class ShadowGLSurfaceView
extends ShadowSurfaceView {
    private static final ConcurrentLinkedQueue<WeakReference<GLSurfaceView>> surfaceViews = new ConcurrentLinkedQueue();
    @RealObject
    private GLSurfaceView realSurfaceView;

    @Implementation
    protected void __constructor__(Context context) {
        ((GLSurfaceViewReflector)Reflector.reflector(GLSurfaceViewReflector.class, (Object)this.realSurfaceView)).__constructor__(context);
        surfaceViews.add(new WeakReference<GLSurfaceView>(this.realSurfaceView));
    }

    @Implementation
    protected void __constructor__(Context context, AttributeSet attrs) {
        ((GLSurfaceViewReflector)Reflector.reflector(GLSurfaceViewReflector.class, (Object)this.realSurfaceView)).__constructor__(context, attrs);
        surfaceViews.add(new WeakReference<GLSurfaceView>(this.realSurfaceView));
    }

    @Implementation
    protected void onPause() {
    }

    @Implementation
    protected void onResume() {
    }

    private static void requestExitAndWaitGlThread(GLSurfaceView view) {
        Object glThread = ((GLSurfaceViewReflector)Reflector.reflector(GLSurfaceViewReflector.class, (Object)view)).getGLThread();
        if (glThread != null) {
            ReflectionHelpers.callInstanceMethod((Object)glThread, (String)"requestExitAndWait", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    @Resetter
    public static void reset() {
        WeakReference<GLSurfaceView> surfaceView;
        while ((surfaceView = surfaceViews.poll()) != null) {
            GLSurfaceView view = (GLSurfaceView)surfaceView.get();
            if (view == null) continue;
            ShadowGLSurfaceView.requestExitAndWaitGlThread(view);
        }
    }

    @ForType(value=GLSurfaceView.class)
    static interface GLSurfaceViewReflector {
        @Accessor(value="mGLThread")
        public Object getGLThread();

        @Direct
        public void __constructor__(Context var1);

        @Direct
        public void __constructor__(Context var1, AttributeSet var2);
    }
}

