/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.Locale;
import libcore.icu.LocaleData;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=LocaleData.class, isInAndroidSdk=false, maxSdk=32)
public class ShadowLocaleData {
    public static final String REAL_CLASS_NAME = "libcore.icu.LocaleData";

    @Implementation
    public static LocaleData get(Locale locale) {
        LocaleData localeData = (LocaleData)Shadow.newInstanceOf((String)REAL_CLASS_NAME);
        ShadowLocaleData.setEnUsLocaleData(localeData);
        return localeData;
    }

    private static void setEnUsLocaleData(LocaleData localeData) {
        localeData.amPm = new String[]{"AM", "PM"};
        localeData.eras = new String[]{"BC", "AD"};
        localeData.firstDayOfWeek = 1;
        localeData.minimalDaysInFirstWeek = 1;
        localeData.longMonthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        localeData.shortMonthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        LocaleDataReflector localDataReflector = (LocaleDataReflector)Reflector.reflector(LocaleDataReflector.class, (Object)localeData);
        localeData.tinyMonthNames = new String[]{"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"};
        localeData.tinyStandAloneMonthNames = localeData.tinyMonthNames;
        localeData.tinyWeekdayNames = new String[]{"", "S", "M", "T", "W", "T", "F", "S"};
        localeData.tinyStandAloneWeekdayNames = localeData.tinyWeekdayNames;
        if (RuntimeEnvironment.getApiLevel() <= 30) {
            localDataReflector.setYesterday("Yesterday");
        }
        localeData.today = "Today";
        localeData.tomorrow = "Tomorrow";
        localeData.longStandAloneMonthNames = localeData.longMonthNames;
        localeData.shortStandAloneMonthNames = localeData.shortMonthNames;
        localeData.longWeekdayNames = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        localeData.shortWeekdayNames = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        localeData.longStandAloneWeekdayNames = localeData.longWeekdayNames;
        localeData.shortStandAloneWeekdayNames = localeData.shortWeekdayNames;
        localDataReflector.setFullTimeFormat("h:mm:ss a zzzz");
        localDataReflector.setLongTimeFormat("h:mm:ss a z");
        localDataReflector.setMediumTimeFormat("h:mm:ss a");
        localDataReflector.setShortTimeFormat("h:mm a");
        if (RuntimeEnvironment.getApiLevel() >= 23) {
            localeData.timeFormat_hm = "h:mm a";
            localeData.timeFormat_Hm = "HH:mm";
        } else {
            localDataReflector.setTimeFormat12("h:mm a");
            localDataReflector.setTimeFormat24("HH:mm");
        }
        localDataReflector.setFullDateFormat("EEEE, MMMM d, y");
        localDataReflector.setLongDateFormat("MMMM d, y");
        localDataReflector.setMediumDateFormat("MMM d, y");
        localDataReflector.setShortDateFormat("M/d/yy");
        if (RuntimeEnvironment.getApiLevel() < 23) {
            localDataReflector.setShortDateFormat4("M/d/yyyy");
        }
        localeData.zeroDigit = (char)48;
        localDataReflector.setDecimalSeparator('.');
        localDataReflector.setGroupingSeparator(',');
        localDataReflector.setPatternSeparator(';');
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            localDataReflector.setPercent("%");
        } else {
            localDataReflector.setPercent('%');
        }
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            localDataReflector.setPerMill("\u2030");
        } else {
            localDataReflector.setPerMill('\u2030');
        }
        localDataReflector.setMonetarySeparator('.');
        localDataReflector.setMinusSign("-");
        localDataReflector.setExponentSeparator("E");
        localDataReflector.setInfinity("\u221e");
        localDataReflector.setNaN("NaN");
        if (RuntimeEnvironment.getApiLevel() <= 30) {
            localDataReflector.setCurrencySymbol("$");
            localDataReflector.setInternationalCurrencySymbol("USD");
        }
        localDataReflector.setNumberPattern("#,##0.###");
        localDataReflector.setIntegerPattern("#,##0");
        localDataReflector.setCurrencyPattern("\u00a4#,##0.00;(\u00a4#,##0.00)");
        localDataReflector.setPercentPattern("#,##0%");
    }

    @ForType(value=LocaleData.class)
    static interface LocaleDataReflector {
        @Accessor(value="minusSign")
        public void setMinusSign(char var1);

        @Accessor(value="percent")
        public void setPercent(char var1);

        @Accessor(value="perMill")
        public void setPerMill(char var1);

        @Accessor(value="timeFormat12")
        public void setTimeFormat12(String var1);

        @Accessor(value="timeFormat24")
        public void setTimeFormat24(String var1);

        @Accessor(value="shortDateFormat4")
        public void setShortDateFormat4(String var1);

        @Accessor(value="yesterday")
        public void setYesterday(String var1);

        @Accessor(value="currencySymbol")
        public void setCurrencySymbol(String var1);

        @Accessor(value="internationalCurrencySymbol")
        public void setInternationalCurrencySymbol(String var1);

        @Accessor(value="fullTimeFormat")
        public void setFullTimeFormat(String var1);

        @Accessor(value="longTimeFormat")
        public void setLongTimeFormat(String var1);

        @Accessor(value="mediumTimeFormat")
        public void setMediumTimeFormat(String var1);

        @Accessor(value="shortTimeFormat")
        public void setShortTimeFormat(String var1);

        @Accessor(value="fullDateFormat")
        public void setFullDateFormat(String var1);

        @Accessor(value="longDateFormat")
        public void setLongDateFormat(String var1);

        @Accessor(value="mediumDateFormat")
        public void setMediumDateFormat(String var1);

        @Accessor(value="shortDateFormat")
        public void setShortDateFormat(String var1);

        @Accessor(value="decimalSeparator")
        public void setDecimalSeparator(char var1);

        @Accessor(value="groupingSeparator")
        public void setGroupingSeparator(char var1);

        @Accessor(value="patternSeparator")
        public void setPatternSeparator(char var1);

        @Accessor(value="percent")
        public void setPercent(String var1);

        @Accessor(value="perMill")
        public void setPerMill(String var1);

        @Accessor(value="monetarySeparator")
        public void setMonetarySeparator(char var1);

        @Accessor(value="minusSign")
        public void setMinusSign(String var1);

        @Accessor(value="exponentSeparator")
        public void setExponentSeparator(String var1);

        @Accessor(value="infinity")
        public void setInfinity(String var1);

        @Accessor(value="NaN")
        public void setNaN(String var1);

        @Accessor(value="numberPattern")
        public void setNumberPattern(String var1);

        @Accessor(value="integerPattern")
        public void setIntegerPattern(String var1);

        @Accessor(value="currencyPattern")
        public void setCurrencyPattern(String var1);

        @Accessor(value="percentPattern")
        public void setPercentPattern(String var1);
    }
}

