/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.FrameInfo;
import android.os.Looper;
import android.view.Choreographer;
import android.view.DisplayEventReceiver;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.shadows.ShadowDisplayEventReceiver;
import org.robolectric.shadows.ShadowPausedLooper;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Choreographer.class, shadowPicker=ShadowChoreographer.Picker.class, isInAndroidSdk=false)
public class ShadowPausedChoreographer
extends ShadowChoreographer {
    private static final Set<Choreographer> activeChoreographers = new CopyOnWriteArraySet<Choreographer>();
    @RealObject
    private Choreographer realChoreographer;

    @Implementation(maxSdk=25)
    protected void __constructor__(Looper looper) {
        ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realChoreographer)).__constructor__(looper);
        activeChoreographers.add(this.realChoreographer);
    }

    @Implementation(minSdk=26, maxSdk=33)
    protected void __constructor__(Looper looper, int vsyncSource) {
        ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realChoreographer)).__constructor__(looper, vsyncSource);
        activeChoreographers.add(this.realChoreographer);
    }

    @Implementation(minSdk=34)
    protected void __constructor__(Looper looper, int vsyncSource, long layerHandle) {
        ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realChoreographer)).__constructor__(looper, vsyncSource, layerHandle);
        activeChoreographers.add(this.realChoreographer);
    }

    @Implementation(minSdk=24)
    protected void dispose() {
        activeChoreographers.remove(this.realChoreographer);
    }

    static void resetChoreographers() {
        for (Choreographer choreographer : activeChoreographers) {
            Looper looper = ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)choreographer)).getLooper();
            ShadowPausedChoreographer shadowChoreographer = (ShadowPausedChoreographer)Shadow.extract((Object)choreographer);
            if (looper.getThread() == Thread.currentThread()) {
                shadowChoreographer.resetState();
                continue;
            }
            if (!looper.getThread().isAlive()) continue;
            ShadowPausedLooper shadowLooper = (ShadowPausedLooper)Shadow.extract((Object)looper);
            shadowLooper.postSyncQuiet(shadowChoreographer::resetState);
        }
    }

    private void resetState() {
        Object[] callbackQueues;
        ShadowChoreographer.ChoreographerReflector choreographerReflector = (ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realChoreographer);
        choreographerReflector.setLastFrameTimeNanos(Long.MIN_VALUE);
        if (RuntimeEnvironment.getApiLevel() >= 31) {
            choreographerReflector.setLastFrameIntervalNanos(0L);
        }
        choreographerReflector.setFrameScheduled(false);
        for (Object callbackQueue : callbackQueues = choreographerReflector.getCallbackQueues()) {
            ((ShadowChoreographer.CallbackQueueReflector)Reflector.reflector(ShadowChoreographer.CallbackQueueReflector.class, (Object)callbackQueue)).setHead(null);
        }
        choreographerReflector.setCallbackPool(null);
        choreographerReflector.setCallbacksRunning(false);
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            ReflectionHelpers.callInstanceMethod((Object)choreographerReflector.getFrameData(), (String)"update", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
        }
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            Arrays.fill(((FrameInfo)choreographerReflector.getFrameInfo()).frameInfo, 0L);
        }
        DisplayEventReceiver receiver = ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realObject)).getReceiver();
        ShadowDisplayEventReceiver shadowReceiver = (ShadowDisplayEventReceiver)Shadow.extract((Object)receiver);
        shadowReceiver.resetState();
    }

    @VisibleForTesting
    boolean isInitialized() {
        DisplayEventReceiver receiver = ((ShadowChoreographer.ChoreographerReflector)Reflector.reflector(ShadowChoreographer.ChoreographerReflector.class, (Object)this.realObject)).getReceiver();
        return ((ShadowDisplayEventReceiver.DisplayEventReceiverReflector)Reflector.reflector(ShadowDisplayEventReceiver.DisplayEventReceiverReflector.class, (Object)receiver)).getReceiverPtr() != 0L;
    }
}

