/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=SQLiteOpenHelper.class)
public class ShadowSQLiteOpenHelper {
    @RealObject
    private SQLiteOpenHelper realSQLiteOpenHelper;
    public static final long IDLE_CONNECTION_TIMEOUT_DISABLED = -1L;
    private long idleConnectionTimeoutMs = -1L;

    public long getIdleConnectionTimeout() {
        return this.idleConnectionTimeoutMs;
    }

    @RequiresApi(api=28)
    public SQLiteDatabase.OpenParams getOpenParams() {
        SQLiteDatabase.OpenParams.Builder openParamsBuilder = ((SQLiteOpenHelperReflector)Reflector.reflector(SQLiteOpenHelperReflector.class, (Object)this.realSQLiteOpenHelper)).getOpenParamsBuilder();
        if (this.idleConnectionTimeoutMs != -1L) {
            openParamsBuilder = new SQLiteDatabase.OpenParams.Builder(openParamsBuilder.build()).setIdleConnectionTimeout(this.idleConnectionTimeoutMs);
        }
        return openParamsBuilder.build();
    }

    @Implementation(minSdk=27)
    protected void setIdleConnectionTimeout(long idleConnectionTimeoutMs) {
        this.idleConnectionTimeoutMs = idleConnectionTimeoutMs;
    }

    @Implementation(minSdk=28)
    protected void setOpenParams(SQLiteDatabase.OpenParams openParams) {
        this.idleConnectionTimeoutMs = openParams.getIdleConnectionTimeout();
        if (openParams.getIdleConnectionTimeout() != -1L) {
            openParams = new SQLiteDatabase.OpenParams.Builder(openParams).build();
        }
        ((SQLiteOpenHelperReflector)Reflector.reflector(SQLiteOpenHelperReflector.class, (Object)this.realSQLiteOpenHelper)).setOpenParams(openParams);
    }

    @ForType(value=SQLiteOpenHelper.class)
    private static interface SQLiteOpenHelperReflector {
        @Direct
        public void setOpenParams(SQLiteDatabase.OpenParams var1);

        @Accessor(value="mOpenParamsBuilder")
        public SQLiteDatabase.OpenParams.Builder getOpenParamsBuilder();
    }
}

