/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Intent;
import android.net.PlatformVpnProfile;
import android.net.VpnManager;
import android.net.VpnProfileState;
import java.util.UUID;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=VpnManager.class, minSdk=30, isInAndroidSdk=false)
public class ShadowVpnManager {
    private static VpnProfileState vpnProfileState;
    private static Intent provisionVpnProfileIntent;

    @Implementation
    protected void deleteProvisionedVpnProfile() {
        vpnProfileState = null;
    }

    @Implementation(minSdk=33)
    protected VpnProfileState getProvisionedVpnProfileState() {
        return vpnProfileState;
    }

    @Implementation
    protected Intent provisionVpnProfile(PlatformVpnProfile profile) {
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            vpnProfileState = new VpnProfileState(0, null, false, false);
        }
        return provisionVpnProfileIntent;
    }

    public void setProvisionVpnProfileResult(Intent intent) {
        provisionVpnProfileIntent = intent;
    }

    @Implementation
    protected void startProvisionedVpnProfile() {
        this.startProvisionedVpnProfileSession();
    }

    @Implementation(minSdk=33)
    protected String startProvisionedVpnProfileSession() {
        String sessionKey = UUID.randomUUID().toString();
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            vpnProfileState = new VpnProfileState(2, sessionKey, false, false);
        }
        return sessionKey;
    }

    @Implementation
    protected void stopProvisionedVpnProfile() {
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            vpnProfileState = new VpnProfileState(0, null, false, false);
        }
    }

    @Resetter
    public static void reset() {
        vpnProfileState = null;
        provisionVpnProfileIntent = null;
    }
}

