/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.os.CancellationSignal;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.fakes.MediaUriMatcher;

public final class FakeMediaProvider
extends ContentProvider {
    private static final String TABLE_NAME = "files";
    private Supplier<SQLiteDatabase> dbSupplier;
    private final Random displayNameRandom = new Random();
    private final MediaUriMatcher uriMatcher = new MediaUriMatcher("media");
    private final AtomicBoolean initialized = new AtomicBoolean();
    private static final String TAG = "FakeMediaProvider";

    public boolean onCreate() {
        Preconditions.checkArgument((RuntimeEnvironment.getApiLevel() >= 29 ? 1 : 0) != 0);
        this.dbSupplier = Suppliers.memoize(() -> {
            SQLiteDatabase db = SQLiteDatabase.create(null);
            db.execSQL(FakeMediaProvider.createTableStatement());
            this.initialized.set(true);
            return db;
        });
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder, null);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        Objects.requireNonNull(uri);
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables(TABLE_NAME);
        int uriType = this.uriMatcher.matchUri(uri);
        switch (uriType) {
            case 2: 
            case 5: 
            case 101: 
            case 111: 
            case 120: 
            case 201: 
            case 204: 
            case 701: 
            case 801: {
                qb.appendWhere((CharSequence)("_id=" + uri.getLastPathSegment()));
                break;
            }
        }
        Cursor cursor = qb.query((SQLiteDatabase)this.dbSupplier.get(), projection, selection, selectionArgs, null, null, sortOrder, null, cancellationSignal);
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public String getType(Uri uri) {
        int match = this.uriMatcher.matchUri(uri);
        switch (match) {
            case 2: 
            case 101: 
            case 111: 
            case 113: 
            case 201: 
            case 701: 
            case 801: {
                return this.queryForType(uri);
            }
            case 1: 
            case 4: {
                return "vnd.android.cursor.dir/image";
            }
            case 5: 
            case 120: 
            case 121: 
            case 204: {
                return "image/jpeg";
            }
            case 100: 
            case 108: 
            case 112: {
                return "vnd.android.cursor.dir/audio";
            }
            case 102: 
            case 106: {
                return "vnd.android.cursor.dir/genre";
            }
            case 103: 
            case 107: {
                return "vnd.android.cursor.item/genre";
            }
            case 110: {
                return "vnd.android.cursor.dir/playlist";
            }
            case 200: {
                return "vnd.android.cursor.dir/video";
            }
            case 800: {
                return "vnd.android.cursor.dir/download";
            }
        }
        throw new IllegalStateException("Unknown URI : " + uri);
    }

    private String queryForType(Uri url) {
        Cursor cursor = this.queryForSingleItem(url, new String[]{"mime_type"}, null, null);
        return cursor.getString(0);
    }

    private Cursor queryForSingleItem(Uri uri, String[] projection, String selection, String[] selectionArgs) {
        Cursor c = this.query(uri, projection, selection, selectionArgs, null);
        if (c == null) {
            throw new IllegalArgumentException("Failed to find single item for uri " + uri);
        }
        if (c.getCount() != 1 || !c.moveToFirst()) {
            c.close();
            throw new IllegalArgumentException("Failed to find single item for uri " + uri);
        }
        return c;
    }

    public Uri insert(Uri uri, ContentValues originalValues) {
        String relativePath;
        String currentDisplayExtension;
        ContentValues values = new ContentValues(Objects.requireNonNull(originalValues));
        int match = this.uriMatcher.matchUri(uri);
        Preconditions.checkState((match != -1 ? 1 : 0) != 0, (Object)("Unrecognized uri " + uri.toString()));
        if (match == 111 || match == 112) {
            Log.w((String)TAG, (String)"Ignoring insert of unsupported playlist members");
            return null;
        }
        String displayName = values.getAsString("_display_name");
        String mimeType = values.getAsString("mime_type");
        String string2 = currentDisplayExtension = displayName != null ? Files.getFileExtension((String)displayName) : "";
        if (TextUtils.isEmpty((CharSequence)currentDisplayExtension) && TextUtils.isEmpty((CharSequence)mimeType) && !TextUtils.isEmpty((CharSequence)displayName)) {
            throw new IllegalArgumentException("Could not determine mime type ");
        }
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            displayName = String.valueOf(this.displayNameRandom.nextInt());
            values.put("_display_name", displayName);
        }
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            if (TextUtils.isEmpty((CharSequence)currentDisplayExtension)) {
                mimeType = this.getDefaultMimeTypeFromUri(match);
            } else {
                mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(currentDisplayExtension);
                if (TextUtils.isEmpty((CharSequence)mimeType)) {
                    throw new IllegalArgumentException("Could not guess mimeType from name " + displayName);
                }
            }
            values.put("mime_type", mimeType);
        }
        this.validateMimeType(match, mimeType);
        String mimeTypeFromExtension = MimeTypeMap.getSingleton().getMimeTypeFromExtension(currentDisplayExtension);
        if (mimeTypeFromExtension == null || !mimeTypeFromExtension.equals(mimeType)) {
            String extensionFromMime = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            if (extensionFromMime == null) {
                throw new IllegalArgumentException("Unsupported MIME type " + mimeType);
            }
            displayName = displayName + "." + extensionFromMime;
            values.put("_display_name", displayName);
        }
        if (TextUtils.isEmpty((CharSequence)(relativePath = values.getAsString("relative_path")))) {
            relativePath = this.getDefaultRelativePath(match);
            values.put("relative_path", relativePath + "/");
        } else {
            this.validateRelativePath(mimeType, relativePath);
        }
        this.validateRelativePath(relativePath, values.getAsString("relative_path"));
        values.put("date_added", Long.valueOf(System.currentTimeMillis() / 1000L));
        values.put("bucket_display_name", relativePath.split("/")[0]);
        String baseFileName = Files.getNameWithoutExtension((String)displayName);
        if (TextUtils.isEmpty((CharSequence)values.getAsString("title"))) {
            values.put("title", baseFileName);
        }
        values.remove("media_type");
        if (!values.containsKey("is_pending")) {
            values.put("is_pending", Boolean.valueOf(false));
        }
        String dataPath = Paths.get(Environment.getExternalStorageDirectory().toString(), relativePath, this.makeUniqueFileName(baseFileName, Files.getFileExtension((String)displayName))).toAbsolutePath().toString();
        if (values.containsKey("_data")) {
            throw new IllegalArgumentException("Mutation of _data is not allowed");
        }
        values.put("_data", dataPath);
        long rowId = ((SQLiteDatabase)this.dbSupplier.get()).insert(TABLE_NAME, null, values);
        return rowId > 0L ? ContentUris.withAppendedId((Uri)uri, (long)rowId) : null;
    }

    private String makeUniqueFileName(String baseName, String ext) {
        return String.format("%s-%d.%s", baseName, this.displayNameRandom.nextInt(), ext);
    }

    private String getDefaultRelativePath(int match) {
        switch (match) {
            case 100: 
            case 101: 
            case 110: 
            case 111: {
                return Environment.DIRECTORY_MUSIC;
            }
            case 200: 
            case 201: {
                return Environment.DIRECTORY_MOVIES;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 119: 
            case 120: 
            case 203: 
            case 204: {
                return Environment.DIRECTORY_PICTURES;
            }
        }
        return Environment.DIRECTORY_DOWNLOADS;
    }

    private String getDefaultMimeTypeFromUri(int match) {
        switch (match) {
            case 100: 
            case 101: {
                return "audio/mpeg";
            }
            case 200: 
            case 201: {
                return "video/mp4";
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 119: 
            case 120: 
            case 203: 
            case 204: {
                return "image/jpeg";
            }
            case 110: 
            case 111: {
                return "audio/mpegurl";
            }
        }
        return "application/octet-stream";
    }

    private void validateMimeType(int match, String mimeType) {
        if (match == 100 && !mimeType.startsWith("audio")) {
            throw new IllegalArgumentException("Invalid mimeType for uri " + mimeType + " " + match);
        }
        if (match == 200 && !mimeType.startsWith("video")) {
            throw new IllegalArgumentException("Invalid mimeType for uri " + mimeType + " " + match);
        }
        if (match == 1 && !mimeType.startsWith("image")) {
            throw new IllegalArgumentException("Invalid mimeType for uri " + mimeType + " " + match);
        }
    }

    private void validateRelativePath(String mimeType, String relativePath) {
        if (mimeType.startsWith("video")) {
            String primaryDir = relativePath.split("/")[0];
            ImmutableSet allowedPaths = ImmutableSet.of((Object)"DCIM", (Object)"Movies", (Object)"Pictures");
            if (!allowedPaths.contains((Object)primaryDir)) {
                throw new IllegalArgumentException(String.format("Primary directory %s not allowed for content://media/external/video/media; allowed directories are %s", primaryDir, allowedPaths));
            }
        }
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        String[] stringArray;
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables(TABLE_NAME);
        String string2 = selection = selection == null ? "_id = ?" : selection + " AND " + "_id" + " = ?";
        if (selectionArgs == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = uri.getLastPathSegment();
        } else {
            stringArray = FakeMediaProvider.appendSelectionArgs(selectionArgs, uri.getLastPathSegment());
        }
        selectionArgs = stringArray;
        int count = 0;
        try (Cursor cursor = qb.query((SQLiteDatabase)this.dbSupplier.get(), new String[]{"_id"}, selection, selectionArgs, null, null, null);){
            while (cursor != null && cursor.moveToNext()) {
                long mediaStoreId = cursor.getLong(0);
                count += qb.delete((SQLiteDatabase)this.dbSupplier.get(), "_id = ?", new String[]{String.valueOf(mediaStoreId)});
            }
        }
        if (count <= 0) {
            throw new SecurityException("Could not find entries " + uri);
        }
        return count;
    }

    private static String[] appendSelectionArgs(String[] originalArgs, String additionalArgs) {
        int length = originalArgs.length + 1;
        String[] result = Arrays.copyOf(originalArgs, length);
        result[length - 1] = additionalArgs;
        return result;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        String[] stringArray;
        String string2 = selection = selection == null ? "_id = ?" : selection + " AND " + "_id" + " = ?";
        if (selectionArgs == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = uri.getLastPathSegment();
        } else {
            stringArray = FakeMediaProvider.appendSelectionArgs(selectionArgs, uri.getLastPathSegment());
        }
        selectionArgs = stringArray;
        return ((SQLiteDatabase)this.dbSupplier.get()).update(TABLE_NAME, values, selection, selectionArgs);
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        block10: {
            try (Cursor cursor = this.query(uri, new String[]{"_data"}, null, null, null);){
                if (cursor.getCount() != 1 || !cursor.moveToFirst()) break block10;
                String data = cursor.getString(0);
                File file = new File(data);
                if (!file.exists()) {
                    if (!mode.contains("w")) {
                        throw new FileNotFoundException("File does not exist and mode is not write: " + file.getPath() + " " + mode);
                    }
                    file.getParentFile().mkdirs();
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        throw new FileNotFoundException(e.getMessage());
                    }
                }
                ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)ParcelFileDescriptor.parseMode((String)mode));
                return parcelFileDescriptor;
            }
        }
        throw new FileNotFoundException("Can't find file for uri: " + uri);
    }

    private static String createTableStatement() {
        return "CREATE TABLE files (_id INTEGER PRIMARY KEY AUTOINCREMENT,_data TEXT UNIQUE COLLATE NOCASE,_size INTEGER,format INTEGER,parent INTEGER,date_added INTEGER,date_modified INTEGER,mime_type TEXT,title TEXT,description TEXT,_display_name TEXT,picasa_id TEXT,orientation INTEGER,latitude DOUBLE,longitude DOUBLE,datetaken INTEGER,mini_thumb_magic INTEGER,bucket_id TEXT,bucket_display_name TEXT,isprivate INTEGER,title_key TEXT,artist_id INTEGER,album_id INTEGER,composer TEXT,track INTEGER,year INTEGER CHECK(year!=0),is_ringtone INTEGER,is_music INTEGER,is_alarm INTEGER,is_notification INTEGER,is_podcast INTEGER,album_artist TEXT,duration INTEGER,bookmark INTEGER,artist TEXT,album TEXT,resolution TEXT,tags TEXT,category TEXT,language TEXT,mini_thumb_data TEXT,name TEXT,media_type INTEGER,old_id INTEGER,is_drm INTEGER,width INTEGER, height INTEGER, title_resource_uri TEXT,owner_package_name TEXT DEFAULT NULL,color_standard INTEGER, color_transfer INTEGER, color_range INTEGER,_hash BLOB DEFAULT NULL, is_pending INTEGER DEFAULT 0,is_download INTEGER DEFAULT 0, download_uri TEXT DEFAULT NULL,referer_uri TEXT DEFAULT NULL, is_audiobook INTEGER DEFAULT 0,date_expires INTEGER DEFAULT NULL,is_trashed INTEGER DEFAULT 0,group_id INTEGER DEFAULT NULL,primary_directory TEXT DEFAULT NULL,secondary_directory TEXT DEFAULT NULL,document_id TEXT DEFAULT NULL,instance_id TEXT DEFAULT NULL,original_document_id TEXT DEFAULT NULL,relative_path TEXT DEFAULT NULL,volume_name TEXT DEFAULT NULL,artist_key TEXT DEFAULT NULL,album_key TEXT DEFAULT NULL,genre TEXT DEFAULT NULL,genre_key TEXT DEFAULT NULL,genre_id INTEGER,author TEXT DEFAULT NULL, bitrate INTEGER DEFAULT NULL,capture_framerate REAL DEFAULT NULL, cd_track_number TEXT DEFAULT NULL,compilation INTEGER DEFAULT NULL, disc_number TEXT DEFAULT NULL,is_favorite INTEGER DEFAULT 0, num_tracks INTEGER DEFAULT NULL,writer TEXT DEFAULT NULL, exposure_time TEXT DEFAULT NULL,f_number TEXT DEFAULT NULL, iso INTEGER DEFAULT NULL,scene_capture_type INTEGER DEFAULT NULL, generation_added INTEGER DEFAULT 0,generation_modified INTEGER DEFAULT 0, xmp BLOB DEFAULT NULL,_transcode_status INTEGER DEFAULT 0, _video_codec_type TEXT DEFAULT NULL,_modifier INTEGER DEFAULT 0, is_recording INTEGER DEFAULT 0,redacted_uri_id TEXT DEFAULT NULL, _user_id INTEGER DEFAULT " + UserHandle.myUserId() + ", _special_format INTEGER DEFAULT NULL,oem_metadata BLOB DEFAULT NULL,inferred_media_date INTEGER,bits_per_sample INTEGER DEFAULT NULL, samplerate INTEGER DEFAULT NULL,inferred_date INTEGER,kind INTEGER,image_id INTEGER)";
    }

    public void shutdown() {
        if (this.initialized.get()) {
            ((SQLiteDatabase)this.dbSupplier.get()).close();
        }
    }
}

