/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.TypedValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.shadows.ResourceHelper;

public final class ResourceHelper2 {
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final TypedValue mValue = new TypedValue();

    public static TypedValue getValue(String attribute, String value, boolean requireUnit) {
        if (ResourceHelper2.parseFloatAttribute(attribute, value, mValue, requireUnit)) {
            return mValue;
        }
        return null;
    }

    public static boolean parseFloatAttribute(String attribute, String value, TypedValue outValue, boolean requireUnit) {
        int len = (value = value.trim()).length();
        if (len == 0) {
            return false;
        }
        char[] buf = value.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if ((buf[0] < '0' || buf[0] > '9') && buf[0] != '.' && buf[0] != '-') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(value);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (!end.isEmpty() && end.charAt(0) != ' ') {
                if (ResourceHelper.parseUnit(end, outValue, sFloatOut)) {
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0], end);
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).isEmpty() && outValue != null) {
                outValue.assetCookie = 0;
                outValue.string = null;
                if (!requireUnit) {
                    outValue.type = 4;
                    outValue.data = Float.floatToIntBits(f);
                } else {
                    ResourceHelper.applyUnit(ResourceHelper.sUnitNames[1], outValue, sFloatOut);
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0], "dp");
                    System.out.printf("Dimension \"%1$s\" in attribute \"%2$s\" is missing unit!%n", value, attribute == null ? "(unknown)" : attribute);
                }
                return true;
            }
        }
        return false;
    }
}

