/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.BatteryManager;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=BatteryManager.class)
public class ShadowBatteryManager {
    private static final Map<Integer, Long> longProperties = new HashMap<Integer, Long>();
    private static final Map<Integer, Integer> intProperties = new HashMap<Integer, Integer>();
    private static boolean isCharging = false;
    private static long chargeTimeRemaining = 0L;

    @Resetter
    public static void reset() {
        isCharging = false;
        chargeTimeRemaining = 0L;
        longProperties.clear();
        intProperties.clear();
    }

    @Implementation(minSdk=23)
    protected boolean isCharging() {
        return isCharging;
    }

    public void setIsCharging(boolean charging) {
        isCharging = charging;
    }

    @Implementation
    protected int getIntProperty(int id2) {
        return intProperties.containsKey(id2) ? intProperties.get(id2) : Integer.MIN_VALUE;
    }

    public void setIntProperty(int id2, int value) {
        intProperties.put(id2, value);
    }

    @Implementation
    protected long getLongProperty(int id2) {
        return longProperties.containsKey(id2) ? longProperties.get(id2) : Long.MIN_VALUE;
    }

    public void setLongProperty(int id2, long value) {
        longProperties.put(id2, value);
    }

    @Implementation(minSdk=28)
    protected long computeChargeTimeRemaining() {
        return chargeTimeRemaining;
    }

    public void setChargeTimeRemaining(long chargeTimeRemaining) {
        Preconditions.checkArgument((chargeTimeRemaining == -1L || chargeTimeRemaining >= 0L ? 1 : 0) != 0, (Object)"chargeTimeRemaining must be -1 or non-negative.");
        ShadowBatteryManager.chargeTimeRemaining = chargeTimeRemaining;
    }
}

