/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.input.InputManager;
import android.hardware.input.InputManagerGlobal;
import android.os.Build;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VerifiedKeyEvent;
import android.view.VerifiedMotionEvent;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.concurrent.TimeUnit;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowInputManagerGlobal;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=InputManager.class)
public class ShadowInputManager {
    @RealObject
    InputManager realInputManager;
    private static final SetMultimap<Integer, Integer> deviceKeys = HashMultimap.create();

    protected static boolean[] deviceHasKeysImpl(int deviceId, int[] keyCodes) {
        boolean[] result = new boolean[keyCodes.length];
        for (int i = 0; i < keyCodes.length; ++i) {
            result[i] = deviceKeys.containsEntry((Object)deviceId, (Object)keyCodes[i]);
        }
        return result;
    }

    @Implementation(maxSdk=33)
    protected boolean injectInputEvent(InputEvent event, int mode) {
        return true;
    }

    @Implementation(maxSdk=33)
    protected boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        return ShadowInputManager.deviceHasKeysImpl(id2, keyCodes);
    }

    @Implementation(maxSdk=33)
    protected void populateInputDevicesLocked() throws ClassNotFoundException {
        if (ReflectionHelpers.getField((Object)this.realInputManager, (String)"mInputDevicesChangedListener") == null) {
            ReflectionHelpers.setField((Object)this.realInputManager, (String)"mInputDevicesChangedListener", (Object)ReflectionHelpers.callConstructor(Class.forName("android.hardware.input.InputManager$InputDevicesChangedListener"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        }
        if (this.getInputDevices() == null) {
            this.setInputDevices((SparseArray<InputDevice>)new SparseArray());
        }
    }

    private SparseArray<InputDevice> getInputDevices() {
        return ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).getInputDevices();
    }

    private void setInputDevices(SparseArray<InputDevice> devices) {
        ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).setInputDevices(devices);
    }

    void addDeviceKeys(int deviceId, int[] keyCodes) {
        for (int keyCode : keyCodes) {
            deviceKeys.put((Object)deviceId, (Object)keyCode);
        }
    }

    public void addInputDevice(InputDevice inputDevice) {
        if (this.realInputManager.getInputDevice(inputDevice.getId()) == null) {
            SparseArray<InputDevice> inputDevices = RuntimeEnvironment.getApiLevel() < 34 ? this.getInputDevices() : ((ShadowInputManagerGlobal)Shadow.extract((Object)InputManagerGlobal.getInstance())).getInputDevices();
            inputDevices.put(inputDevice.getId(), (Object)inputDevice);
        }
    }

    public void addInputDeviceKeys(int deviceId, int[] keyCodes) {
        Preconditions.checkNotNull((Object)keyCodes);
        Preconditions.checkArgument((this.realInputManager.getInputDevice(deviceId) != null ? 1 : 0) != 0, (String)"Unknown InputDevice with id %s", (int)deviceId);
        if (keyCodes != null) {
            this.addDeviceKeys(deviceId, keyCodes);
        }
    }

    @Implementation(minSdk=30)
    protected @ClassName(value="android.view.VerifiedInputEvent") Object verifyInputEvent(InputEvent inputEvent) {
        if (inputEvent instanceof MotionEvent) {
            MotionEvent motionEvent = (MotionEvent)inputEvent;
            return new VerifiedMotionEvent(motionEvent.getDeviceId(), TimeUnit.MILLISECONDS.toNanos(motionEvent.getEventTime()), motionEvent.getSource(), motionEvent.getDisplayId(), motionEvent.getRawX(), motionEvent.getRawY(), motionEvent.getActionMasked(), TimeUnit.MILLISECONDS.toNanos(motionEvent.getDownTime()), motionEvent.getFlags(), motionEvent.getMetaState(), motionEvent.getButtonState());
        }
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            return new VerifiedKeyEvent(keyEvent.getDeviceId(), TimeUnit.MILLISECONDS.toNanos(keyEvent.getEventTime()), keyEvent.getSource(), keyEvent.getDisplayId(), keyEvent.getAction(), TimeUnit.MILLISECONDS.toNanos(keyEvent.getDownTime()), keyEvent.getFlags(), keyEvent.getKeyCode(), keyEvent.getScanCode(), keyEvent.getMetaState(), keyEvent.getRepeatCount());
        }
        throw new IllegalArgumentException("unknown input event: " + inputEvent.getClass().getName());
    }

    @Resetter
    public static void reset() {
        if (Build.VERSION.SDK_INT < 34) {
            ReflectionHelpers.setStaticField(InputManager.class, (String)"sInstance", null);
        }
        deviceKeys.clear();
    }

    @ForType(value=InputManager.class)
    static interface InputManagerReflector {
        @Accessor(value="mInputDevices")
        public SparseArray<InputDevice> getInputDevices();

        @Accessor(value="mInputDevices")
        public void setInputDevices(SparseArray<InputDevice> var1);
    }
}

