/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Bundle;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.util.SparseArray;
import android.view.View;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=InputMethodManager.class)
public class ShadowInputMethodManager {
    private static boolean softInputVisible;
    private static Optional<SoftInputVisibilityChangeHandler> visibilityChangeHandler;
    private static Optional<PrivateCommandListener> privateCommandListener;
    private static List<InputMethodInfo> inputMethodInfoList;
    private static List<InputMethodInfo> enabledInputMethodInfoList;
    private static Optional<InputMethodSubtype> inputMethodSubtype;

    @Implementation
    protected boolean showSoftInput(View view, int flags) {
        return this.showSoftInput(view, flags, null);
    }

    @Implementation(maxSdk=30)
    protected boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        this.setSoftInputVisibility(true);
        return true;
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver, int ignoredReason) {
        return this.showSoftInput(view, flags, resultReceiver);
    }

    @Implementation(minSdk=34)
    protected boolean showSoftInput(View view, @ClassName(value="android.view.inputmethod.ImeTracker$Token") @ClassName(value="android.view.inputmethod.ImeTracker$Token") Object statsToken, int flags, ResultReceiver resultReceiver, int reason) {
        return this.showSoftInput(view, flags, resultReceiver, reason);
    }

    @Implementation(minSdk=31, maxSdk=35)
    protected boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver, int ignoredReason) {
        return this.hideSoftInputFromWindow(windowToken, flags, resultReceiver);
    }

    @Implementation(minSdk=36)
    protected boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver, int ignoredReason, @ClassName(value="android.view.inputmethod.ImeTracker$Token") @ClassName(value="android.view.inputmethod.ImeTracker$Token") Object statsToken) {
        return this.hideSoftInputFromWindow(windowToken, flags, resultReceiver);
    }

    @Implementation(maxSdk=30)
    protected boolean hideSoftInputFromWindow(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    @Implementation
    protected boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        int resultCode;
        if (this.isSoftInputVisible()) {
            this.setSoftInputVisibility(false);
            resultCode = 3;
        } else {
            resultCode = 1;
        }
        if (resultReceiver != null) {
            resultReceiver.send(resultCode, null);
        }
        return true;
    }

    @Implementation
    protected void toggleSoftInput(int showFlags, int hideFlags) {
        this.setSoftInputVisibility(!this.isSoftInputVisible());
    }

    public boolean isSoftInputVisible() {
        return softInputVisible;
    }

    public void setSoftInputVisibilityHandler(SoftInputVisibilityChangeHandler visibilityChangeHandler) {
        ShadowInputMethodManager.visibilityChangeHandler = Optional.of((Object)visibilityChangeHandler);
    }

    private void setSoftInputVisibility(boolean visible) {
        if (visible == softInputVisible) {
            return;
        }
        softInputVisible = visible;
        if (visibilityChangeHandler.isPresent()) {
            ((SoftInputVisibilityChangeHandler)visibilityChangeHandler.get()).handleSoftInputVisibilityChange(softInputVisible);
        }
    }

    @Implementation(minSdk=31)
    protected void closeCurrentInput() {
    }

    @Implementation
    protected List<InputMethodInfo> getInputMethodList() {
        return inputMethodInfoList;
    }

    public void setInputMethodInfoList(List<InputMethodInfo> inputMethodInfoList) {
        ShadowInputMethodManager.inputMethodInfoList = inputMethodInfoList;
    }

    @Implementation
    protected InputMethodSubtype getCurrentInputMethodSubtype() {
        return (InputMethodSubtype)inputMethodSubtype.orNull();
    }

    public void setCurrentInputMethodSubtype(InputMethodSubtype inputMethodSubtype) {
        ShadowInputMethodManager.inputMethodSubtype = Optional.of((Object)inputMethodSubtype);
    }

    @Implementation
    protected List<InputMethodInfo> getEnabledInputMethodList() {
        return enabledInputMethodInfoList;
    }

    public void setEnabledInputMethodInfoList(List<InputMethodInfo> inputMethodInfoList) {
        enabledInputMethodInfoList = inputMethodInfoList;
    }

    @Implementation
    protected void restartInput(View view) {
    }

    @Implementation
    protected boolean isActive(View view) {
        return false;
    }

    @Implementation
    protected boolean isActive() {
        return false;
    }

    @Implementation
    protected boolean isFullscreenMode() {
        return false;
    }

    @Implementation(maxSdk=29)
    protected void focusIn(View view) {
    }

    @Implementation(minSdk=23, maxSdk=29)
    protected void onViewDetachedFromWindow(View view) {
    }

    @Implementation
    protected void displayCompletions(View view, CompletionInfo[] completions) {
    }

    @Implementation(minSdk=24)
    protected boolean startInputInner(int startInputReason, IBinder windowGainingFocus, int startInputFlags, int softInputMode, int windowFlags) {
        return true;
    }

    @Implementation(minSdk=23)
    protected void sendAppPrivateCommand(View view, String action, Bundle data) {
        if (privateCommandListener.isPresent()) {
            ((PrivateCommandListener)privateCommandListener.get()).onPrivateCommand(view, action, data);
        }
    }

    public void setAppPrivateCommandListener(PrivateCommandListener listener) {
        privateCommandListener = Optional.of((Object)listener);
    }

    @Resetter
    public static void reset() {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        InputMethodManagerReflector inputManagerReflector = (InputMethodManagerReflector)Reflector.reflector(InputMethodManagerReflector.class);
        inputManagerReflector.setInstance(null);
        if (apiLevel > 28) {
            inputManagerReflector.getInstanceMap().clear();
        }
        softInputVisible = false;
        visibilityChangeHandler = Optional.absent();
        privateCommandListener = Optional.absent();
        inputMethodInfoList = ImmutableList.of();
        enabledInputMethodInfoList = ImmutableList.of();
        inputMethodSubtype = Optional.absent();
    }

    static {
        visibilityChangeHandler = Optional.absent();
        privateCommandListener = Optional.absent();
        inputMethodInfoList = ImmutableList.of();
        enabledInputMethodInfoList = ImmutableList.of();
        inputMethodSubtype = Optional.absent();
    }

    public static interface SoftInputVisibilityChangeHandler {
        public void handleSoftInputVisibilityChange(boolean var1);
    }

    public static interface PrivateCommandListener {
        public void onPrivateCommand(View var1, String var2, Bundle var3);
    }

    @ForType(value=InputMethodManager.class)
    static interface InputMethodManagerReflector {
        @Static
        @Direct
        public InputMethodManager peekInstance();

        @Static
        @Accessor(value="mInstance")
        public void setMInstance(InputMethodManager var1);

        @Static
        @Accessor(value="sInstance")
        public void setInstance(InputMethodManager var1);

        @Static
        @Accessor(value="sInstanceMap")
        public SparseArray<InputMethodManager> getInstanceMap();
    }
}

