/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.fonts.Font;
import android.util.TypedValue;
import com.google.common.base.Ascii;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.FontBuilderNatives;
import org.robolectric.nativeruntime.FontNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowFont;
import org.robolectric.shadows.ShadowFontBuilder;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Font.class, minSdk=29, shadowPicker=Picker.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeFont {
    @Implementation(minSdk=31, maxSdk=34)
    protected static long nGetMinikinFontPtr(long font) {
        return FontNatives.nGetMinikinFontPtr((long)font);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long nCloneFont(long font) {
        return FontNatives.nCloneFont((long)font);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static ByteBuffer nNewByteBuffer(long font) {
        return FontNatives.nNewByteBuffer((long)font);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long nGetBufferAddress(long font) {
        return FontNatives.nGetBufferAddress((long)font);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static int nGetSourceId(long font) {
        return FontNatives.nGetSourceId((long)font);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long nGetReleaseNativeFont() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return FontNatives.nGetReleaseNativeFont();
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static float nGetGlyphBounds(long font, int glyphId, long paint, RectF rect) {
        return FontNatives.nGetGlyphBounds((long)font, (int)glyphId, (long)paint, (RectF)rect);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static float nGetFontMetrics(long font, long paint, Paint.FontMetrics metrics) {
        return FontNatives.nGetFontMetrics((long)font, (long)paint, (Paint.FontMetrics)metrics);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static String nGetFontPath(long fontPtr) {
        return FontNatives.nGetFontPath((long)fontPtr);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static String nGetLocaleList(long familyPtr) {
        return FontNatives.nGetLocaleList((long)familyPtr);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static int nGetPackedStyle(long fontPtr) {
        return FontNatives.nGetPackedStyle((long)fontPtr);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static int nGetIndex(long fontPtr) {
        return FontNatives.nGetIndex((long)fontPtr);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static int nGetAxisCount(long fontPtr) {
        return FontNatives.nGetAxisCount((long)fontPtr);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long nGetAxisInfo(long fontPtr, int i) {
        return FontNatives.nGetAxisInfo((long)fontPtr, (int)i);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long[] nGetAvailableFontSet() {
        return FontNatives.nGetAvailableFontSet();
    }

    static ByteBuffer assetToBuffer(AssetManager am, String path, boolean isAsset, int cookie) throws IOException {
        Objects.requireNonNull(am, "assetManager can not be null");
        Objects.requireNonNull(path, "path can not be null");
        try (InputStream assetStream = isAsset ? am.open(path, 3) : am.openNonAsset(cookie, path, 3);){
            int bytesRead;
            int capacity = assetStream.available();
            ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
            buffer.order(ByteOrder.nativeOrder());
            byte[] buf = new byte[8192];
            while ((bytesRead = assetStream.read(buf)) != -1) {
                buffer.put(buf, 0, bytesRead);
            }
            if (assetStream.read() != -1) {
                throw new IOException("Unable to access full contents of " + path);
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowFont.class, ShadowNativeFont.class);
        }
    }

    @Implements(value=Font.Builder.class, minSdk=29, shadowPicker=Picker.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
    public static class ShadowNativeFontBuilder {
        @RealObject
        Font.Builder realFontBuilder;

        @Implementation(minSdk=29, maxSdk=29)
        protected void __constructor__(AssetManager am, String path, boolean isAsset, int cookie) {
            ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setWeight(-1);
            ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setItalic(-1);
            ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setLocaleList("");
            try {
                ByteBuffer buf = ShadowNativeFontBuilder.createBuffer(am, path, isAsset, cookie);
                ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setBuffer(buf);
            }
            catch (IOException e) {
                ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setException(e);
            }
        }

        @Implementation(minSdk=29, maxSdk=29)
        protected void __constructor__(Resources res, int resId) {
            ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setWeight(-1);
            ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setItalic(-1);
            ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setLocaleList("");
            TypedValue value = new TypedValue();
            res.getValue(resId, value, true);
            if (value.string == null) {
                ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setException(new FileNotFoundException(resId + " not found"));
                return;
            }
            String str = value.string.toString();
            if (Ascii.toLowerCase((String)str).endsWith(".xml")) {
                ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setException(new FileNotFoundException(resId + " must be font file."));
                return;
            }
            try {
                ByteBuffer buf = ShadowNativeFontBuilder.createBuffer(res.getAssets(), str, false, value.assetCookie);
                ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setBuffer(buf);
            }
            catch (IOException e) {
                ((FontBuilderReflector)Reflector.reflector(FontBuilderReflector.class, (Object)this.realFontBuilder)).setException(e);
            }
        }

        @Implementation(minSdk=29, maxSdk=34)
        protected static long nInitBuilder() {
            DefaultNativeRuntimeLoader.injectAndLoad();
            return FontBuilderNatives.nInitBuilder();
        }

        @Implementation(minSdk=29, maxSdk=34)
        protected static void nAddAxis(long builderPtr, int tag, float value) {
            FontBuilderNatives.nAddAxis((long)builderPtr, (int)tag, (float)value);
        }

        @Implementation(minSdk=31, maxSdk=34)
        protected static long nBuild(long builderPtr, ByteBuffer buffer, String filePath, String localeList, int weight, boolean italic, int ttcIndex) {
            return FontBuilderNatives.nBuild((long)builderPtr, (ByteBuffer)buffer, (String)filePath, (String)localeList, (int)weight, (boolean)italic, (int)ttcIndex);
        }

        @Implementation(minSdk=29, maxSdk=30)
        protected static long nBuild(long builderPtr, ByteBuffer buffer, String filePath, int weight, boolean italic, int ttcIndex) {
            return ShadowNativeFontBuilder.nBuild(builderPtr, buffer, filePath, "", weight, italic, ttcIndex);
        }

        @Implementation(minSdk=29, maxSdk=33)
        protected static long nGetReleaseNativeFont() {
            DefaultNativeRuntimeLoader.injectAndLoad();
            return FontNatives.nGetReleaseNativeFont();
        }

        @Implementation(minSdk=31, maxSdk=34)
        protected static long nClone(long fontPtr, long builderPtr, int weight, boolean italic, int ttcIndex) {
            return FontBuilderNatives.nClone((long)fontPtr, (long)builderPtr, (int)weight, (boolean)italic, (int)ttcIndex);
        }

        @Implementation(minSdk=30)
        protected static ByteBuffer createBuffer(AssetManager am, String path, boolean isAsset, int cookie) throws IOException {
            return ShadowNativeFont.assetToBuffer(am, path, isAsset, cookie);
        }

        @Implementation(minSdk=29, maxSdk=29)
        protected static long nGetReleaseNativeAssetFunc() {
            return 0L;
        }

        @ForType(value=Font.Builder.class)
        static interface FontBuilderReflector {
            @Accessor(value="mBuffer")
            public void setBuffer(ByteBuffer var1);

            @Accessor(value="mException")
            public void setException(IOException var1);

            @Accessor(value="mWeight")
            public void setWeight(int var1);

            @Accessor(value="mItalic")
            public void setItalic(int var1);

            @Accessor(value="mLocaleList")
            public void setLocaleList(String var1);
        }

        public static final class Picker
        extends GraphicsShadowPicker<Object> {
            public Picker() {
                super(ShadowFontBuilder.class, ShadowNativeFontBuilder.class);
            }
        }
    }
}

