/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.NetworkInfo;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=NetworkInfo.class)
public class ShadowNetworkInfo {
    private boolean isAvailable;
    private NetworkInfo.State state;
    private int connectionType;
    private int connectionSubType;
    private NetworkInfo.DetailedState detailedState;
    @RealObject
    private NetworkInfo realNetworkInfo;

    @Implementation
    protected static void __staticInitializer__() {
    }

    @Deprecated
    public static NetworkInfo newInstance(NetworkInfo.DetailedState detailedState, int type, int subType, boolean isAvailable, boolean isConnected) {
        return ShadowNetworkInfo.newInstance(detailedState, type, subType, isAvailable, isConnected ? NetworkInfo.State.CONNECTED : NetworkInfo.State.DISCONNECTED);
    }

    public static NetworkInfo newInstance(NetworkInfo.DetailedState detailedState, int type, int subType, boolean isAvailable, NetworkInfo.State state) {
        NetworkInfo networkInfo = (NetworkInfo)Shadow.newInstanceOf(NetworkInfo.class);
        ShadowNetworkInfo info = (ShadowNetworkInfo)Shadow.extract((Object)networkInfo);
        info.setConnectionType(type);
        info.setSubType(subType);
        info.setDetailedState(detailedState);
        info.setAvailableStatus(isAvailable);
        info.setConnectionStatus(state);
        return networkInfo;
    }

    @Implementation
    protected boolean isConnected() {
        return this.state == NetworkInfo.State.CONNECTED;
    }

    @Implementation
    protected boolean isConnectedOrConnecting() {
        return this.isConnected() || this.state == NetworkInfo.State.CONNECTING;
    }

    @Implementation
    protected NetworkInfo.State getState() {
        return this.state;
    }

    @Implementation
    protected NetworkInfo.DetailedState getDetailedState() {
        return this.detailedState;
    }

    @Implementation
    protected int getType() {
        return this.connectionType;
    }

    @Implementation
    protected int getSubtype() {
        return this.connectionSubType;
    }

    @Implementation
    protected boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailableStatus(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    @Deprecated
    public void setConnectionStatus(boolean isConnected) {
        this.setConnectionStatus(isConnected ? NetworkInfo.State.CONNECTED : NetworkInfo.State.DISCONNECTED);
    }

    public void setConnectionStatus(NetworkInfo.State state) {
        this.state = state;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public void setSubType(int subType) {
        this.connectionSubType = subType;
    }

    public void setDetailedState(NetworkInfo.DetailedState detailedState) {
        this.detailedState = detailedState;
    }

    @Implementation
    public void setExtraInfo(String extraInfo) {
        ((NetworkInfoReflector)Reflector.reflector(NetworkInfoReflector.class, (Object)this.realNetworkInfo)).setExtraInfo(extraInfo);
    }

    @ForType(value=NetworkInfo.class)
    static interface NetworkInfoReflector {
        @Direct
        public void setExtraInfo(String var1);
    }
}

