/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.OsConstants;
import java.io.File;
import java.lang.reflect.Field;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=OsConstants.class)
public final class ShadowOsConstants {
    @Implementation
    protected static void __staticInitializer__() {
        Shadow.directInitialize(OsConstants.class);
        ShadowOsConstants.shadowInitConstants();
    }

    private static void shadowInitConstants() {
        ShadowOsConstants.initConstant("AF_INET", 2);
        ShadowOsConstants.initConstant("AF_INET6", 10);
        ShadowOsConstants.initConstant("AF_NETLINK", 16);
        ShadowOsConstants.initConstant("AF_PACKET", 17);
        ShadowOsConstants.initConstant("AF_UNIX", 1);
        ShadowOsConstants.initConstant("AF_UNSPEC", 0);
        ShadowOsConstants.initConstant("AF_VSOCK", 40);
        ShadowOsConstants.initConstant("AI_ADDRCONFIG", 1024);
        ShadowOsConstants.initConstant("AI_ALL", 256);
        ShadowOsConstants.initConstant("AI_CANONNAME", 2);
        ShadowOsConstants.initConstant("AI_NUMERICHOST", 4);
        ShadowOsConstants.initConstant("AI_NUMERICSERV", 8);
        ShadowOsConstants.initConstant("AI_PASSIVE", 1);
        ShadowOsConstants.initConstant("AI_V4MAPPED", 2048);
        ShadowOsConstants.initConstant("ARPHRD_ETHER", 1);
        ShadowOsConstants.initConstant("ARPHRD_LOOPBACK", 772);
        ShadowOsConstants.initConstant("CAP_AUDIT_CONTROL", 30);
        ShadowOsConstants.initConstant("CAP_AUDIT_WRITE", 29);
        ShadowOsConstants.initConstant("CAP_BLOCK_SUSPEND", 36);
        ShadowOsConstants.initConstant("CAP_CHOWN", 0);
        ShadowOsConstants.initConstant("CAP_DAC_OVERRIDE", 1);
        ShadowOsConstants.initConstant("CAP_DAC_READ_SEARCH", 2);
        ShadowOsConstants.initConstant("CAP_FOWNER", 3);
        ShadowOsConstants.initConstant("CAP_FSETID", 4);
        ShadowOsConstants.initConstant("CAP_IPC_LOCK", 14);
        ShadowOsConstants.initConstant("CAP_IPC_OWNER", 15);
        ShadowOsConstants.initConstant("CAP_KILL", 5);
        ShadowOsConstants.initConstant("CAP_LAST_CAP", 40);
        ShadowOsConstants.initConstant("CAP_LEASE", 28);
        ShadowOsConstants.initConstant("CAP_LINUX_IMMUTABLE", 9);
        ShadowOsConstants.initConstant("CAP_MAC_ADMIN", 33);
        ShadowOsConstants.initConstant("CAP_MAC_OVERRIDE", 32);
        ShadowOsConstants.initConstant("CAP_MKNOD", 27);
        ShadowOsConstants.initConstant("CAP_NET_ADMIN", 12);
        ShadowOsConstants.initConstant("CAP_NET_BIND_SERVICE", 10);
        ShadowOsConstants.initConstant("CAP_NET_BROADCAST", 11);
        ShadowOsConstants.initConstant("CAP_NET_RAW", 13);
        ShadowOsConstants.initConstant("CAP_SETFCAP", 31);
        ShadowOsConstants.initConstant("CAP_SETGID", 6);
        ShadowOsConstants.initConstant("CAP_SETPCAP", 8);
        ShadowOsConstants.initConstant("CAP_SETUID", 7);
        ShadowOsConstants.initConstant("CAP_SYSLOG", 34);
        ShadowOsConstants.initConstant("CAP_SYS_ADMIN", 21);
        ShadowOsConstants.initConstant("CAP_SYS_BOOT", 22);
        ShadowOsConstants.initConstant("CAP_SYS_CHROOT", 18);
        ShadowOsConstants.initConstant("CAP_SYS_MODULE", 16);
        ShadowOsConstants.initConstant("CAP_SYS_NICE", 23);
        ShadowOsConstants.initConstant("CAP_SYS_PACCT", 20);
        ShadowOsConstants.initConstant("CAP_SYS_PTRACE", 19);
        ShadowOsConstants.initConstant("CAP_SYS_RAWIO", 17);
        ShadowOsConstants.initConstant("CAP_SYS_RESOURCE", 24);
        ShadowOsConstants.initConstant("CAP_SYS_TIME", 25);
        ShadowOsConstants.initConstant("CAP_SYS_TTY_CONFIG", 26);
        ShadowOsConstants.initConstant("CAP_WAKE_ALARM", 35);
        ShadowOsConstants.initConstant("E2BIG", 7);
        ShadowOsConstants.initConstant("EACCES", 13);
        ShadowOsConstants.initConstant("EADDRINUSE", 98);
        ShadowOsConstants.initConstant("EADDRNOTAVAIL", 99);
        ShadowOsConstants.initConstant("EAFNOSUPPORT", 97);
        ShadowOsConstants.initConstant("EAGAIN", 11);
        ShadowOsConstants.initConstant("EAI_AGAIN", 2);
        ShadowOsConstants.initConstant("EAI_BADFLAGS", 3);
        ShadowOsConstants.initConstant("EAI_FAIL", 4);
        ShadowOsConstants.initConstant("EAI_FAMILY", 5);
        ShadowOsConstants.initConstant("EAI_MEMORY", 6);
        ShadowOsConstants.initConstant("EAI_NODATA", 7);
        ShadowOsConstants.initConstant("EAI_NONAME", 8);
        ShadowOsConstants.initConstant("EAI_OVERFLOW", 14);
        ShadowOsConstants.initConstant("EAI_SERVICE", 9);
        ShadowOsConstants.initConstant("EAI_SOCKTYPE", 10);
        ShadowOsConstants.initConstant("EAI_SYSTEM", 11);
        ShadowOsConstants.initConstant("EALREADY", 114);
        ShadowOsConstants.initConstant("EBADF", 9);
        ShadowOsConstants.initConstant("EBADMSG", 74);
        ShadowOsConstants.initConstant("EBUSY", 16);
        ShadowOsConstants.initConstant("ECANCELED", 125);
        ShadowOsConstants.initConstant("ECHILD", 10);
        ShadowOsConstants.initConstant("ECONNABORTED", 103);
        ShadowOsConstants.initConstant("ECONNREFUSED", 111);
        ShadowOsConstants.initConstant("ECONNRESET", 104);
        ShadowOsConstants.initConstant("EDEADLK", 35);
        ShadowOsConstants.initConstant("EDESTADDRREQ", 89);
        ShadowOsConstants.initConstant("EDOM", 33);
        ShadowOsConstants.initConstant("EDQUOT", 122);
        ShadowOsConstants.initConstant("EEXIST", 17);
        ShadowOsConstants.initConstant("EFAULT", 14);
        ShadowOsConstants.initConstant("EFBIG", 27);
        ShadowOsConstants.initConstant("EHOSTUNREACH", 113);
        ShadowOsConstants.initConstant("EIDRM", 43);
        ShadowOsConstants.initConstant("EILSEQ", 84);
        ShadowOsConstants.initConstant("EINPROGRESS", 115);
        ShadowOsConstants.initConstant("EINTR", 4);
        ShadowOsConstants.initConstant("EINVAL", 22);
        ShadowOsConstants.initConstant("EIO", 5);
        ShadowOsConstants.initConstant("EISCONN", 106);
        ShadowOsConstants.initConstant("EISDIR", 21);
        ShadowOsConstants.initConstant("ELOOP", 40);
        ShadowOsConstants.initConstant("EMFILE", 24);
        ShadowOsConstants.initConstant("EMLINK", 31);
        ShadowOsConstants.initConstant("EMSGSIZE", 90);
        ShadowOsConstants.initConstant("EMULTIHOP", 72);
        ShadowOsConstants.initConstant("ENAMETOOLONG", 36);
        ShadowOsConstants.initConstant("ENETDOWN", 100);
        ShadowOsConstants.initConstant("ENETRESET", 102);
        ShadowOsConstants.initConstant("ENETUNREACH", 101);
        ShadowOsConstants.initConstant("ENFILE", 23);
        ShadowOsConstants.initConstant("ENOBUFS", 105);
        ShadowOsConstants.initConstant("ENODATA", 61);
        ShadowOsConstants.initConstant("ENODEV", 19);
        ShadowOsConstants.initConstant("ENOENT", 2);
        ShadowOsConstants.initConstant("ENOEXEC", 8);
        ShadowOsConstants.initConstant("ENOLCK", 37);
        ShadowOsConstants.initConstant("ENOLINK", 67);
        ShadowOsConstants.initConstant("ENOMEM", 12);
        ShadowOsConstants.initConstant("ENOMSG", 42);
        ShadowOsConstants.initConstant("ENONET", 64);
        ShadowOsConstants.initConstant("ENOPROTOOPT", 92);
        ShadowOsConstants.initConstant("ENOSPC", 28);
        ShadowOsConstants.initConstant("ENOSR", 63);
        ShadowOsConstants.initConstant("ENOSTR", 60);
        ShadowOsConstants.initConstant("ENOSYS", 38);
        ShadowOsConstants.initConstant("ENOTCONN", 107);
        ShadowOsConstants.initConstant("ENOTDIR", 20);
        ShadowOsConstants.initConstant("ENOTEMPTY", 39);
        ShadowOsConstants.initConstant("ENOTSOCK", 88);
        ShadowOsConstants.initConstant("ENOTSUP", 95);
        ShadowOsConstants.initConstant("ENOTTY", 25);
        ShadowOsConstants.initConstant("ENXIO", 6);
        ShadowOsConstants.initConstant("EOPNOTSUPP", 95);
        ShadowOsConstants.initConstant("EOVERFLOW", 75);
        ShadowOsConstants.initConstant("EPERM", 1);
        ShadowOsConstants.initConstant("EPIPE", 32);
        ShadowOsConstants.initConstant("EPROTO", 71);
        ShadowOsConstants.initConstant("EPROTONOSUPPORT", 93);
        ShadowOsConstants.initConstant("EPROTOTYPE", 91);
        ShadowOsConstants.initConstant("ERANGE", 34);
        ShadowOsConstants.initConstant("EROFS", 30);
        ShadowOsConstants.initConstant("ESPIPE", 29);
        ShadowOsConstants.initConstant("ESRCH", 3);
        ShadowOsConstants.initConstant("ESTALE", 116);
        ShadowOsConstants.initConstant("ETH_P_ALL", 3);
        ShadowOsConstants.initConstant("ETH_P_ARP", 2054);
        ShadowOsConstants.initConstant("ETH_P_IP", 2048);
        ShadowOsConstants.initConstant("ETH_P_IPV6", 34525);
        ShadowOsConstants.initConstant("ETIME", 62);
        ShadowOsConstants.initConstant("ETIMEDOUT", 110);
        ShadowOsConstants.initConstant("ETXTBSY", 26);
        ShadowOsConstants.initConstant("EUSERS", 87);
        ShadowOsConstants.initConstant("EXDEV", 18);
        ShadowOsConstants.initConstant("EXIT_FAILURE", 1);
        ShadowOsConstants.initConstant("EXIT_SUCCESS", 0);
        ShadowOsConstants.initConstant("FD_CLOEXEC", 1);
        ShadowOsConstants.initConstant("FIONREAD", 21531);
        ShadowOsConstants.initConstant("F_DUPFD", 0);
        ShadowOsConstants.initConstant("F_DUPFD_CLOEXEC", 1030);
        ShadowOsConstants.initConstant("F_GETFD", 1);
        ShadowOsConstants.initConstant("F_GETFL", 3);
        ShadowOsConstants.initConstant("F_GETLK", 5);
        ShadowOsConstants.initConstant("F_GETLK64", 5);
        ShadowOsConstants.initConstant("F_GETOWN", 9);
        ShadowOsConstants.initConstant("F_OK", 0);
        ShadowOsConstants.initConstant("F_RDLCK", 0);
        ShadowOsConstants.initConstant("F_SETFD", 2);
        ShadowOsConstants.initConstant("F_SETFL", 4);
        ShadowOsConstants.initConstant("F_SETLK", 6);
        ShadowOsConstants.initConstant("F_SETLK64", 6);
        ShadowOsConstants.initConstant("F_SETLKW", 7);
        ShadowOsConstants.initConstant("F_SETLKW64", 7);
        ShadowOsConstants.initConstant("F_SETOWN", 8);
        ShadowOsConstants.initConstant("F_UNLCK", 2);
        ShadowOsConstants.initConstant("F_WRLCK", 1);
        ShadowOsConstants.initConstant("ICMP6_ECHO_REPLY", 129);
        ShadowOsConstants.initConstant("ICMP6_ECHO_REQUEST", 128);
        ShadowOsConstants.initConstant("ICMP_ECHO", 8);
        ShadowOsConstants.initConstant("ICMP_ECHOREPLY", 0);
        ShadowOsConstants.initConstant("IFA_F_DADFAILED", 8);
        ShadowOsConstants.initConstant("IFA_F_DEPRECATED", 32);
        ShadowOsConstants.initConstant("IFA_F_HOMEADDRESS", 16);
        ShadowOsConstants.initConstant("IFA_F_MANAGETEMPADDR", 256);
        ShadowOsConstants.initConstant("IFA_F_NODAD", 2);
        ShadowOsConstants.initConstant("IFA_F_NOPREFIXROUTE", 512);
        ShadowOsConstants.initConstant("IFA_F_OPTIMISTIC", 4);
        ShadowOsConstants.initConstant("IFA_F_PERMANENT", 128);
        ShadowOsConstants.initConstant("IFA_F_SECONDARY", 1);
        ShadowOsConstants.initConstant("IFA_F_TEMPORARY", 1);
        ShadowOsConstants.initConstant("IFA_F_TENTATIVE", 64);
        ShadowOsConstants.initConstant("IFF_ALLMULTI", 512);
        ShadowOsConstants.initConstant("IFF_AUTOMEDIA", 16384);
        ShadowOsConstants.initConstant("IFF_BROADCAST", 2);
        ShadowOsConstants.initConstant("IFF_DEBUG", 4);
        ShadowOsConstants.initConstant("IFF_DYNAMIC", 32768);
        ShadowOsConstants.initConstant("IFF_LOOPBACK", 8);
        ShadowOsConstants.initConstant("IFF_MASTER", 1024);
        ShadowOsConstants.initConstant("IFF_MULTICAST", 4096);
        ShadowOsConstants.initConstant("IFF_NOARP", 128);
        ShadowOsConstants.initConstant("IFF_NOTRAILERS", 32);
        ShadowOsConstants.initConstant("IFF_POINTOPOINT", 16);
        ShadowOsConstants.initConstant("IFF_PORTSEL", 8192);
        ShadowOsConstants.initConstant("IFF_PROMISC", 256);
        ShadowOsConstants.initConstant("IFF_RUNNING", 64);
        ShadowOsConstants.initConstant("IFF_SLAVE", 2048);
        ShadowOsConstants.initConstant("IFF_UP", 1);
        ShadowOsConstants.initConstant("IPPROTO_ESP", 50);
        ShadowOsConstants.initConstant("IPPROTO_ICMP", 1);
        ShadowOsConstants.initConstant("IPPROTO_ICMPV6", 58);
        ShadowOsConstants.initConstant("IPPROTO_IP", 0);
        ShadowOsConstants.initConstant("IPPROTO_IPV6", 41);
        ShadowOsConstants.initConstant("IPPROTO_RAW", 255);
        ShadowOsConstants.initConstant("IPPROTO_TCP", 6);
        ShadowOsConstants.initConstant("IPPROTO_UDP", 17);
        ShadowOsConstants.initConstant("IPV6_CHECKSUM", 7);
        ShadowOsConstants.initConstant("IPV6_MULTICAST_HOPS", 18);
        ShadowOsConstants.initConstant("IPV6_MULTICAST_IF", 17);
        ShadowOsConstants.initConstant("IPV6_MULTICAST_LOOP", 19);
        ShadowOsConstants.initConstant("IPV6_PKTINFO", 50);
        ShadowOsConstants.initConstant("IPV6_RECVDSTOPTS", 58);
        ShadowOsConstants.initConstant("IPV6_RECVHOPLIMIT", 51);
        ShadowOsConstants.initConstant("IPV6_RECVHOPOPTS", 53);
        ShadowOsConstants.initConstant("IPV6_RECVPKTINFO", 49);
        ShadowOsConstants.initConstant("IPV6_RECVRTHDR", 56);
        ShadowOsConstants.initConstant("IPV6_RECVTCLASS", 66);
        ShadowOsConstants.initConstant("IPV6_TCLASS", 67);
        ShadowOsConstants.initConstant("IPV6_UNICAST_HOPS", 16);
        ShadowOsConstants.initConstant("IPV6_V6ONLY", 26);
        ShadowOsConstants.initConstant("IP_MULTICAST_ALL", 49);
        ShadowOsConstants.initConstant("IP_MULTICAST_IF", 32);
        ShadowOsConstants.initConstant("IP_MULTICAST_LOOP", 34);
        ShadowOsConstants.initConstant("IP_MULTICAST_TTL", 33);
        ShadowOsConstants.initConstant("IP_RECVTOS", 13);
        ShadowOsConstants.initConstant("IP_TOS", 1);
        ShadowOsConstants.initConstant("IP_TTL", 2);
        ShadowOsConstants.initConstant("MAP_ANONYMOUS", 32);
        ShadowOsConstants.initConstant("MAP_FIXED", 16);
        ShadowOsConstants.initConstant("MAP_POPULATE", 32768);
        ShadowOsConstants.initConstant("MAP_PRIVATE", 2);
        ShadowOsConstants.initConstant("MAP_SHARED", 1);
        ShadowOsConstants.initConstant("MCAST_BLOCK_SOURCE", 43);
        ShadowOsConstants.initConstant("MCAST_JOIN_GROUP", 42);
        ShadowOsConstants.initConstant("MCAST_JOIN_SOURCE_GROUP", 46);
        ShadowOsConstants.initConstant("MCAST_LEAVE_GROUP", 45);
        ShadowOsConstants.initConstant("MCAST_LEAVE_SOURCE_GROUP", 47);
        ShadowOsConstants.initConstant("MCAST_UNBLOCK_SOURCE", 44);
        ShadowOsConstants.initConstant("MCL_CURRENT", 1);
        ShadowOsConstants.initConstant("MCL_FUTURE", 2);
        ShadowOsConstants.initConstant("MFD_CLOEXEC", 1);
        ShadowOsConstants.initConstant("MSG_CTRUNC", 8);
        ShadowOsConstants.initConstant("MSG_DONTROUTE", 4);
        ShadowOsConstants.initConstant("MSG_EOR", 128);
        ShadowOsConstants.initConstant("MSG_OOB", 1);
        ShadowOsConstants.initConstant("MSG_PEEK", 2);
        ShadowOsConstants.initConstant("MSG_TRUNC", 32);
        ShadowOsConstants.initConstant("MSG_WAITALL", 256);
        ShadowOsConstants.initConstant("MS_ASYNC", 1);
        ShadowOsConstants.initConstant("MS_INVALIDATE", 2);
        ShadowOsConstants.initConstant("MS_SYNC", 4);
        ShadowOsConstants.initConstant("NETLINK_INET_DIAG", 4);
        ShadowOsConstants.initConstant("NETLINK_NETFILTER", 12);
        ShadowOsConstants.initConstant("NETLINK_ROUTE", 0);
        ShadowOsConstants.initConstant("NETLINK_XFRM", 6);
        ShadowOsConstants.initConstant("NI_DGRAM", 16);
        ShadowOsConstants.initConstant("NI_NAMEREQD", 4);
        ShadowOsConstants.initConstant("NI_NOFQDN", 1);
        ShadowOsConstants.initConstant("NI_NUMERICHOST", 2);
        ShadowOsConstants.initConstant("NI_NUMERICSERV", 8);
        ShadowOsConstants.initConstant("O_ACCMODE", 3);
        ShadowOsConstants.initConstant("O_APPEND", 1024);
        ShadowOsConstants.initConstant("O_CLOEXEC", 524288);
        ShadowOsConstants.initConstant("O_CREAT", 64);
        ShadowOsConstants.initConstant("O_DIRECT", 16384);
        ShadowOsConstants.initConstant("O_DSYNC", 4096);
        ShadowOsConstants.initConstant("O_EXCL", 128);
        ShadowOsConstants.initConstant("O_NOCTTY", 256);
        ShadowOsConstants.initConstant("O_NOFOLLOW", 131072);
        ShadowOsConstants.initConstant("O_NONBLOCK", 2048);
        ShadowOsConstants.initConstant("O_RDONLY", 0);
        ShadowOsConstants.initConstant("O_RDWR", 2);
        ShadowOsConstants.initConstant("O_SYNC", 0x101000);
        ShadowOsConstants.initConstant("O_TRUNC", 512);
        ShadowOsConstants.initConstant("O_WRONLY", 1);
        ShadowOsConstants.initConstant("PACKET_IGNORE_OUTGOING", 23);
        ShadowOsConstants.initConstant("POLLERR", 8);
        ShadowOsConstants.initConstant("POLLHUP", 16);
        ShadowOsConstants.initConstant("POLLIN", 1);
        ShadowOsConstants.initConstant("POLLNVAL", 32);
        ShadowOsConstants.initConstant("POLLOUT", 4);
        ShadowOsConstants.initConstant("POLLPRI", 2);
        ShadowOsConstants.initConstant("POLLRDBAND", 128);
        ShadowOsConstants.initConstant("POLLRDNORM", 64);
        ShadowOsConstants.initConstant("POLLWRBAND", 512);
        ShadowOsConstants.initConstant("POLLWRNORM", 256);
        ShadowOsConstants.initConstant("PROT_EXEC", 4);
        ShadowOsConstants.initConstant("PROT_NONE", 0);
        ShadowOsConstants.initConstant("PROT_READ", 1);
        ShadowOsConstants.initConstant("PROT_WRITE", 2);
        ShadowOsConstants.initConstant("PR_CAP_AMBIENT", 47);
        ShadowOsConstants.initConstant("PR_CAP_AMBIENT_RAISE", 2);
        ShadowOsConstants.initConstant("PR_GET_DUMPABLE", 3);
        ShadowOsConstants.initConstant("PR_SET_DUMPABLE", 4);
        ShadowOsConstants.initConstant("PR_SET_NO_NEW_PRIVS", 38);
        ShadowOsConstants.initConstant("RLIMIT_NOFILE", 7);
        ShadowOsConstants.initConstant("RLIMIT_RTPRIO", 14);
        ShadowOsConstants.initConstant("RTMGRP_IPV4_IFADDR", 16);
        ShadowOsConstants.initConstant("RTMGRP_IPV4_MROUTE", 32);
        ShadowOsConstants.initConstant("RTMGRP_IPV4_ROUTE", 64);
        ShadowOsConstants.initConstant("RTMGRP_IPV4_RULE", 128);
        ShadowOsConstants.initConstant("RTMGRP_IPV6_IFADDR", 256);
        ShadowOsConstants.initConstant("RTMGRP_IPV6_IFINFO", 2048);
        ShadowOsConstants.initConstant("RTMGRP_IPV6_MROUTE", 512);
        ShadowOsConstants.initConstant("RTMGRP_IPV6_PREFIX", 131072);
        ShadowOsConstants.initConstant("RTMGRP_IPV6_ROUTE", 1024);
        ShadowOsConstants.initConstant("RTMGRP_LINK", 1);
        ShadowOsConstants.initConstant("RTMGRP_NEIGH", 4);
        ShadowOsConstants.initConstant("RTMGRP_NOTIFY", 2);
        ShadowOsConstants.initConstant("RTMGRP_TC", 8);
        ShadowOsConstants.initConstant("RT_SCOPE_HOST", 254);
        ShadowOsConstants.initConstant("RT_SCOPE_LINK", 253);
        ShadowOsConstants.initConstant("RT_SCOPE_NOWHERE", 255);
        ShadowOsConstants.initConstant("RT_SCOPE_SITE", 200);
        ShadowOsConstants.initConstant("RT_SCOPE_UNIVERSE", 0);
        ShadowOsConstants.initConstant("R_OK", 4);
        ShadowOsConstants.initConstant("SEEK_CUR", 1);
        ShadowOsConstants.initConstant("SEEK_END", 2);
        ShadowOsConstants.initConstant("SEEK_SET", 0);
        ShadowOsConstants.initConstant("SHUT_RD", 0);
        ShadowOsConstants.initConstant("SHUT_RDWR", 2);
        ShadowOsConstants.initConstant("SHUT_WR", 1);
        ShadowOsConstants.initConstant("SIGABRT", 6);
        ShadowOsConstants.initConstant("SIGALRM", 14);
        ShadowOsConstants.initConstant("SIGBUS", 7);
        ShadowOsConstants.initConstant("SIGCHLD", 17);
        ShadowOsConstants.initConstant("SIGCONT", 18);
        ShadowOsConstants.initConstant("SIGFPE", 8);
        ShadowOsConstants.initConstant("SIGHUP", 1);
        ShadowOsConstants.initConstant("SIGILL", 4);
        ShadowOsConstants.initConstant("SIGINT", 2);
        ShadowOsConstants.initConstant("SIGIO", 29);
        ShadowOsConstants.initConstant("SIGKILL", 9);
        ShadowOsConstants.initConstant("SIGPIPE", 13);
        ShadowOsConstants.initConstant("SIGPROF", 27);
        ShadowOsConstants.initConstant("SIGPWR", 30);
        ShadowOsConstants.initConstant("SIGQUIT", 3);
        ShadowOsConstants.initConstant("SIGRTMAX", 64);
        ShadowOsConstants.initConstant("SIGRTMIN", 41);
        ShadowOsConstants.initConstant("SIGSEGV", 11);
        ShadowOsConstants.initConstant("SIGSTKFLT", 16);
        ShadowOsConstants.initConstant("SIGSTOP", 19);
        ShadowOsConstants.initConstant("SIGSYS", 31);
        ShadowOsConstants.initConstant("SIGTERM", 15);
        ShadowOsConstants.initConstant("SIGTRAP", 5);
        ShadowOsConstants.initConstant("SIGTSTP", 20);
        ShadowOsConstants.initConstant("SIGTTIN", 21);
        ShadowOsConstants.initConstant("SIGTTOU", 22);
        ShadowOsConstants.initConstant("SIGURG", 23);
        ShadowOsConstants.initConstant("SIGUSR1", 10);
        ShadowOsConstants.initConstant("SIGUSR2", 12);
        ShadowOsConstants.initConstant("SIGVTALRM", 26);
        ShadowOsConstants.initConstant("SIGWINCH", 28);
        ShadowOsConstants.initConstant("SIGXCPU", 24);
        ShadowOsConstants.initConstant("SIGXFSZ", 25);
        ShadowOsConstants.initConstant("SIOCGIFADDR", 35093);
        ShadowOsConstants.initConstant("SIOCGIFBRDADDR", 35097);
        ShadowOsConstants.initConstant("SIOCGIFDSTADDR", 35095);
        ShadowOsConstants.initConstant("SIOCGIFNETMASK", 35099);
        ShadowOsConstants.initConstant("SOCK_CLOEXEC", 524288);
        ShadowOsConstants.initConstant("SOCK_DGRAM", 2);
        ShadowOsConstants.initConstant("SOCK_NONBLOCK", 2048);
        ShadowOsConstants.initConstant("SOCK_RAW", 3);
        ShadowOsConstants.initConstant("SOCK_SEQPACKET", 5);
        ShadowOsConstants.initConstant("SOCK_STREAM", 1);
        ShadowOsConstants.initConstant("SOL_PACKET", 263);
        ShadowOsConstants.initConstant("SOL_SOCKET", 1);
        ShadowOsConstants.initConstant("SOL_UDP", 17);
        ShadowOsConstants.initConstant("SO_BINDTODEVICE", 25);
        ShadowOsConstants.initConstant("SO_BROADCAST", 6);
        ShadowOsConstants.initConstant("SO_DEBUG", 1);
        ShadowOsConstants.initConstant("SO_DOMAIN", 39);
        ShadowOsConstants.initConstant("SO_DONTROUTE", 5);
        ShadowOsConstants.initConstant("SO_ERROR", 4);
        ShadowOsConstants.initConstant("SO_KEEPALIVE", 9);
        ShadowOsConstants.initConstant("SO_LINGER", 13);
        ShadowOsConstants.initConstant("SO_OOBINLINE", 10);
        ShadowOsConstants.initConstant("SO_PASSCRED", 16);
        ShadowOsConstants.initConstant("SO_PEERCRED", 17);
        ShadowOsConstants.initConstant("SO_PROTOCOL", 38);
        ShadowOsConstants.initConstant("SO_RCVBUF", 8);
        ShadowOsConstants.initConstant("SO_RCVLOWAT", 18);
        ShadowOsConstants.initConstant("SO_RCVTIMEO", 20);
        ShadowOsConstants.initConstant("SO_REUSEADDR", 2);
        ShadowOsConstants.initConstant("SO_SNDBUF", 7);
        ShadowOsConstants.initConstant("SO_SNDLOWAT", 19);
        ShadowOsConstants.initConstant("SO_SNDTIMEO", 21);
        ShadowOsConstants.initConstant("SO_TYPE", 3);
        ShadowOsConstants.initConstant("SPLICE_F_MORE", 4);
        ShadowOsConstants.initConstant("SPLICE_F_MOVE", 1);
        ShadowOsConstants.initConstant("SPLICE_F_NONBLOCK", 2);
        ShadowOsConstants.initConstant("STDERR_FILENO", 2);
        ShadowOsConstants.initConstant("STDIN_FILENO", 0);
        ShadowOsConstants.initConstant("STDOUT_FILENO", 1);
        ShadowOsConstants.initConstant("ST_MANDLOCK", 64);
        ShadowOsConstants.initConstant("ST_NOATIME", 1024);
        ShadowOsConstants.initConstant("ST_NODEV", 4);
        ShadowOsConstants.initConstant("ST_NODIRATIME", 2048);
        ShadowOsConstants.initConstant("ST_NOEXEC", 8);
        ShadowOsConstants.initConstant("ST_NOSUID", 2);
        ShadowOsConstants.initConstant("ST_RDONLY", 1);
        ShadowOsConstants.initConstant("ST_RELATIME", 4096);
        ShadowOsConstants.initConstant("ST_SYNCHRONOUS", 16);
        ShadowOsConstants.initConstant("S_IFBLK", 24576);
        ShadowOsConstants.initConstant("S_IFCHR", 8192);
        ShadowOsConstants.initConstant("S_IFDIR", 16384);
        ShadowOsConstants.initConstant("S_IFIFO", 4096);
        ShadowOsConstants.initConstant("S_IFLNK", 40960);
        ShadowOsConstants.initConstant("S_IFMT", 61440);
        ShadowOsConstants.initConstant("S_IFREG", 32768);
        ShadowOsConstants.initConstant("S_IFSOCK", 49152);
        ShadowOsConstants.initConstant("S_IRGRP", 32);
        ShadowOsConstants.initConstant("S_IROTH", 4);
        ShadowOsConstants.initConstant("S_IRUSR", 256);
        ShadowOsConstants.initConstant("S_IRWXG", 56);
        ShadowOsConstants.initConstant("S_IRWXO", 7);
        ShadowOsConstants.initConstant("S_IRWXU", 448);
        ShadowOsConstants.initConstant("S_ISGID", 1024);
        ShadowOsConstants.initConstant("S_ISUID", 2048);
        ShadowOsConstants.initConstant("S_ISVTX", 512);
        ShadowOsConstants.initConstant("S_IWGRP", 16);
        ShadowOsConstants.initConstant("S_IWOTH", 2);
        ShadowOsConstants.initConstant("S_IWUSR", 128);
        ShadowOsConstants.initConstant("S_IXGRP", 8);
        ShadowOsConstants.initConstant("S_IXOTH", 1);
        ShadowOsConstants.initConstant("S_IXUSR", 64);
        ShadowOsConstants.initConstant("TCP_NODELAY", 1);
        ShadowOsConstants.initConstant("TCP_USER_TIMEOUT", 18);
        ShadowOsConstants.initConstant("TIOCOUTQ", 21521);
        ShadowOsConstants.initConstant("UDP_ENCAP", 100);
        ShadowOsConstants.initConstant("UDP_ENCAP_ESPINUDP", 2);
        ShadowOsConstants.initConstant("UDP_ENCAP_ESPINUDP_NON_IKE", 1);
        ShadowOsConstants.initConstant("UDP_GRO", 104);
        ShadowOsConstants.initConstant("UDP_SEGMENT", 103);
        ShadowOsConstants.initConstant("UNIX_PATH_MAX", 108);
        ShadowOsConstants.initConstant("VMADDR_CID_ANY", -1);
        ShadowOsConstants.initConstant("VMADDR_CID_HOST", 2);
        ShadowOsConstants.initConstant("VMADDR_CID_LOCAL", 1);
        ShadowOsConstants.initConstant("VMADDR_PORT_ANY", -1);
        ShadowOsConstants.initConstant("WCONTINUED", 8);
        ShadowOsConstants.initConstant("WEXITED", 4);
        ShadowOsConstants.initConstant("WNOHANG", 1);
        ShadowOsConstants.initConstant("WNOWAIT", 0x1000000);
        ShadowOsConstants.initConstant("WSTOPPED", 2);
        ShadowOsConstants.initConstant("WUNTRACED", 2);
        ShadowOsConstants.initConstant("W_OK", 2);
        ShadowOsConstants.initConstant("XATTR_CREATE", 1);
        ShadowOsConstants.initConstant("XATTR_REPLACE", 2);
        ShadowOsConstants.initConstant("X_OK", 1);
        ShadowOsConstants.initConstant("_LINUX_CAPABILITY_VERSION_3", 537396514);
        ShadowOsConstants.initConstant("_SC_2_CHAR_TERM", 16);
        ShadowOsConstants.initConstant("_SC_2_C_BIND", 13);
        ShadowOsConstants.initConstant("_SC_2_C_DEV", 14);
        ShadowOsConstants.initConstant("_SC_2_C_VERSION", 15);
        ShadowOsConstants.initConstant("_SC_2_FORT_DEV", 17);
        ShadowOsConstants.initConstant("_SC_2_FORT_RUN", 18);
        ShadowOsConstants.initConstant("_SC_2_LOCALEDEF", 19);
        ShadowOsConstants.initConstant("_SC_2_SW_DEV", 20);
        ShadowOsConstants.initConstant("_SC_2_UPE", 21);
        ShadowOsConstants.initConstant("_SC_2_VERSION", 22);
        ShadowOsConstants.initConstant("_SC_AIO_LISTIO_MAX", 46);
        ShadowOsConstants.initConstant("_SC_AIO_MAX", 47);
        ShadowOsConstants.initConstant("_SC_AIO_PRIO_DELTA_MAX", 48);
        ShadowOsConstants.initConstant("_SC_ARG_MAX", 0);
        ShadowOsConstants.initConstant("_SC_ASYNCHRONOUS_IO", 57);
        ShadowOsConstants.initConstant("_SC_ATEXIT_MAX", 37);
        ShadowOsConstants.initConstant("_SC_AVPHYS_PAGES", 99);
        ShadowOsConstants.initConstant("_SC_BC_BASE_MAX", 1);
        ShadowOsConstants.initConstant("_SC_BC_DIM_MAX", 2);
        ShadowOsConstants.initConstant("_SC_BC_SCALE_MAX", 3);
        ShadowOsConstants.initConstant("_SC_BC_STRING_MAX", 4);
        ShadowOsConstants.initConstant("_SC_CHILD_MAX", 5);
        ShadowOsConstants.initConstant("_SC_CLK_TCK", 6);
        ShadowOsConstants.initConstant("_SC_COLL_WEIGHTS_MAX", 7);
        ShadowOsConstants.initConstant("_SC_DELAYTIMER_MAX", 49);
        ShadowOsConstants.initConstant("_SC_EXPR_NEST_MAX", 8);
        ShadowOsConstants.initConstant("_SC_FSYNC", 58);
        ShadowOsConstants.initConstant("_SC_GETGR_R_SIZE_MAX", 71);
        ShadowOsConstants.initConstant("_SC_GETPW_R_SIZE_MAX", 72);
        ShadowOsConstants.initConstant("_SC_IOV_MAX", 38);
        ShadowOsConstants.initConstant("_SC_JOB_CONTROL", 23);
        ShadowOsConstants.initConstant("_SC_LINE_MAX", 9);
        ShadowOsConstants.initConstant("_SC_LOGIN_NAME_MAX", 73);
        ShadowOsConstants.initConstant("_SC_MAPPED_FILES", 59);
        ShadowOsConstants.initConstant("_SC_MEMLOCK", 60);
        ShadowOsConstants.initConstant("_SC_MEMLOCK_RANGE", 61);
        ShadowOsConstants.initConstant("_SC_MEMORY_PROTECTION", 62);
        ShadowOsConstants.initConstant("_SC_MESSAGE_PASSING", 63);
        ShadowOsConstants.initConstant("_SC_MQ_OPEN_MAX", 50);
        ShadowOsConstants.initConstant("_SC_MQ_PRIO_MAX", 51);
        ShadowOsConstants.initConstant("_SC_NGROUPS_MAX", 10);
        ShadowOsConstants.initConstant("_SC_NPROCESSORS_CONF", 96);
        ShadowOsConstants.initConstant("_SC_NPROCESSORS_ONLN", 97);
        ShadowOsConstants.initConstant("_SC_OPEN_MAX", 11);
        ShadowOsConstants.initConstant("_SC_PAGESIZE", 39);
        ShadowOsConstants.initConstant("_SC_PAGE_SIZE", 40);
        ShadowOsConstants.initConstant("_SC_PASS_MAX", 12);
        ShadowOsConstants.initConstant("_SC_PHYS_PAGES", 98);
        ShadowOsConstants.initConstant("_SC_PRIORITIZED_IO", 64);
        ShadowOsConstants.initConstant("_SC_PRIORITY_SCHEDULING", 65);
        ShadowOsConstants.initConstant("_SC_REALTIME_SIGNALS", 66);
        ShadowOsConstants.initConstant("_SC_RE_DUP_MAX", 26);
        ShadowOsConstants.initConstant("_SC_RTSIG_MAX", 52);
        ShadowOsConstants.initConstant("_SC_SAVED_IDS", 24);
        ShadowOsConstants.initConstant("_SC_SEMAPHORES", 67);
        ShadowOsConstants.initConstant("_SC_SEM_NSEMS_MAX", 53);
        ShadowOsConstants.initConstant("_SC_SEM_VALUE_MAX", 54);
        ShadowOsConstants.initConstant("_SC_SHARED_MEMORY_OBJECTS", 68);
        ShadowOsConstants.initConstant("_SC_SIGQUEUE_MAX", 55);
        ShadowOsConstants.initConstant("_SC_STREAM_MAX", 27);
        ShadowOsConstants.initConstant("_SC_SYNCHRONIZED_IO", 69);
        ShadowOsConstants.initConstant("_SC_THREADS", 79);
        ShadowOsConstants.initConstant("_SC_THREAD_ATTR_STACKADDR", 80);
        ShadowOsConstants.initConstant("_SC_THREAD_ATTR_STACKSIZE", 81);
        ShadowOsConstants.initConstant("_SC_THREAD_DESTRUCTOR_ITERATIONS", 74);
        ShadowOsConstants.initConstant("_SC_THREAD_KEYS_MAX", 75);
        ShadowOsConstants.initConstant("_SC_THREAD_PRIORITY_SCHEDULING", 82);
        ShadowOsConstants.initConstant("_SC_THREAD_PRIO_INHERIT", 83);
        ShadowOsConstants.initConstant("_SC_THREAD_PRIO_PROTECT", 84);
        ShadowOsConstants.initConstant("_SC_THREAD_SAFE_FUNCTIONS", 85);
        ShadowOsConstants.initConstant("_SC_THREAD_STACK_MIN", 76);
        ShadowOsConstants.initConstant("_SC_THREAD_THREADS_MAX", 77);
        ShadowOsConstants.initConstant("_SC_TIMERS", 70);
        ShadowOsConstants.initConstant("_SC_TIMER_MAX", 56);
        ShadowOsConstants.initConstant("_SC_TTY_NAME_MAX", 78);
        ShadowOsConstants.initConstant("_SC_TZNAME_MAX", 28);
        ShadowOsConstants.initConstant("_SC_VERSION", 25);
        ShadowOsConstants.initConstant("_SC_XBS5_ILP32_OFF32", 42);
        ShadowOsConstants.initConstant("_SC_XBS5_ILP32_OFFBIG", 43);
        ShadowOsConstants.initConstant("_SC_XBS5_LP64_OFF64", 44);
        ShadowOsConstants.initConstant("_SC_XBS5_LPBIG_OFFBIG", 45);
        ShadowOsConstants.initConstant("_SC_XOPEN_CRYPT", 29);
        ShadowOsConstants.initConstant("_SC_XOPEN_ENH_I18N", 30);
        ShadowOsConstants.initConstant("_SC_XOPEN_LEGACY", 36);
        ShadowOsConstants.initConstant("_SC_XOPEN_REALTIME", 34);
        ShadowOsConstants.initConstant("_SC_XOPEN_REALTIME_THREADS", 35);
        ShadowOsConstants.initConstant("_SC_XOPEN_SHM", 31);
        ShadowOsConstants.initConstant("_SC_XOPEN_UNIX", 41);
        ShadowOsConstants.initConstant("_SC_XOPEN_VERSION", 32);
        ShadowOsConstants.initConstant("_SC_XOPEN_XCU_VERSION", 33);
    }

    private static void initConstant(String fieldName, int value) {
        try {
            Field field = OsConstants.class.getField(fieldName);
            field.setInt(field, value);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static int getMode(String path) {
        if (path == null) {
            return 0;
        }
        int mode = 0;
        File file = new File(path);
        if (file.isDirectory()) {
            mode |= OsConstants.S_IFDIR;
        } else if (file.isFile()) {
            mode |= OsConstants.S_IFREG;
        } else if (!ShadowOsConstants.canonicalize(path).equals(path)) {
            mode |= OsConstants.S_IFLNK;
        }
        if (file.canExecute()) {
            mode |= OsConstants.S_IXUSR | OsConstants.S_IXGRP | OsConstants.S_IXOTH;
        }
        if (file.canRead()) {
            mode |= OsConstants.S_IRUSR | OsConstants.S_IRGRP | OsConstants.S_IROTH;
        }
        if (file.canWrite()) {
            mode |= OsConstants.S_IWUSR | OsConstants.S_IWGRP | OsConstants.S_IWOTH;
        }
        return mode;
    }

    private static String canonicalize(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

