/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.PackageInfo;
import android.content.pm.PackageParser;
import android.util.DisplayMetrics;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowLog;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Static;
import org.robolectric.util.reflector.WithType;

@Implements(value=PackageParser.class, isInAndroidSdk=false)
public class ShadowPackageParser {
    public static PackageParser.Package callParsePackage(Path apkFile) {
        PackageParser packageParser = new PackageParser();
        try {
            PackageParser.Package thePackage;
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                QHelper.setCallback(packageParser);
            }
            if ((thePackage = packageParser.parsePackage(apkFile.toFile(), 0)) == null) {
                ImmutableList<ShadowLog.LogItem> logItems = ShadowLog.getLogsForTag("PackageParser");
                if (logItems.isEmpty()) {
                    throw new RuntimeException("Failed to parse package " + apkFile);
                }
                ShadowLog.LogItem logItem = (ShadowLog.LogItem)logItems.get(0);
                throw new RuntimeException("Failed to parse package " + apkFile + ": " + logItem.msg, logItem.throwable);
            }
            return thePackage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object newPackageUserState() {
        try {
            return ReflectionHelpers.newInstance(Class.forName("android.content.pm.PackageUserState"));
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class QHelper {
        private QHelper() {
        }

        private static void setCallback(PackageParser packageParser) {
            packageParser.setCallback(new PackageParser.Callback(){

                public boolean hasFeature(String s) {
                    return false;
                }

                public String[] getOverlayPaths(String s, String s1) {
                    return null;
                }

                public String[] getOverlayApks(String s) {
                    return null;
                }
            });
        }
    }

    @ForType(value=PackageParser.Package.class)
    public static interface PackageReflector {
        @Accessor(value="mPath")
        public String getPath();
    }

    @ForType(value=PackageParser.class)
    static interface PackageParserReflector {
        @Static
        public PackageInfo generatePackageInfo(PackageParser.Package var1, int[] var2, int var3, long var4, long var6, Set<String> var8, @WithType(value="android.content.pm.PackageUserState") Object var9);

        default public PackageInfo generatePackageInfo(PackageParser.Package p, int[] gids, int flags, long firstInstallTime, long lastUpdateTime) {
            return this.generatePackageInfo(p, gids, flags, firstInstallTime, lastUpdateTime, new HashSet<String>(), ShadowPackageParser.newPackageUserState());
        }

        public PackageParser.Package parsePackage(File var1, String var2, DisplayMetrics var3, int var4);
    }
}

