/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Process;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Process.class)
public class ShadowProcess {
    private static int pid;
    private static final int UID;
    private static Integer uidOverride;
    private static final int tid;
    private static final Object threadPrioritiesLock;
    private static final Object killedProcessesLock;
    private static final int THREAD_PRIORITY_HIGHEST = -20;
    private static final int THREAD_PRIORITY_LOWEST = 19;
    @GuardedBy(value="threadPrioritiesLock")
    private static final Map<Integer, Integer> threadPriorities;
    @GuardedBy(value="killedProcessesLock")
    private static final Set<Integer> killedProcesses;
    private static String processName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static void killProcess(int pid) {
        Object object = killedProcessesLock;
        synchronized (object) {
            killedProcesses.add(pid);
        }
    }

    @Implementation
    protected static int myPid() {
        return pid;
    }

    @Implementation
    protected static int myUid() {
        if (uidOverride != null) {
            return uidOverride;
        }
        return UID;
    }

    @Implementation
    protected static int myTid() {
        return (int)Thread.currentThread().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static void setThreadPriority(int priority) {
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.put(ShadowProcess.myTid(), priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static void setThreadPriority(int tid, int priority) {
        Preconditions.checkArgument((priority >= -20 && priority <= 19 ? 1 : 0) != 0, (String)"priority %s out of range [%s, %s]. It is recommended to use a Process.THREAD_PRIORITY_* constant.", (Object)priority, (Object)Integer.toString(-20), (Object)Integer.toString(19));
        if (tid == 0) {
            tid = ShadowProcess.myTid();
        }
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.put(tid, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static int getThreadPriority(int tid) {
        if (tid == 0) {
            tid = ShadowProcess.myTid();
        }
        Object object = threadPrioritiesLock;
        synchronized (object) {
            return threadPriorities.getOrDefault(tid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearKilledProcesses() {
        Object object = killedProcessesLock;
        synchronized (object) {
            killedProcesses.clear();
        }
    }

    public static void setUid(int uid) {
        uidOverride = uid;
    }

    public static void setPid(int pid) {
        ShadowProcess.pid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        pid = 0;
        ShadowProcess.clearKilledProcesses();
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.clear();
        }
        uidOverride = null;
        processName = "";
    }

    static int getRandomApplicationUid() {
        return ThreadLocalRandom.current().nextInt(10000, 20000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wasKilled(int pid) {
        Object object = killedProcessesLock;
        synchronized (object) {
            return killedProcesses.contains(pid);
        }
    }

    @Implementation(minSdk=33)
    protected static String myProcessName() {
        return processName;
    }

    public static void setProcessName(@Nonnull String processName) {
        ShadowProcess.processName = processName;
    }

    public static void setIsolatedUid() {
        ShadowProcess.setUid(99000);
    }

    public static void setIsIsolated() {
        ShadowProcess.setIsolatedUid();
    }

    static {
        UID = ShadowProcess.getRandomApplicationUid();
        tid = ShadowProcess.getRandomApplicationUid();
        threadPrioritiesLock = new Object();
        killedProcessesLock = new Object();
        threadPriorities = new HashMap<Integer, Integer>();
        killedProcesses = new HashSet<Integer>();
        processName = "";
    }
}

