/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.app.StatsManager;
import com.google.auto.value.AutoValue;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowStatsManager_BroadcastSubscriberKey;

@Implements(value=StatsManager.class, isInAndroidSdk=false, minSdk=28)
public class ShadowStatsManager {
    private static final Map<Long, byte[]> reportDataMap = new HashMap<Long, byte[]>();
    private static byte[] statsMetadata = new byte[0];
    private static final Map<Long, byte[]> configDataMap = new HashMap<Long, byte[]>();
    private static final Map<BroadcastSubscriberKey, PendingIntent> broadcastSubscriberMap = new HashMap<BroadcastSubscriberKey, PendingIntent>();
    private static long[] registeredExperimentIds = new long[0];

    @Resetter
    public static void reset() {
        reportDataMap.clear();
        statsMetadata = new byte[0];
        configDataMap.clear();
        broadcastSubscriberMap.clear();
    }

    public static void addReportData(long configKey, byte[] data) {
        reportDataMap.put(configKey, data);
    }

    public static void setStatsMetadata(byte[] metadata) {
        statsMetadata = metadata;
    }

    public static void setRegisteredExperimentIds(long[] experimentIds) {
        registeredExperimentIds = experimentIds;
    }

    public static byte[] getConfigData(long configKey) {
        return configDataMap.getOrDefault(configKey, new byte[0]);
    }

    public static Map<BroadcastSubscriberKey, PendingIntent> getBroadcastSubscriberMap() {
        return broadcastSubscriberMap;
    }

    @Implementation
    protected byte[] getReports(long configKey) {
        byte[] data = reportDataMap.getOrDefault(configKey, new byte[0]);
        reportDataMap.remove(configKey);
        return data;
    }

    @Implementation
    protected byte[] getStatsMetadata() {
        return statsMetadata;
    }

    @Implementation
    protected void addConfig(long configKey, byte[] config) {
        configDataMap.put(configKey, config);
    }

    @Implementation
    protected void removeConfig(long configKey) {
        configDataMap.remove(configKey);
    }

    @Implementation
    protected void setBroadcastSubscriber(PendingIntent pendingIntent, long configKey, long subscriberId) {
        BroadcastSubscriberKey key = BroadcastSubscriberKey.create(configKey, subscriberId);
        if (pendingIntent != null) {
            broadcastSubscriberMap.put(key, pendingIntent);
        } else {
            broadcastSubscriberMap.remove(key);
        }
    }

    @Implementation(minSdk=29)
    protected long[] getRegisteredExperimentIds() {
        return registeredExperimentIds;
    }

    @AutoValue
    public static abstract class BroadcastSubscriberKey {
        public static BroadcastSubscriberKey create(long key, long id) {
            return new AutoValue_ShadowStatsManager_BroadcastSubscriberKey(key, id);
        }

        public abstract long getKey();

        public abstract long getId();
    }
}

