/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.os.Vibrator;
import android.os.vibrator.PrimitiveSegment;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Vibrator.class)
public class ShadowVibrator {
    static boolean vibrating;
    static boolean cancelled;
    static long milliseconds;
    protected static long[] pattern;
    protected static final List<Object> vibrationEffectSegments;
    protected static final List<PrimitiveEffect> primitiveEffects;
    protected static final List<Integer> supportedPrimitives;
    protected static final SparseIntArray primitiveidsToDurationMillis;
    @Nullable
    protected static Object vibrationAttributesFromLastVibration;
    @Nullable
    protected static AudioAttributes audioAttributesFromLastVibration;
    static int repeat;
    static boolean hasVibrator;
    static boolean hasAmplitudeControl;
    static int effectId;

    public void setHasVibrator(boolean hasVibrator) {
        ShadowVibrator.hasVibrator = hasVibrator;
    }

    public void setHasAmplitudeControl(boolean hasAmplitudeControl) {
        ShadowVibrator.hasAmplitudeControl = hasAmplitudeControl;
    }

    @Implementation(minSdk=30)
    public boolean isVibrating() {
        return vibrating;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    public long getMilliseconds() {
        return milliseconds;
    }

    public long[] getPattern() {
        return pattern;
    }

    public int getEffectId() {
        return effectId;
    }

    public int getRepeat() {
        return repeat;
    }

    public List<PrimitiveEffect> getPrimitiveSegmentsInPrimitiveEffects() {
        return vibrationEffectSegments.stream().filter(segment -> segment instanceof PrimitiveSegment).map(segment -> new PrimitiveEffect((Integer)ReflectionHelpers.getField((Object)segment, (String)"mPrimitiveId"), ((Float)ReflectionHelpers.getField((Object)segment, (String)"mScale")).floatValue(), (Integer)ReflectionHelpers.getField((Object)segment, (String)"mDelay"))).collect(Collectors.toList());
    }

    @Nullable
    public List<PrimitiveEffect> getPrimitiveEffects() {
        return primitiveEffects;
    }

    @Implementation(minSdk=30)
    protected boolean areAllPrimitivesSupported(int ... primitiveIds) {
        for (int primitiveId : primitiveIds) {
            if (supportedPrimitives.contains(primitiveId)) continue;
            return false;
        }
        return true;
    }

    public void setSupportedPrimitives(Collection<Integer> primitives) {
        supportedPrimitives.clear();
        supportedPrimitives.addAll(primitives);
    }

    @Implementation(minSdk=31)
    protected int[] getPrimitiveDurations(int ... primitiveIds) {
        int[] durations = new int[primitiveIds.length];
        for (int i = 0; i < primitiveIds.length; ++i) {
            durations[i] = primitiveidsToDurationMillis.get(primitiveIds[i], 0);
        }
        return durations;
    }

    public void setPrimitiveDurations(int primitiveId, int durationMillis) {
        primitiveidsToDurationMillis.put(primitiveId, durationMillis);
    }

    @Nullable
    public Object getVibrationAttributesFromLastVibration() {
        return vibrationAttributesFromLastVibration;
    }

    @Nullable
    public AudioAttributes getAudioAttributesFromLastVibration() {
        return audioAttributesFromLastVibration;
    }

    @Resetter
    public static void reset() {
        vibrating = false;
        cancelled = false;
        milliseconds = 0L;
        pattern = null;
        vibrationEffectSegments.clear();
        primitiveEffects.clear();
        supportedPrimitives.clear();
        vibrationAttributesFromLastVibration = null;
        audioAttributesFromLastVibration = null;
        repeat = 0;
        hasVibrator = true;
        hasAmplitudeControl = false;
        effectId = 0;
        primitiveidsToDurationMillis.clear();
    }

    static {
        vibrationEffectSegments = new ArrayList<Object>();
        primitiveEffects = new ArrayList<PrimitiveEffect>();
        supportedPrimitives = new ArrayList<Integer>();
        primitiveidsToDurationMillis = new SparseIntArray();
        hasVibrator = true;
        hasAmplitudeControl = false;
    }

    public static class PrimitiveEffect {
        public final int id;
        public final float scale;
        public final int delay;

        public PrimitiveEffect(int id, float scale, int delay) {
            this.id = id;
            this.scale = scale;
            this.delay = delay;
        }

        public String toString() {
            return "PrimitiveEffect{id=" + this.id + ", scale=" + this.scale + ", delay=" + this.delay + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!this.getClass().isInstance(o)) {
                return false;
            }
            PrimitiveEffect that = (PrimitiveEffect)o;
            return this.id == that.id && Float.compare(that.scale, this.scale) == 0 && this.delay == that.delay;
        }

        public int hashCode() {
            return Objects.hash(this.id, Float.valueOf(this.scale), this.delay);
        }
    }
}

