/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public final class StreamConfigurationMapBuilder {
    private static final int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private final HashMap<Integer, Collection<Size>> inputFormatWithSupportedSize = new HashMap();
    private final HashMap<Integer, Collection<Size>> outputFormatWithSupportedSize = new HashMap();

    public static StreamConfigurationMapBuilder newBuilder() {
        return new StreamConfigurationMapBuilder();
    }

    public StreamConfigurationMapBuilder addOutputSize(int format, Size outputSize) {
        if (!this.outputFormatWithSupportedSize.containsKey(format)) {
            ArrayList outputSizes = new ArrayList();
            this.outputFormatWithSupportedSize.put(format, outputSizes);
        }
        this.outputFormatWithSupportedSize.get(format).add(outputSize);
        return this;
    }

    public StreamConfigurationMapBuilder addInputSize(int format, Size inputSize) {
        if (!this.inputFormatWithSupportedSize.containsKey(format)) {
            ArrayList inputSizes = new ArrayList();
            this.inputFormatWithSupportedSize.put(format, inputSizes);
        }
        this.inputFormatWithSupportedSize.get(format).add(inputSize);
        return this;
    }

    public StreamConfigurationMapBuilder addOutputSize(Size outputSize) {
        this.addOutputSize(34, outputSize);
        return this;
    }

    public StreamConfigurationMap build() {
        ArrayList<StreamConfiguration> configsList = new ArrayList<StreamConfiguration>();
        boolean hasPrivateOutput = false;
        for (Map.Entry<Integer, Collection<Size>> entry : this.outputFormatWithSupportedSize.entrySet()) {
            hasPrivateOutput = hasPrivateOutput || entry.getKey() == 34;
            for (Size size : entry.getValue()) {
                configsList.add(new StreamConfiguration(entry.getKey().intValue(), size.getWidth(), size.getHeight(), false));
            }
        }
        if (!hasPrivateOutput) {
            configsList.add(new StreamConfiguration(34, 1, 1, false));
        }
        for (Map.Entry<Integer, Collection<Size>> entry : this.inputFormatWithSupportedSize.entrySet()) {
            for (Size size : entry.getValue()) {
                configsList.add(new StreamConfiguration(entry.getKey().intValue(), size.getWidth(), size.getHeight(), true));
            }
        }
        StreamConfiguration[] configs = new StreamConfiguration[configsList.size()];
        configsList.toArray(configs);
        if (RuntimeEnvironment.getApiLevel() < 23) {
            return ((StreamConfigurationMapReflector)Reflector.reflector(StreamConfigurationMapReflector.class)).newStreamConfigurationMapL(configs, new StreamConfigurationDuration[0], new StreamConfigurationDuration[0], null);
        }
        if (RuntimeEnvironment.getApiLevel() < 29) {
            return ((StreamConfigurationMapReflector)Reflector.reflector(StreamConfigurationMapReflector.class)).newStreamConfigurationMapM(configs, new StreamConfigurationDuration[0], new StreamConfigurationDuration[0], null, null, null, null, null, false);
        }
        if (RuntimeEnvironment.getApiLevel() <= 33) {
            return ((StreamConfigurationMapReflector)Reflector.reflector(StreamConfigurationMapReflector.class)).newStreamConfigurationMapQ(configs, new StreamConfigurationDuration[0], new StreamConfigurationDuration[0], null, null, null, null, null, null, null, null, null, null, null, false);
        }
        if (RuntimeEnvironment.getApiLevel() <= 35) {
            return ((StreamConfigurationMapReflector)Reflector.reflector(StreamConfigurationMapReflector.class)).newStreamConfigurationMapV(configs, new StreamConfigurationDuration[0], new StreamConfigurationDuration[0], null, null, null, null, null, null, null, null, null, null, null, null, null, null, false);
        }
        return ((StreamConfigurationMapReflector)Reflector.reflector(StreamConfigurationMapReflector.class)).newStreamConfigurationMapW(configs, new StreamConfigurationDuration[0], new StreamConfigurationDuration[0], null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false);
    }

    private StreamConfigurationMapBuilder() {
    }

    @ForType(value=StreamConfigurationMap.class)
    static interface StreamConfigurationMapReflector {
        @Constructor
        public StreamConfigurationMap newStreamConfigurationMapL(StreamConfiguration[] var1, StreamConfigurationDuration[] var2, StreamConfigurationDuration[] var3, HighSpeedVideoConfiguration[] var4);

        @Constructor
        public StreamConfigurationMap newStreamConfigurationMapM(StreamConfiguration[] var1, StreamConfigurationDuration[] var2, StreamConfigurationDuration[] var3, StreamConfiguration[] var4, StreamConfigurationDuration[] var5, StreamConfigurationDuration[] var6, HighSpeedVideoConfiguration[] var7, ReprocessFormatsMap var8, boolean var9);

        @Constructor
        public StreamConfigurationMap newStreamConfigurationMapQ(StreamConfiguration[] var1, StreamConfigurationDuration[] var2, StreamConfigurationDuration[] var3, StreamConfiguration[] var4, StreamConfigurationDuration[] var5, StreamConfigurationDuration[] var6, StreamConfiguration[] var7, StreamConfigurationDuration[] var8, StreamConfigurationDuration[] var9, StreamConfiguration[] var10, StreamConfigurationDuration[] var11, StreamConfigurationDuration[] var12, HighSpeedVideoConfiguration[] var13, ReprocessFormatsMap var14, boolean var15);

        @Constructor
        public StreamConfigurationMap newStreamConfigurationMapV(StreamConfiguration[] var1, StreamConfigurationDuration[] var2, StreamConfigurationDuration[] var3, StreamConfiguration[] var4, StreamConfigurationDuration[] var5, StreamConfigurationDuration[] var6, StreamConfiguration[] var7, StreamConfigurationDuration[] var8, StreamConfigurationDuration[] var9, StreamConfiguration[] var10, StreamConfigurationDuration[] var11, StreamConfigurationDuration[] var12, StreamConfiguration[] var13, StreamConfigurationDuration[] var14, StreamConfigurationDuration[] var15, HighSpeedVideoConfiguration[] var16, ReprocessFormatsMap var17, boolean var18);

        @Constructor
        public StreamConfigurationMap newStreamConfigurationMapW(StreamConfiguration[] var1, StreamConfigurationDuration[] var2, StreamConfigurationDuration[] var3, StreamConfiguration[] var4, StreamConfigurationDuration[] var5, StreamConfigurationDuration[] var6, StreamConfiguration[] var7, StreamConfigurationDuration[] var8, StreamConfigurationDuration[] var9, StreamConfiguration[] var10, StreamConfigurationDuration[] var11, StreamConfigurationDuration[] var12, StreamConfiguration[] var13, StreamConfigurationDuration[] var14, StreamConfigurationDuration[] var15, StreamConfiguration[] var16, StreamConfigurationDuration[] var17, StreamConfigurationDuration[] var18, HighSpeedVideoConfiguration[] var19, ReprocessFormatsMap var20, boolean var21);
    }
}

