/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.TestLooperManager;
import java.util.Objects;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowMessage;
import org.robolectric.shadows.ShadowPausedMessage;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

final class TestLooperManagerCompat
implements AutoCloseable {
    private final MessageQueue queue;
    private final TestLooperManager delegate;

    TestLooperManagerCompat(MessageQueue queue) {
        this.queue = queue;
        this.delegate = null;
    }

    private TestLooperManagerCompat(TestLooperManager testLooperManager) {
        this.queue = null;
        this.delegate = testLooperManager;
    }

    static TestLooperManagerCompat acquire(Looper looper) {
        if (RuntimeEnvironment.getApiLevel() >= 36) {
            TestLooperManager testLooperManager = new TestLooperManager(looper);
            return new TestLooperManagerCompat(testLooperManager);
        }
        return new TestLooperManagerCompat(looper.getQueue());
    }

    @Nullable
    Long peekWhen() {
        try {
            if (this.delegate != null) {
                return this.delegate.peekWhen();
            }
            Message msg = this.legacyPeek();
            if (msg != null && msg.getTarget() == null) {
                return null;
            }
            return msg == null ? null : Long.valueOf(msg.getWhen());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Message legacyPeek() throws IllegalAccessException {
        LegacyMessageQueueReflector queueReflector = (LegacyMessageQueueReflector)Reflector.reflector(LegacyMessageQueueReflector.class, (Object)this.queue);
        MessageQueue messageQueue = Objects.requireNonNull(this.queue);
        synchronized (messageQueue) {
            Message msg = queueReflector.getMessages();
            if (msg != null && msg.getTarget() == null) {
                while ((msg = TestLooperManagerCompat.shadowOfMsg(msg).internalGetNext()) != null && !msg.isAsynchronous()) {
                }
            }
            return msg;
        }
    }

    Message poll() {
        if (this.delegate != null) {
            return this.delegate.poll();
        }
        return this.legacyPoll(this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message legacyPoll(MessageQueue realQueue) {
        LegacyMessageQueueReflector queueReflector = (LegacyMessageQueueReflector)Reflector.reflector(LegacyMessageQueueReflector.class, (Object)realQueue);
        MessageQueue messageQueue = realQueue;
        synchronized (messageQueue) {
            Message prevMsg = null;
            Message msg = queueReflector.getMessages();
            if (msg != null && msg.getTarget() == null) {
                do {
                    prevMsg = msg;
                } while ((msg = TestLooperManagerCompat.shadowOfMsg(msg).internalGetNext()) != null && !msg.isAsynchronous());
            }
            if (msg != null) {
                Message nextMsg = ((ShadowMessage.MessageReflector)Reflector.reflector(ShadowMessage.MessageReflector.class, (Object)msg)).getNext();
                if (prevMsg != null) {
                    ((ShadowMessage.MessageReflector)Reflector.reflector(ShadowMessage.MessageReflector.class, (Object)prevMsg)).setNext(nextMsg);
                    if (((ShadowMessage.MessageReflector)Reflector.reflector(ShadowMessage.MessageReflector.class, (Object)prevMsg)).getNext() == null && RuntimeEnvironment.getApiLevel() >= 35) {
                        queueReflector.setLast(prevMsg);
                    }
                } else {
                    queueReflector.setMessages(nextMsg);
                    if (nextMsg == null && RuntimeEnvironment.getApiLevel() >= 35) {
                        queueReflector.setLast(null);
                    }
                }
                if (msg.isAsynchronous() && RuntimeEnvironment.getApiLevel() >= 35) {
                    queueReflector.setAsyncMessageCount(queueReflector.getAsyncMessageCount() - 1);
                }
            }
            return msg;
        }
    }

    private static ShadowPausedMessage shadowOfMsg(Message msg) {
        return (ShadowPausedMessage)Shadow.extract((Object)msg);
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.release();
        }
    }

    @ForType(value=MessageQueue.class)
    private static interface LegacyMessageQueueReflector {
        @Accessor(value="mMessages")
        public Message getMessages();

        @Accessor(value="mLast")
        public void setLast(Message var1);

        @Accessor(value="mAsyncMessageCount")
        public int getAsyncMessageCount();

        @Accessor(value="mAsyncMessageCount")
        public void setAsyncMessageCount(int var1);

        @Accessor(value="mBlocked")
        public void setBlocked(boolean var1);

        @Accessor(value="mMessages")
        public void setMessages(Message var1);
    }
}

