/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

public class NativeBitSet64 {
    private long value;

    NativeBitSet64(long value) {
        this.value = value;
    }

    NativeBitSet64(NativeBitSet64 other) {
        this.value = other.value;
    }

    NativeBitSet64() {
        this(0L);
    }

    static long valueForBit(int n) {
        return Long.MIN_VALUE >>> n;
    }

    void clear() {
        this.value = 0L;
    }

    int count() {
        int count = 0;
        for (int n = 0; n < 64; ++n) {
            if (!this.hasBit(n)) continue;
            ++count;
        }
        return count;
    }

    boolean isEmpty() {
        return this.value == 0L;
    }

    boolean hasBit(int n) {
        return (this.value & NativeBitSet64.valueForBit(n)) != 0L;
    }

    void markBit(int n) {
        this.value |= NativeBitSet64.valueForBit(n);
    }

    void clearBit(int n) {
        this.value &= NativeBitSet64.valueForBit(n) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    int firstMarkedBit() {
        for (int n = 0; n < 64; ++n) {
            if (!this.hasBit(n)) continue;
            return n;
        }
        return 0;
    }

    int clearFirstMarkedBit() {
        int n = this.firstMarkedBit();
        this.clearBit(n);
        return n;
    }

    int getIndexOfBit(int n) {
        int numMarkedBits = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.hasBit(i)) continue;
            ++numMarkedBits;
        }
        return numMarkedBits;
    }

    public void setValue(long l) {
        this.value = l;
    }

    public long getValue() {
        return this.value;
    }
}

