/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=NfcAdapter.class)
public class ShadowNfcAdapter {
    @RealObject
    NfcAdapter nfcAdapter;
    private static boolean hardwareExists = true;
    private boolean enabled;
    private Activity enabledActivity;
    private PendingIntent intent;
    private IntentFilter[] filters;
    private String[][] techLists;
    private Activity disabledActivity;
    private NdefMessage ndefPushMessage;
    private boolean ndefPushMessageSet;
    private NfcAdapter.CreateNdefMessageCallback ndefPushMessageCallback;
    private NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback;

    @Implementation
    protected static NfcAdapter getNfcAdapter(Context context) {
        if (!hardwareExists) {
            return null;
        }
        return (NfcAdapter)ReflectionHelpers.callConstructor(NfcAdapter.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    protected void enableForegroundDispatch(Activity activity, PendingIntent intent, IntentFilter[] filters, String[][] techLists) {
        this.enabledActivity = activity;
        this.intent = intent;
        this.filters = filters;
        this.techLists = techLists;
    }

    @Implementation
    protected void disableForegroundDispatch(Activity activity) {
        this.disabledActivity = activity;
    }

    @Implementation
    protected void setNdefPushMessage(NdefMessage message, Activity activity, Activity ... activities) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        for (Activity a : activities) {
            if (a != null) continue;
            throw new NullPointerException("activities cannot contain null");
        }
        this.ndefPushMessage = message;
        this.ndefPushMessageSet = true;
    }

    @Implementation
    protected void setNdefPushMessageCallback(NfcAdapter.CreateNdefMessageCallback callback, Activity activity, Activity ... activities) {
        this.ndefPushMessageCallback = callback;
    }

    @Implementation
    protected void setOnNdefPushCompleteCallback(NfcAdapter.OnNdefPushCompleteCallback callback, Activity activity, Activity ... activities) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        for (Activity a : activities) {
            if (a != null) continue;
            throw new NullPointerException("activities cannot contain null");
        }
        this.onNdefPushCompleteCallback = callback;
    }

    @Implementation
    protected boolean isEnabled() {
        return this.enabled;
    }

    public static void setNfcHardwareExists(boolean hardwareExists) {
        ShadowNfcAdapter.hardwareExists = hardwareExists;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Activity getEnabledActivity() {
        return this.enabledActivity;
    }

    public PendingIntent getIntent() {
        return this.intent;
    }

    public IntentFilter[] getFilters() {
        return this.filters;
    }

    public String[][] getTechLists() {
        return this.techLists;
    }

    public Activity getDisabledActivity() {
        return this.disabledActivity;
    }

    public NfcAdapter.CreateNdefMessageCallback getNdefPushMessageCallback() {
        return this.ndefPushMessageCallback;
    }

    public NfcAdapter.OnNdefPushCompleteCallback getOnNdefPushCompleteCallback() {
        return this.onNdefPushCompleteCallback;
    }

    public NdefMessage getNdefPushMessage() {
        if (!this.ndefPushMessageSet) {
            throw new IllegalStateException();
        }
        return this.ndefPushMessage;
    }

    @Resetter
    public static synchronized void reset() {
        hardwareExists = true;
    }
}

