/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.util;

import android.content.Context;
import android.media.MediaDataSource;
import android.net.Uri;
import java.io.FileDescriptor;
import java.util.Map;

public class DataSource {
    private String dataSource;

    private DataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public static DataSource toDataSource(String path) {
        return new DataSource(path);
    }

    public static DataSource toDataSource(Context context, Uri uri) {
        return DataSource.toDataSource(uri.toString());
    }

    public static DataSource toDataSource(Context context, Uri uri, Map<String, String> headers) {
        return DataSource.toDataSource(context, uri);
    }

    public static DataSource toDataSource(String uri, Map<String, String> headers) {
        return DataSource.toDataSource(uri);
    }

    public static DataSource toDataSource(FileDescriptor fd) {
        return DataSource.toDataSource(fd, 0L, 0L);
    }

    public static DataSource toDataSource(MediaDataSource mediaDataSource) {
        return DataSource.toDataSource("MediaDataSource");
    }

    public static DataSource toDataSource(FileDescriptor fd, long offset, long length) {
        return DataSource.toDataSource(fd.toString() + offset);
    }

    public int hashCode() {
        return this.dataSource == null ? 0 : this.dataSource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        return !(this.dataSource == null ? other.dataSource != null : !this.dataSource.equals(other.dataSource));
    }
}

