

package org.robolectric.shadows;

import androidx.annotation.Nullable;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GnssStatusBuilder_GnssSatelliteInfo extends GnssStatusBuilder.GnssSatelliteInfo {

  private final int constellation;

  private final int svid;

  private final float cn0DbHz;

  private final float elevation;

  private final float azimuth;

  private final boolean hasEphemeris;

  private final boolean hasAlmanac;

  private final boolean usedInFix;

  private final Float carrierFrequencyHz;

  private AutoValue_GnssStatusBuilder_GnssSatelliteInfo(
      int constellation,
      int svid,
      float cn0DbHz,
      float elevation,
      float azimuth,
      boolean hasEphemeris,
      boolean hasAlmanac,
      boolean usedInFix,
      @Nullable Float carrierFrequencyHz) {
    this.constellation = constellation;
    this.svid = svid;
    this.cn0DbHz = cn0DbHz;
    this.elevation = elevation;
    this.azimuth = azimuth;
    this.hasEphemeris = hasEphemeris;
    this.hasAlmanac = hasAlmanac;
    this.usedInFix = usedInFix;
    this.carrierFrequencyHz = carrierFrequencyHz;
  }

  @Override
  public int getConstellation() {
    return constellation;
  }

  @Override
  public int getSvid() {
    return svid;
  }

  @Override
  public float getCn0DbHz() {
    return cn0DbHz;
  }

  @Override
  public float getElevation() {
    return elevation;
  }

  @Override
  public float getAzimuth() {
    return azimuth;
  }

  @Override
  public boolean getHasEphemeris() {
    return hasEphemeris;
  }

  @Override
  public boolean getHasAlmanac() {
    return hasAlmanac;
  }

  @Override
  public boolean isUsedInFix() {
    return usedInFix;
  }

  @Nullable
  @Override
  public Float getCarrierFrequencyHz() {
    return carrierFrequencyHz;
  }

  @Override
  public String toString() {
    return "GnssSatelliteInfo{"
         + "constellation=" + constellation + ", "
         + "svid=" + svid + ", "
         + "cn0DbHz=" + cn0DbHz + ", "
         + "elevation=" + elevation + ", "
         + "azimuth=" + azimuth + ", "
         + "hasEphemeris=" + hasEphemeris + ", "
         + "hasAlmanac=" + hasAlmanac + ", "
         + "usedInFix=" + usedInFix + ", "
         + "carrierFrequencyHz=" + carrierFrequencyHz
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GnssStatusBuilder.GnssSatelliteInfo) {
      GnssStatusBuilder.GnssSatelliteInfo that = (GnssStatusBuilder.GnssSatelliteInfo) o;
      return (this.constellation == that.getConstellation())
           && (this.svid == that.getSvid())
           && (Float.floatToIntBits(this.cn0DbHz) == Float.floatToIntBits(that.getCn0DbHz()))
           && (Float.floatToIntBits(this.elevation) == Float.floatToIntBits(that.getElevation()))
           && (Float.floatToIntBits(this.azimuth) == Float.floatToIntBits(that.getAzimuth()))
           && (this.hasEphemeris == that.getHasEphemeris())
           && (this.hasAlmanac == that.getHasAlmanac())
           && (this.usedInFix == that.isUsedInFix())
           && ((this.carrierFrequencyHz == null) ? (that.getCarrierFrequencyHz() == null) : this.carrierFrequencyHz.equals(that.getCarrierFrequencyHz()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= constellation;
    h$ *= 1000003;
    h$ ^= svid;
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(cn0DbHz);
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(elevation);
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(azimuth);
    h$ *= 1000003;
    h$ ^= hasEphemeris ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= hasAlmanac ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= usedInFix ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (carrierFrequencyHz == null) ? 0 : carrierFrequencyHz.hashCode();
    return h$;
  }

  static final class Builder extends GnssStatusBuilder.GnssSatelliteInfo.Builder {
    private Integer constellation;
    private Integer svid;
    private Float cn0DbHz;
    private Float elevation;
    private Float azimuth;
    private Boolean hasEphemeris;
    private Boolean hasAlmanac;
    private Boolean usedInFix;
    private Float carrierFrequencyHz;
    Builder() {
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setConstellation(int constellation) {
      this.constellation = constellation;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setSvid(int svid) {
      this.svid = svid;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setCn0DbHz(float cn0DbHz) {
      this.cn0DbHz = cn0DbHz;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setElevation(float elevation) {
      this.elevation = elevation;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setAzimuth(float azimuth) {
      this.azimuth = azimuth;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setHasEphemeris(boolean hasEphemeris) {
      this.hasEphemeris = hasEphemeris;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setHasAlmanac(boolean hasAlmanac) {
      this.hasAlmanac = hasAlmanac;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setUsedInFix(boolean usedInFix) {
      this.usedInFix = usedInFix;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setCarrierFrequencyHz(@Nullable Float carrierFrequencyHz) {
      this.carrierFrequencyHz = carrierFrequencyHz;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo build() {
      String missing = "";
      if (this.constellation == null) {
        missing += " constellation";
      }
      if (this.svid == null) {
        missing += " svid";
      }
      if (this.cn0DbHz == null) {
        missing += " cn0DbHz";
      }
      if (this.elevation == null) {
        missing += " elevation";
      }
      if (this.azimuth == null) {
        missing += " azimuth";
      }
      if (this.hasEphemeris == null) {
        missing += " hasEphemeris";
      }
      if (this.hasAlmanac == null) {
        missing += " hasAlmanac";
      }
      if (this.usedInFix == null) {
        missing += " usedInFix";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GnssStatusBuilder_GnssSatelliteInfo(
          this.constellation,
          this.svid,
          this.cn0DbHz,
          this.elevation,
          this.azimuth,
          this.hasEphemeris,
          this.hasAlmanac,
          this.usedInFix,
          this.carrierFrequencyHz);
    }
  }

}
