/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android;

import android.content.res.Configuration;
import android.os.Build;
import android.util.DisplayMetrics;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.DeviceConfig;
import org.robolectric.res.Qualifiers;
import org.robolectric.shadows.ShadowDisplayManager;
import org.robolectric.shadows.ShadowWindowManagerImpl;

public class Bootstrap {
    public static void setUpDisplay(Configuration configuration, DisplayMetrics displayMetrics) {
        if (Build.VERSION.SDK_INT == 16) {
            ShadowWindowManagerImpl.configureDefaultDisplayForJBOnly(configuration, displayMetrics);
        } else {
            ShadowDisplayManager.configureDefaultDisplay(configuration, displayMetrics);
        }
    }

    public static void applyQualifiers(String qualifiersStrs, int apiLevel, Configuration configuration, DisplayMetrics displayMetrics) {
        String qualifiersStr;
        int i;
        String[] qualifiersParts = qualifiersStrs.split(" ", 0);
        for (i = qualifiersParts.length - 1; i >= 0 && (qualifiersStr = qualifiersParts[i]).startsWith("+"); --i) {
            qualifiersParts[i] = qualifiersStr.substring(1);
        }
        int n = i = i < 0 ? 0 : i;
        while (i < qualifiersParts.length) {
            qualifiersStr = qualifiersParts[i];
            int platformVersion = Qualifiers.getPlatformVersion((String)qualifiersStr);
            if (platformVersion != -1 && platformVersion != apiLevel) {
                throw new IllegalArgumentException(new StringBuilder(61 + String.valueOf(qualifiersStr).length()).append("Cannot specify conflicting platform version in qualifiers: \"").append(qualifiersStr).append("\"").toString());
            }
            Qualifiers qualifiers = Qualifiers.parse((String)qualifiersStr);
            DeviceConfig.applyToConfiguration(qualifiers, apiLevel, configuration, displayMetrics);
            ++i;
        }
        DeviceConfig.applyRules(configuration, displayMetrics, apiLevel);
        Bootstrap.fixJellyBean(configuration, displayMetrics);
    }

    private static void fixJellyBean(Configuration configuration, DisplayMetrics displayMetrics) {
        if (RuntimeEnvironment.getApiLevel() < 19) {
            int widthPx = (int)((float)configuration.screenWidthDp * displayMetrics.density);
            int heightPx = (int)((float)configuration.screenHeightDp * displayMetrics.density);
            displayMetrics.widthPixels = displayMetrics.noncompatWidthPixels = widthPx;
            displayMetrics.heightPixels = displayMetrics.noncompatHeightPixels = heightPx;
            displayMetrics.xdpi = displayMetrics.noncompatXdpi = (float)displayMetrics.densityDpi;
            displayMetrics.ydpi = displayMetrics.noncompatYdpi = (float)displayMetrics.densityDpi;
        }
    }
}

