/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.ShadowContentResolver;
import org.robolectric.util.Logger;

public class ContentProviderController<T extends ContentProvider> {
    private T contentProvider;

    private ContentProviderController(T contentProvider) {
        this.contentProvider = contentProvider;
    }

    public static <T extends ContentProvider> ContentProviderController<T> of(T contentProvider) {
        return new ContentProviderController<T>(contentProvider);
    }

    public ContentProviderController<T> create() {
        Context baseContext = RuntimeEnvironment.application.getBaseContext();
        ComponentName componentName = ContentProviderController.createRelative(baseContext.getPackageName(), this.contentProvider.getClass().getName());
        ProviderInfo providerInfo = null;
        try {
            providerInfo = baseContext.getPackageManager().getProviderInfo(componentName, 512);
        }
        catch (PackageManager.NameNotFoundException e) {
            String string = String.valueOf(componentName);
            Logger.strict((String)new StringBuilder(33 + String.valueOf(string).length()).append("Unable to find provider info for ").append(string).toString(), (Throwable)e);
        }
        return this.create(providerInfo);
    }

    public ContentProviderController<T> create(String authority) {
        ProviderInfo providerInfo = new ProviderInfo();
        providerInfo.authority = authority;
        return this.create(providerInfo);
    }

    public ContentProviderController<T> create(ProviderInfo providerInfo) {
        Context baseContext = RuntimeEnvironment.application.getBaseContext();
        ComponentName componentName = ContentProviderController.createRelative(baseContext.getPackageName(), this.contentProvider.getClass().getName());
        baseContext.getPackageManager().setComponentEnabledSetting(componentName, 1, 0);
        this.contentProvider.attachInfo(baseContext, providerInfo);
        if (providerInfo != null) {
            ShadowContentResolver.registerProviderInternal(providerInfo.authority, this.contentProvider);
        }
        return this;
    }

    public T get() {
        return this.contentProvider;
    }

    public ContentProviderController<T> shutdown() {
        this.contentProvider.shutdown();
        return this;
    }

    private static ComponentName createRelative(String pkg, String cls) {
        String fullName;
        if (cls.charAt(0) == '.') {
            String string = String.valueOf(pkg);
            String string2 = String.valueOf(cls);
            fullName = string2.length() != 0 ? string.concat(string2) : new String(string);
        } else {
            fullName = cls;
        }
        return new ComponentName(pkg, fullName);
    }
}

