/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.util.TypedValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.res.AttrData;
import org.robolectric.res.ResType;
import org.robolectric.res.TypedResource;
import org.robolectric.shadows.ResourceHelper;
import org.robolectric.util.Util;

public class Converter<T> {
    private static int nextStringCookie = 764581;

    static synchronized int getNextStringCookie() {
        return nextStringCookie++;
    }

    static Converter getConverterFor(AttrData attrData, String type) {
        switch (type) {
            case "enum": {
                return new EnumConverter(attrData);
            }
            case "flag": 
            case "flags": {
                return new FlagConverter(attrData);
            }
            case "boolean": {
                return new FromBoolean();
            }
            case "color": {
                return new FromColor();
            }
            case "dimension": {
                return new FromDimen();
            }
            case "float": {
                return new FromFloat();
            }
            case "integer": {
                return new FromInt();
            }
            case "string": {
                return new FromCharSequence();
            }
            case "fraction": {
                return new FromFraction();
            }
        }
        String string = String.valueOf(type);
        throw new UnsupportedOperationException(string.length() != 0 ? "Type not supported: ".concat(string) : new String("Type not supported: "));
    }

    public static Converter getConverter(ResType resType) {
        switch (resType) {
            case ATTR_DATA: {
                return new FromAttrData();
            }
            case BOOLEAN: {
                return new FromBoolean();
            }
            case CHAR_SEQUENCE: {
                return new FromCharSequence();
            }
            case COLOR: 
            case DRAWABLE: {
                return new FromColor();
            }
            case COLOR_STATE_LIST: 
            case LAYOUT: {
                return new FromFilePath();
            }
            case DIMEN: {
                return new FromDimen();
            }
            case FILE: {
                return new FromFile();
            }
            case FLOAT: {
                return new FromFloat();
            }
            case INTEGER: {
                return new FromInt();
            }
            case FRACTION: {
                return new FromFraction();
            }
            case CHAR_SEQUENCE_ARRAY: 
            case INTEGER_ARRAY: 
            case TYPED_ARRAY: {
                return new FromArray();
            }
            case STYLE: {
                return new Converter();
            }
        }
        String string = String.valueOf(resType.name());
        throw new UnsupportedOperationException(string.length() != 0 ? "can't convert from ".concat(string) : new String("can't convert from "));
    }

    public CharSequence asCharSequence(TypedResource typedResource) {
        return typedResource.asString();
    }

    public int asInt(TypedResource typedResource) {
        throw this.cantDo("asInt");
    }

    public List<TypedResource> getItems(TypedResource typedResource) {
        return new ArrayList<TypedResource>();
    }

    public boolean fillTypedValue(T data, TypedValue typedValue) {
        return false;
    }

    private UnsupportedOperationException cantDo(String operation) {
        String string = this.getClass().getName();
        return new UnsupportedOperationException(new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(operation).length()).append(string).append(" doesn't support ").append(operation).toString());
    }

    private static int convertInt(String rawValue) {
        try {
            return (int)Long.parseLong(rawValue);
        }
        catch (NumberFormatException nfe) {
            return Long.decode(rawValue).intValue();
        }
    }

    private static class EnumOrFlagConverter
    extends Converter<String> {
        private final AttrData attrData;

        public EnumOrFlagConverter(AttrData attrData) {
            this.attrData = attrData;
        }

        protected int findValueFor(String key) {
            String valueFor = this.attrData.getValueFor(key = key == null ? null : key.trim());
            if (valueFor == null) {
                if (this.attrData.isValue(key)) {
                    valueFor = key;
                } else {
                    String string = String.valueOf(key);
                    throw new Resources.NotFoundException(string.length() != 0 ? "no value found for ".concat(string) : new String("no value found for "));
                }
            }
            return Util.parseInt((String)valueFor);
        }
    }

    private static class FlagConverter
    extends EnumOrFlagConverter {
        public FlagConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            int flags = 0;
            try {
                for (String key : data.split("\\|", 0)) {
                    flags |= this.findValueFor(key);
                }
            }
            catch (Resources.NotFoundException e) {
                try {
                    flags = Integer.decode(data);
                }
                catch (NumberFormatException e1) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            typedValue.type = 17;
            typedValue.data = flags;
            typedValue.assetCookie = 0;
            typedValue.string = null;
            return true;
        }
    }

    private static class EnumConverter
    extends EnumOrFlagConverter {
        public EnumConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            try {
                typedValue.type = 17;
                try {
                    typedValue.data = this.findValueFor(data);
                }
                catch (Resources.NotFoundException e) {
                    typedValue.data = Converter.convertInt(data);
                }
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private static class FromDimen
    extends Converter<String> {
        private FromDimen() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            return ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromBoolean
    extends Converter<String> {
        private FromBoolean() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 18;
            typedValue.assetCookie = 0;
            typedValue.string = null;
            if ("true".equalsIgnoreCase(data)) {
                typedValue.data = 1;
                return true;
            }
            if ("false".equalsIgnoreCase(data)) {
                typedValue.data = 0;
                return true;
            }
            return false;
        }
    }

    private static class FromFloat
    extends Converter<String> {
        private FromFloat() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            return ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromFile
    extends Converter<Object> {
        private FromFile() {
        }

        @Override
        public boolean fillTypedValue(Object data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.string = data instanceof Path ? data.toString() : (CharSequence)data;
            typedValue.assetCookie = FromFile.getNextStringCookie();
            return true;
        }
    }

    private static class FromFraction
    extends Converter<String> {
        private FromFraction() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            return ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromInt
    extends Converter<String> {
        private FromInt() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            try {
                typedValue.type = data.startsWith("0x") ? (data.startsWith("0x") ? 17 : 16) : 16;
                typedValue.data = Converter.convertInt(data);
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return Converter.convertInt(typedResource.asString().trim());
        }
    }

    public static class FromArray
    extends Converter {
        @Override
        public List<TypedResource> getItems(TypedResource typedResource) {
            return (List)typedResource.getData();
        }
    }

    public static class FromFilePath
    extends Converter<String> {
        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.string = data;
            typedValue.assetCookie = FromFilePath.getNextStringCookie();
            return true;
        }
    }

    public static class FromColor
    extends Converter<String> {
        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            try {
                typedValue.type = ResourceHelper.getColorType(data);
                typedValue.data = ResourceHelper.getColor(data);
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return ResourceHelper.getColor(typedResource.asString().trim());
        }
    }

    public static class FromCharSequence
    extends Converter<String> {
        @Override
        public CharSequence asCharSequence(TypedResource typedResource) {
            return typedResource.asString().trim();
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return Converter.convertInt(typedResource.asString().trim());
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.assetCookie = FromCharSequence.getNextStringCookie();
            typedValue.string = data;
            return true;
        }
    }

    public static class FromAttrData
    extends Converter<AttrData> {
        @Override
        public CharSequence asCharSequence(TypedResource typedResource) {
            return typedResource.asString();
        }

        @Override
        public boolean fillTypedValue(AttrData data, TypedValue typedValue) {
            typedValue.type = 3;
            return false;
        }
    }
}

