/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Parcel;
import android.view.MotionEvent;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.res.android.Ref;
import org.robolectric.shadows.NativeBitSet64;

public class NativeInput {
    private static final int MAX_POINTERS = 16;
    private static final int MAX_SAMPLES = 65535;
    private static final int MAX_POINTER_ID = 31;

    static class MotionEvent
    extends InputEvent {
        private static final double M_PI = 3.1415927410125732;
        private static final double M_PI_2 = 1.5707963705062866;
        private int mAction;
        private int mActionButton;
        private int mFlags;
        private int mEdgeFlags;
        private int mMetaState;
        private int mButtonState;
        private float mXOffset;
        private float mYOffset;
        private float mXPrecision;
        private float mYPrecision;
        private long mDownTime;
        private List<MotionEvent.PointerProperties> mPointerProperties = new ArrayList<MotionEvent.PointerProperties>();
        private List<Long> mSampleEventTimes = new ArrayList<Long>();
        private List<PointerCoords> mSamplePointerCoords = new ArrayList<PointerCoords>();

        MotionEvent() {
        }

        @Override
        public int getType() {
            return 2;
        }

        public int getAction() {
            return this.mAction;
        }

        public int getActionMasked() {
            return this.mAction & 0xFF;
        }

        public int getActionIndex() {
            return (this.mAction & 0xFF00) >> 8;
        }

        public void setAction(int action) {
            this.mAction = action;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public void setFlags(int flags) {
            this.mFlags = flags;
        }

        public int getEdgeFlags() {
            return this.mEdgeFlags;
        }

        public void setEdgeFlags(int edgeFlags) {
            this.mEdgeFlags = edgeFlags;
        }

        public int getMetaState() {
            return this.mMetaState;
        }

        public void setMetaState(int metaState) {
            this.mMetaState = metaState;
        }

        public int getButtonState() {
            return this.mButtonState;
        }

        public void setButtonState(int buttonState) {
            this.mButtonState = buttonState;
        }

        public int getActionButton() {
            return this.mActionButton;
        }

        public void setActionButton(int button) {
            this.mActionButton = button;
        }

        public float getXOffset() {
            return this.mXOffset;
        }

        public float getYOffset() {
            return this.mYOffset;
        }

        public float getXPrecision() {
            return this.mXPrecision;
        }

        public float getYPrecision() {
            return this.mYPrecision;
        }

        public long getDownTime() {
            return this.mDownTime;
        }

        public void setDownTime(long downTime) {
            this.mDownTime = downTime;
        }

        public int getPointerCount() {
            return this.mPointerProperties.size();
        }

        public MotionEvent.PointerProperties getPointerProperties(int pointerIndex) {
            return this.mPointerProperties.get(pointerIndex);
        }

        public int getPointerId(int pointerIndex) {
            return this.mPointerProperties.get((int)pointerIndex).id;
        }

        public int getToolType(int pointerIndex) {
            return this.mPointerProperties.get((int)pointerIndex).toolType;
        }

        public long getEventTime() {
            return this.mSampleEventTimes.get(this.getHistorySize());
        }

        public PointerCoords getRawPointerCoords(int pointerIndex) {
            return this.mSamplePointerCoords.get(this.getHistorySize() * this.getPointerCount() + pointerIndex);
        }

        public float getRawAxisValue(int axis, int pointerIndex) {
            return this.getRawPointerCoords(pointerIndex).getAxisValue(axis);
        }

        public float getRawX(int pointerIndex) {
            return this.getRawAxisValue(0, pointerIndex);
        }

        public float getRawY(int pointerIndex) {
            return this.getRawAxisValue(1, pointerIndex);
        }

        public float getAxisValue(int axis, int pointerIndex) {
            float value = this.getRawPointerCoords(pointerIndex).getAxisValue(axis);
            switch (axis) {
                case 0: {
                    return value + this.mXOffset;
                }
                case 1: {
                    return value + this.mYOffset;
                }
            }
            return value;
        }

        public float getX(int pointerIndex) {
            return this.getAxisValue(0, pointerIndex);
        }

        public float getY(int pointerIndex) {
            return this.getAxisValue(1, pointerIndex);
        }

        public float getPressure(int pointerIndex) {
            return this.getAxisValue(2, pointerIndex);
        }

        public float getSize(int pointerIndex) {
            return this.getAxisValue(3, pointerIndex);
        }

        public float getTouchMajor(int pointerIndex) {
            return this.getAxisValue(4, pointerIndex);
        }

        public float getTouchMinor(int pointerIndex) {
            return this.getAxisValue(5, pointerIndex);
        }

        public float getToolMajor(int pointerIndex) {
            return this.getAxisValue(6, pointerIndex);
        }

        public float getToolMinor(int pointerIndex) {
            return this.getAxisValue(7, pointerIndex);
        }

        public float getOrientation(int pointerIndex) {
            return this.getAxisValue(8, pointerIndex);
        }

        public int getHistorySize() {
            return this.mSampleEventTimes.size() - 1;
        }

        public long getHistoricalEventTime(int historicalIndex) {
            return this.mSampleEventTimes.get(historicalIndex);
        }

        public PointerCoords getHistoricalRawPointerCoords(int pointerIndex, int historicalIndex) {
            return this.mSamplePointerCoords.get(historicalIndex * this.getPointerCount() + pointerIndex);
        }

        public float getHistoricalRawAxisValue(int axis, int pointerIndex, int historicalIndex) {
            return this.getHistoricalRawPointerCoords(pointerIndex, historicalIndex).getAxisValue(axis);
        }

        public float getHistoricalRawX(int pointerIndex, int historicalIndex) {
            return this.getHistoricalRawAxisValue(0, pointerIndex, historicalIndex);
        }

        public float getHistoricalRawY(int pointerIndex, int historicalIndex) {
            return this.getHistoricalRawAxisValue(1, pointerIndex, historicalIndex);
        }

        public float getHistoricalAxisValue(int axis, int pointerIndex, int historicalIndex) {
            float value = this.getHistoricalRawPointerCoords(pointerIndex, historicalIndex).getAxisValue(axis);
            switch (axis) {
                case 0: {
                    return value + this.mXOffset;
                }
                case 1: {
                    return value + this.mYOffset;
                }
            }
            return value;
        }

        public float getHistoricalX(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(0, pointerIndex, historicalIndex);
        }

        public float getHistoricalY(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(1, pointerIndex, historicalIndex);
        }

        public float getHistoricalPressure(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(2, pointerIndex, historicalIndex);
        }

        public float getHistoricalSize(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(3, pointerIndex, historicalIndex);
        }

        public float getHistoricalTouchMajor(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(4, pointerIndex, historicalIndex);
        }

        public float getHistoricalTouchMinor(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(5, pointerIndex, historicalIndex);
        }

        public float getHistoricalToolMajor(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(6, pointerIndex, historicalIndex);
        }

        public float getHistoricalToolMinor(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(7, pointerIndex, historicalIndex);
        }

        public float getHistoricalOrientation(int pointerIndex, int historicalIndex) {
            return this.getHistoricalAxisValue(8, pointerIndex, historicalIndex);
        }

        public int findPointerIndex(int pointerId) {
            int pointerCount = this.mPointerProperties.size();
            for (int i = 0; i < pointerCount; ++i) {
                if (this.mPointerProperties.get((int)i).id != pointerId) continue;
                return i;
            }
            return -1;
        }

        public void initialize(int deviceId, int source, int action, int actionButton, int flags, int edgeFlags, int metaState, int buttonState, float xOffset, float yOffset, float xPrecision, float yPrecision, long downTime, long eventTime, int pointerCount, MotionEvent.PointerProperties[] pointerProperties, PointerCoords[] pointerCoords) {
            super.initialize(deviceId, source);
            this.mAction = action;
            this.mActionButton = actionButton;
            this.mFlags = flags;
            this.mEdgeFlags = edgeFlags;
            this.mMetaState = metaState;
            this.mButtonState = buttonState;
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            this.mXPrecision = xPrecision;
            this.mYPrecision = yPrecision;
            this.mDownTime = downTime;
            this.mPointerProperties.clear();
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.PointerProperties copy = new MotionEvent.PointerProperties(pointerProperties[i]);
                this.mPointerProperties.add(copy);
            }
            this.mSampleEventTimes.clear();
            this.mSamplePointerCoords.clear();
            this.addSample(eventTime, Arrays.asList(pointerCoords).subList(0, pointerCount));
        }

        public void copyFrom(MotionEvent other, boolean keepHistory) {
            super.initialize(other.getDeviceId(), other.getSource());
            this.mAction = other.mAction;
            this.mActionButton = other.mActionButton;
            this.mFlags = other.mFlags;
            this.mEdgeFlags = other.mEdgeFlags;
            this.mMetaState = other.mMetaState;
            this.mButtonState = other.mButtonState;
            this.mXOffset = other.mXOffset;
            this.mYOffset = other.mYOffset;
            this.mXPrecision = other.mXPrecision;
            this.mYPrecision = other.mYPrecision;
            this.mDownTime = other.mDownTime;
            this.mPointerProperties = other.mPointerProperties;
            this.mSampleEventTimes.clear();
            this.mSamplePointerCoords.clear();
            if (keepHistory) {
                this.mSampleEventTimes.addAll(other.mSampleEventTimes);
                this.mSamplePointerCoords.addAll(other.mSamplePointerCoords);
            } else {
                this.mSampleEventTimes.add(other.getEventTime());
                int pointerCount = other.getPointerCount();
                int historySize = other.getHistorySize();
                int currentStartIndex = historySize * pointerCount;
                this.mSamplePointerCoords.addAll(other.mSamplePointerCoords.subList(currentStartIndex, currentStartIndex + pointerCount));
            }
        }

        public void addSample(long eventTime, PointerCoords[] pointerCoords) {
            this.addSample(eventTime, Arrays.asList(pointerCoords));
        }

        public void addSample(long eventTime, List<PointerCoords> pointerCoords) {
            this.mSampleEventTimes.add(eventTime);
            this.mSamplePointerCoords.addAll(pointerCoords);
        }

        public void offsetLocation(float xOffset, float yOffset) {
            this.mXOffset += xOffset;
            this.mYOffset += yOffset;
        }

        public void scale(float scaleFactor) {
            this.mXOffset *= scaleFactor;
            this.mYOffset *= scaleFactor;
            this.mXPrecision *= scaleFactor;
            this.mYPrecision *= scaleFactor;
            int numSamples = this.mSamplePointerCoords.size();
            for (int i = 0; i < numSamples; ++i) {
                this.mSamplePointerCoords.get(i).scale(scaleFactor);
            }
        }

        public void transform(float[] matrix) {
            Preconditions.checkState((matrix.length == 9 ? 1 : 0) != 0);
            float oldXOffset = this.mXOffset;
            float oldYOffset = this.mYOffset;
            Ref newX = new Ref((Object)Float.valueOf(0.0f));
            Ref newY = new Ref((Object)Float.valueOf(0.0f));
            float rawX = this.getRawX(0);
            float rawY = this.getRawY(0);
            MotionEvent.transformPoint(matrix, rawX + oldXOffset, rawY + oldYOffset, (Ref<Float>)newX, (Ref<Float>)newY);
            this.mXOffset = ((Float)newX.get()).floatValue() - rawX;
            this.mYOffset = ((Float)newY.get()).floatValue() - rawY;
            Ref originX = new Ref((Object)Float.valueOf(0.0f));
            Ref originY = new Ref((Object)Float.valueOf(0.0f));
            MotionEvent.transformPoint(matrix, 0.0f, 0.0f, (Ref<Float>)originX, (Ref<Float>)originY);
            int numSamples = this.mSamplePointerCoords.size();
            for (int i = 0; i < numSamples; ++i) {
                PointerCoords c = this.mSamplePointerCoords.get(i);
                Ref x = new Ref((Object)Float.valueOf(c.getAxisValue(0) + oldXOffset));
                Ref y = new Ref((Object)Float.valueOf(c.getAxisValue(1) + oldYOffset));
                MotionEvent.transformPoint(matrix, ((Float)x.get()).floatValue(), ((Float)y.get()).floatValue(), (Ref<Float>)x, (Ref<Float>)y);
                c.setAxisValue(0, ((Float)x.get()).floatValue() - this.mXOffset);
                c.setAxisValue(1, ((Float)y.get()).floatValue() - this.mYOffset);
                float orientation = c.getAxisValue(8);
                c.setAxisValue(8, MotionEvent.transformAngle(matrix, orientation, ((Float)originX.get()).floatValue(), ((Float)originY.get()).floatValue()));
            }
        }

        private static void transformPoint(float[] matrix, float x, float y, Ref<Float> outX, Ref<Float> outY) {
            Preconditions.checkState((matrix.length == 9 ? 1 : 0) != 0);
            float newX = matrix[0] * x + matrix[1] * y + matrix[2];
            float newY = matrix[3] * x + matrix[4] * y + matrix[5];
            float newZ = matrix[6] * x + matrix[7] * y + matrix[8];
            if (newZ != 0.0f) {
                newZ = 1.0f / newZ;
            }
            outX.set((Object)Float.valueOf(newX * newZ));
            outY.set((Object)Float.valueOf(newY * newZ));
        }

        static float transformAngle(float[] matrix, float angleRadians, float originX, float originY) {
            Preconditions.checkState((matrix.length == 9 ? 1 : 0) != 0);
            Ref x = new Ref((Object)Float.valueOf((float)Math.sin(angleRadians)));
            Ref y = new Ref((Object)Float.valueOf(-((float)Math.cos(angleRadians))));
            MotionEvent.transformPoint(matrix, ((Float)x.get()).floatValue(), ((Float)y.get()).floatValue(), (Ref<Float>)x, (Ref<Float>)y);
            x.set((Object)Float.valueOf(((Float)x.get()).floatValue() - originX));
            y.set((Object)Float.valueOf(((Float)y.get()).floatValue() - originY));
            double result = Math.atan2(((Float)x.get()).floatValue(), -((Float)y.get()).floatValue());
            if (result < -1.5707963705062866) {
                result += 3.1415927410125732;
            } else if (result > 1.5707963705062866) {
                result -= 3.1415927410125732;
            }
            return (float)result;
        }

        public boolean readFromParcel(Parcel parcel) {
            int i;
            int pointerCount = parcel.readInt();
            int sampleCount = parcel.readInt();
            if (pointerCount == 0 || pointerCount > 16 || sampleCount == 0 || sampleCount > 65535) {
                return false;
            }
            this.mDeviceId = parcel.readInt();
            this.mSource = parcel.readInt();
            this.mAction = parcel.readInt();
            this.mActionButton = parcel.readInt();
            this.mFlags = parcel.readInt();
            this.mEdgeFlags = parcel.readInt();
            this.mMetaState = parcel.readInt();
            this.mButtonState = parcel.readInt();
            this.mXOffset = parcel.readFloat();
            this.mYOffset = parcel.readFloat();
            this.mXPrecision = parcel.readFloat();
            this.mYPrecision = parcel.readFloat();
            this.mDownTime = parcel.readLong();
            this.mPointerProperties = new ArrayList<MotionEvent.PointerProperties>(pointerCount);
            this.mSampleEventTimes = new ArrayList<Long>(sampleCount);
            this.mSamplePointerCoords = new ArrayList<PointerCoords>(sampleCount * pointerCount);
            for (i = 0; i < pointerCount; ++i) {
                MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
                this.mPointerProperties.add(properties);
                properties.id = parcel.readInt();
                properties.toolType = parcel.readInt();
            }
            while (sampleCount > 0) {
                --sampleCount;
                this.mSampleEventTimes.add(parcel.readLong());
                for (i = 0; i < pointerCount; ++i) {
                    PointerCoords pointerCoords = new PointerCoords();
                    this.mSamplePointerCoords.add(pointerCoords);
                    if (pointerCoords.readFromParcel(parcel)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean writeToParcel(Parcel parcel) {
            int pointerCount = this.mPointerProperties.size();
            int sampleCount = this.mSampleEventTimes.size();
            parcel.writeInt(pointerCount);
            parcel.writeInt(sampleCount);
            parcel.writeInt(this.mDeviceId);
            parcel.writeInt(this.mSource);
            parcel.writeInt(this.mAction);
            parcel.writeInt(this.mActionButton);
            parcel.writeInt(this.mFlags);
            parcel.writeInt(this.mEdgeFlags);
            parcel.writeInt(this.mMetaState);
            parcel.writeInt(this.mButtonState);
            parcel.writeFloat(this.mXOffset);
            parcel.writeFloat(this.mYOffset);
            parcel.writeFloat(this.mXPrecision);
            parcel.writeFloat(this.mYPrecision);
            parcel.writeLong(this.mDownTime);
            for (int i = 0; i < pointerCount; ++i) {
                MotionEvent.PointerProperties properties = this.mPointerProperties.get(i);
                parcel.writeInt(properties.id);
                parcel.writeInt(properties.toolType);
            }
            for (int h = 0; h < sampleCount; ++h) {
                parcel.writeLong(this.mSampleEventTimes.get(h).longValue());
                for (int i = 0; i < pointerCount; ++i) {
                    if (this.mSamplePointerCoords.get(i).writeToParcel(parcel)) continue;
                    return false;
                }
            }
            return true;
        }

        public static boolean isTouchEvent(int source, int action) {
            if ((source & 2) != 0) {
                switch (action & 0xFF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isTouchEvent() {
            return MotionEvent.isTouchEvent(this.getSource(), this.mAction);
        }

        public List<MotionEvent.PointerProperties> getPointerProperties() {
            return this.mPointerProperties;
        }

        List<Long> getSampleEventTimes() {
            return this.mSampleEventTimes;
        }

        List<PointerCoords> getSamplePointerCoords() {
            return this.mSamplePointerCoords;
        }
    }

    static class KeyEvent
    extends InputEvent {
        KeyEvent() {
        }
    }

    static class InputEvent
    extends AInputEvent {
        protected int mDeviceId;
        protected int mSource;

        InputEvent() {
        }

        public int getType() {
            return 0;
        }

        public int getDeviceId() {
            return this.mDeviceId;
        }

        public int getSource() {
            return this.mSource;
        }

        public void setSource(int source) {
            this.mSource = source;
        }

        protected void initialize(int deviceId, int source) {
            this.mDeviceId = deviceId;
            this.mSource = source;
        }

        protected void initialize(InputEvent from) {
            this.initialize(from.getDeviceId(), from.getSource());
        }
    }

    static class PointerCoords {
        private static final int MAX_AXES = 30;
        private NativeBitSet64 bits = new NativeBitSet64();
        private float[] values = new float[30];

        PointerCoords() {
        }

        NativeBitSet64 getBits() {
            return this.bits;
        }

        public void clear() {
            this.bits.clear();
        }

        public boolean isEmpty() {
            return this.bits.isEmpty();
        }

        public float getAxisValue(int axis) {
            if (axis < 0 || axis > 63 || !this.bits.hasBit(axis)) {
                return 0.0f;
            }
            return this.values[this.bits.getIndexOfBit(axis)];
        }

        public boolean setAxisValue(int axis, float value) {
            Preconditions.checkState((axis >= 0 && axis <= 63 ? 1 : 0) != 0, (Object)"axis out of range");
            int index = this.bits.getIndexOfBit(axis);
            if (!this.bits.hasBit(axis)) {
                if (value == 0.0f) {
                    return true;
                }
                int count = this.bits.count();
                if (count >= 30) {
                    PointerCoords.tooManyAxes(axis);
                    return false;
                }
                this.bits.markBit(axis);
                for (int i = count; i > index; --i) {
                    this.values[i] = this.values[i - 1];
                }
            }
            this.values[index] = value;
            return true;
        }

        static void scaleAxisValue(PointerCoords c, int axis, float scaleFactor) {
            float value = c.getAxisValue(axis);
            if (value != 0.0f) {
                c.setAxisValue(axis, value * scaleFactor);
            }
        }

        public void scale(float scaleFactor) {
            PointerCoords.scaleAxisValue(this, 0, scaleFactor);
            PointerCoords.scaleAxisValue(this, 1, scaleFactor);
            PointerCoords.scaleAxisValue(this, 4, scaleFactor);
            PointerCoords.scaleAxisValue(this, 5, scaleFactor);
            PointerCoords.scaleAxisValue(this, 6, scaleFactor);
            PointerCoords.scaleAxisValue(this, 7, scaleFactor);
        }

        public void applyOffset(float xOffset, float yOffset) {
            this.setAxisValue(0, this.getX() + xOffset);
            this.setAxisValue(1, this.getY() + yOffset);
        }

        public float getX() {
            return this.getAxisValue(0);
        }

        public float getY() {
            return this.getAxisValue(1);
        }

        public boolean readFromParcel(Parcel parcel) {
            this.bits.setValue(parcel.readLong());
            int count = this.bits.count();
            if (count > 30) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                this.values[i] = parcel.readFloat();
            }
            return true;
        }

        public boolean writeToParcel(Parcel parcel) {
            parcel.writeLong(this.bits.getValue());
            int count = this.bits.count();
            for (int i = 0; i < count; ++i) {
                parcel.writeFloat(this.values[i]);
            }
            return true;
        }

        public void copyFrom(PointerCoords other) {
            this.bits = new NativeBitSet64(other.bits);
            int count = this.bits.count();
            for (int i = 0; i < count; ++i) {
                this.values[i] = other.values[i];
            }
        }

        private static void tooManyAxes(int axis) {
            throw new IllegalStateException(String.format("Could not set value for axis %d because the PointerCoords structure is full and cannot contain more than %d axis values.", axis, 30));
        }
    }

    static class AInputEvent {
        AInputEvent() {
        }
    }
}

