/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Objects;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.CppApkAssets;
import org.robolectric.res.android.Registries;
import org.robolectric.res.android.ResXMLTree;
import org.robolectric.res.android.Util;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApkAssets;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ApkAssets.class, minSdk=28, shadowPicker=ShadowApkAssets.Picker.class, isInAndroidSdk=false)
public class ShadowArscApkAssets9
extends ShadowApkAssets {
    protected static final String FRAMEWORK_APK_PATH = (String)ReflectionHelpers.getStaticField(AssetManager.class, (String)"FRAMEWORK_APK_PATH");
    private static final HashMap<Key, WeakReference<ApkAssets>> cachedApkAssets = new HashMap();
    private static final HashMap<Key, Long> cachedNativePtrs = new HashMap();
    @RealObject
    private ApkAssets realApkAssets;

    long getNativePtr() {
        return ((_ApkAssets_)Reflector.reflector(_ApkAssets_.class, (Object)this.realApkAssets)).getNativePtr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ApkAssets getFromCacheOrLoad(Key key, ApkAssetMaker callable) {
        HashMap<Key, WeakReference<ApkAssets>> hashMap = cachedApkAssets;
        synchronized (hashMap) {
            long nativePtr;
            ApkAssets apkAssets;
            WeakReference<ApkAssets> cachedRef = cachedApkAssets.get(key);
            if (cachedRef != null) {
                apkAssets = (ApkAssets)cachedRef.get();
                if (apkAssets != null) {
                    return apkAssets;
                }
                cachedApkAssets.remove(key);
                nativePtr = cachedNativePtrs.remove(key);
                Registries.NATIVE_APK_ASSETS_REGISTRY.unregister(nativePtr);
            }
            apkAssets = callable.call();
            cachedApkAssets.put(key, new WeakReference<ApkAssets>(apkAssets));
            nativePtr = ((ShadowArscApkAssets9)Shadow.extract((Object)apkAssets)).getNativePtr();
            cachedNativePtrs.put(key, nativePtr);
            return apkAssets;
        }
    }

    @Implementation
    protected static ApkAssets loadFromPath(String path) throws IOException {
        return ShadowArscApkAssets9.getFromCacheOrLoad(new Key(null, path, false, false, false), () -> (ApkAssets)Shadow.directlyOn(ApkAssets.class, (String)"loadFromPath", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)path)}));
    }

    @Implementation
    protected static ApkAssets loadFromPath(String path, boolean system) throws IOException {
        String string = path;
        String string2 = RuntimeEnvironment.useLegacyResources() ? "legacy" : "binary";
        int n = RuntimeEnvironment.getApiLevel();
        System.out.println(new StringBuilder(51 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Called loadFromPath(").append(string).append(", ").append(system).append("); mode=").append(string2).append(" sdk=").append(n).toString());
        if (FRAMEWORK_APK_PATH.equals(path)) {
            path = RuntimeEnvironment.getAndroidFrameworkJarPath().toString();
        }
        String finalPath = path;
        return ShadowArscApkAssets9.getFromCacheOrLoad(new Key(null, path, system, false, false), () -> (ApkAssets)Shadow.directlyOn(ApkAssets.class, (String)"loadFromPath", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)finalPath), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)system)}));
    }

    @Implementation
    protected static ApkAssets loadFromPath(String path, boolean system, boolean forceSharedLibrary) throws IOException {
        return ShadowArscApkAssets9.getFromCacheOrLoad(new Key(null, path, system, forceSharedLibrary, false), () -> (ApkAssets)Shadow.directlyOn(ApkAssets.class, (String)"loadFromPath", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)path), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)system), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)forceSharedLibrary)}));
    }

    @Implementation
    protected static ApkAssets loadFromFd(FileDescriptor fd, String friendlyName, boolean system, boolean forceSharedLibrary) throws IOException {
        return ShadowArscApkAssets9.getFromCacheOrLoad(new Key(fd, friendlyName, system, forceSharedLibrary, false), () -> (ApkAssets)Shadow.directlyOn(ApkAssets.class, (String)"loadFromPath", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(FileDescriptor.class, (Object)fd), ReflectionHelpers.ClassParameter.from(String.class, (Object)friendlyName), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)system), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)forceSharedLibrary)}));
    }

    @Implementation
    protected static ApkAssets loadOverlayFromPath(String idmapPath, boolean system) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Implementation
    protected static long nativeLoad(String java_path, boolean system, boolean force_shared_lib, boolean overlay) throws IOException {
        CppApkAssets apk_assets;
        String path = java_path;
        if (path == null) {
            return 0L;
        }
        Util.ATRACE_NAME((String)String.format("LoadApkAssets(%s)", path));
        try {
            apk_assets = overlay ? CppApkAssets.LoadOverlay((String)path, (boolean)system) : (force_shared_lib ? CppApkAssets.LoadAsSharedLibrary((String)path, (boolean)system) : CppApkAssets.Load((String)path, (boolean)system));
        }
        catch (OutOfMemoryError e) {
            String string = String.valueOf(path);
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError(string.length() != 0 ? "Failed to load ".concat(string) : new String("Failed to load "));
            outOfMemoryError.initCause(e);
            throw outOfMemoryError;
        }
        if (apk_assets == null) {
            String error_msg = String.format("Failed to load asset path %s", path);
            throw new IOException(error_msg);
        }
        return Registries.NATIVE_APK_ASSETS_REGISTRY.register((Object)apk_assets);
    }

    @Implementation
    protected static long nativeLoadFromFd(FileDescriptor file_descriptor, String friendly_name, boolean system, boolean force_shared_lib) {
        String friendly_name_utf8 = friendly_name;
        if (friendly_name_utf8 == null) {
            return 0L;
        }
        throw new UnsupportedOperationException();
    }

    @Implementation
    protected static String nativeGetAssetPath(long ptr) {
        CppApkAssets apk_assets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(ptr);
        return apk_assets.GetPath();
    }

    @Implementation
    protected static long nativeGetStringBlock(long ptr) {
        CppApkAssets apk_assets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(ptr);
        return apk_assets.GetLoadedArsc().GetStringPool().getNativePtr();
    }

    @Implementation
    protected static boolean nativeIsUpToDate(long ptr) {
        CppApkAssets apk_assets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(ptr);
        return true;
    }

    @Implementation
    protected static long nativeOpenXml(long ptr, String file_name) throws FileNotFoundException {
        String path_utf8 = file_name;
        if (path_utf8 == null) {
            return 0L;
        }
        CppApkAssets apk_assets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(ptr);
        Asset asset = apk_assets.Open(path_utf8, Asset.AccessMode.ACCESS_RANDOM);
        if (asset == null) {
            throw new FileNotFoundException(path_utf8);
        }
        ResXMLTree xml_tree = new ResXMLTree(null);
        int err = xml_tree.setTo(asset.getBuffer(true), (int)asset.getLength(), true);
        if (err != 0) {
            throw new FileNotFoundException("Corrupt XML binary file");
        }
        return Registries.NATIVE_RES_XML_TREES.register((Object)xml_tree);
    }

    @FunctionalInterface
    protected static interface ApkAssetMaker {
        public ApkAssets call();
    }

    protected static class Key {
        private final FileDescriptor fd;
        private final String path;
        private final boolean system;
        private final boolean load_as_shared_library;
        private final boolean overlay;

        public Key(FileDescriptor fd, String path, boolean system, boolean load_as_shared_library, boolean overlay) {
            this.fd = fd;
            this.path = path;
            this.system = system;
            this.load_as_shared_library = load_as_shared_library;
            this.overlay = overlay;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.system == key.system && this.load_as_shared_library == key.load_as_shared_library && this.overlay == key.overlay && Objects.equals(this.fd, key.fd) && Objects.equals(this.path, key.path);
        }

        public int hashCode() {
            return Objects.hash(this.fd, this.path, this.system, this.load_as_shared_library, this.overlay);
        }
    }

    @ForType(value=ApkAssets.class)
    static interface _ApkAssets_ {
        @Accessor(value="mNativePtr")
        public long getNativePtr();
    }
}

