/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.EventLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowProcess;

@Implements(value=EventLog.class)
public class ShadowEventLog {
    static final String NULL_PLACE_HOLDER = "NULL";
    private static final List<EventLog.Event> events = new ArrayList<EventLog.Event>();

    public static void addEvent(EventLog.Event event) {
        events.add(event);
    }

    @Resetter
    public static void clearAll() {
        events.clear();
    }

    @Implementation
    protected static int writeEvent(int tag, String str) {
        if (str == null) {
            str = NULL_PLACE_HOLDER;
        }
        ShadowEventLog.addEvent(new EventBuilder(tag, str).build());
        return 4 + str.length();
    }

    @Implementation
    protected static int writeEvent(int tag, Object ... list) {
        if (list == null) {
            return ShadowEventLog.writeEvent(tag, null);
        }
        ShadowEventLog.addEvent(new EventBuilder(tag, list).build());
        return 4 + list.length * 4;
    }

    @Implementation
    protected static int writeEvent(int tag, int value) {
        ShadowEventLog.addEvent(new EventBuilder(tag, value).build());
        return 8;
    }

    @Implementation(minSdk=23)
    protected static int writeEvent(int tag, float value) {
        ShadowEventLog.addEvent(new EventBuilder(tag, Float.valueOf(value)).build());
        return 8;
    }

    @Implementation
    protected static int writeEvent(int tag, long value) {
        ShadowEventLog.addEvent(new EventBuilder(tag, value).build());
        return 12;
    }

    @Implementation
    protected static void readEvents(int[] tags, Collection<EventLog.Event> output) {
        block0: for (EventLog.Event event : events) {
            for (int tag : tags) {
                if (tag != event.getTag()) continue;
                output.add(event);
                continue block0;
            }
        }
    }

    public static class EventBuilder {
        private final Object data;
        private final int tag;
        private int processId = ShadowProcess.myPid();
        private int threadId = ShadowProcess.myTid();
        private long timeNanos = System.nanoTime();

        public EventBuilder(int tag, Object data) {
            this.tag = tag;
            this.data = data;
        }

        public EventBuilder setProcessId(int processId) {
            this.processId = processId;
            return this;
        }

        public EventBuilder setThreadId(int threadId) {
            this.threadId = threadId;
            return this;
        }

        public EventBuilder setTimeNanos(long timeNanos) {
            this.timeNanos = timeNanos;
            return this;
        }

        public EventLog.Event build() {
            EventLog.Event event = (EventLog.Event)Shadow.newInstanceOf(EventLog.Event.class);
            ShadowEvent shadowEvent = (ShadowEvent)Shadow.extract((Object)event);
            shadowEvent.data = this.data;
            shadowEvent.tag = this.tag;
            shadowEvent.processId = this.processId;
            shadowEvent.threadId = this.threadId;
            shadowEvent.timeNanos = this.timeNanos;
            return event;
        }
    }

    @Implements(value=EventLog.Event.class)
    public static class ShadowEvent {
        private Object data;
        private int tag;
        private int processId;
        private int threadId;
        private long timeNanos;

        @Implementation
        protected Object getData() {
            return this.data;
        }

        @Implementation
        protected int getTag() {
            return this.tag;
        }

        @Implementation
        protected int getProcessId() {
            return this.processId;
        }

        @Implementation
        protected int getThreadId() {
            return this.threadId;
        }

        @Implementation
        protected long getTimeNanos() {
            return this.timeNanos;
        }
    }
}

