/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=MediaSessionManager.class, minSdk=21)
public class ShadowMediaSessionManager {
    private final List<MediaController> controllers = new CopyOnWriteArrayList<MediaController>();
    private final Set<MediaSessionManager.OnActiveSessionsChangedListener> listeners = new CopyOnWriteArraySet<MediaSessionManager.OnActiveSessionsChangedListener>();

    @Implementation
    protected List<MediaController> getActiveSessions(ComponentName ignoredNotificationListener) {
        return ImmutableList.copyOf(this.controllers);
    }

    @Implementation
    protected void addOnActiveSessionsChangedListener(MediaSessionManager.OnActiveSessionsChangedListener listener, ComponentName ignoredNotificationListener) {
        this.listeners.add(listener);
    }

    @Implementation
    protected void removeOnActiveSessionsChangedListener(MediaSessionManager.OnActiveSessionsChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void addController(MediaController controller) {
        this.controllers.add(controller);
        for (MediaSessionManager.OnActiveSessionsChangedListener listener : this.listeners) {
            listener.onActiveSessionsChanged(this.controllers);
        }
    }

    public void clearControllers() {
        this.controllers.clear();
    }
}

