/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Matrix;
import android.os.Parcel;
import android.view.MotionEvent;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.NativeBitSet64;
import org.robolectric.shadows.NativeInput;
import org.robolectric.shadows.ShadowMatrix;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MotionEvent.class)
public class ShadowMotionEvent {
    private static NativeObjRegistry<NativeInput.MotionEvent> nativeMotionEventRegistry = new NativeObjRegistry(NativeInput.MotionEvent.class);
    private static final int HISTORY_CURRENT = Integer.MIN_VALUE;
    @RealObject
    private MotionEvent realMotionEvent;

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gRecyclerTop", null);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gSharedTempPointerCoords", null);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gSharedTempPointerProperties", null);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gRecyclerUsed", (Object)0);
        ReflectionHelpers.setStaticField(MotionEvent.class, (String)"gSharedTempPointerIndexMap", null);
    }

    private static void validatePointerCount(int pointerCount) {
        Preconditions.checkState((pointerCount >= 1 ? 1 : 0) != 0, (Object)"pointerCount must be at least 1");
    }

    private static void validatePointerPropertiesArray(MotionEvent.PointerProperties[] pointerPropertiesObjArray, int pointerCount) {
        Preconditions.checkNotNull((Object)pointerPropertiesObjArray, (Object)"pointerProperties array must not be null");
        Preconditions.checkState((pointerPropertiesObjArray.length >= pointerCount ? 1 : 0) != 0, (Object)"pointerProperties array must be large enough to hold all pointers");
    }

    private static void validatePointerCoordsObjArray(MotionEvent.PointerCoords[] pointerCoordsObjArray, int pointerCount) {
        Preconditions.checkNotNull((Object)pointerCoordsObjArray, (Object)"pointerCoords array must not be null");
        Preconditions.checkState((pointerCoordsObjArray.length >= pointerCount ? 1 : 0) != 0, (Object)"pointerCoords array must be large enough to hold all pointers");
    }

    private static void validatePointerIndex(int pointerIndex, int pointerCount) {
        Preconditions.checkState((pointerIndex >= 0 && pointerIndex < pointerCount ? 1 : 0) != 0, (Object)"pointerIndex out of range");
    }

    private static void validateHistoryPos(int historyPos, int historySize) {
        Preconditions.checkState((historyPos >= 0 && historyPos < historySize ? 1 : 0) != 0, (Object)"historyPos out of range");
    }

    private static void validatePointerCoords(MotionEvent.PointerCoords pointerCoordsObj) {
        Preconditions.checkNotNull((Object)pointerCoordsObj, (Object)"pointerCoords must not be null");
    }

    private static void validatePointerProperties(MotionEvent.PointerProperties pointerPropertiesObj) {
        Preconditions.checkNotNull((Object)pointerPropertiesObj, (Object)"pointerProperties must not be null");
    }

    private static NativeInput.PointerCoords pointerCoordsToNative(MotionEvent.PointerCoords pointerCoordsObj, float xOffset, float yOffset) {
        float[] valuesArray;
        NativeInput.PointerCoords outRawPointerCoords = new NativeInput.PointerCoords();
        outRawPointerCoords.clear();
        outRawPointerCoords.setAxisValue(0, pointerCoordsObj.x - xOffset);
        outRawPointerCoords.setAxisValue(1, pointerCoordsObj.y - yOffset);
        outRawPointerCoords.setAxisValue(2, pointerCoordsObj.pressure);
        outRawPointerCoords.setAxisValue(3, pointerCoordsObj.size);
        outRawPointerCoords.setAxisValue(4, pointerCoordsObj.touchMajor);
        outRawPointerCoords.setAxisValue(5, pointerCoordsObj.touchMinor);
        outRawPointerCoords.setAxisValue(6, pointerCoordsObj.toolMajor);
        outRawPointerCoords.setAxisValue(7, pointerCoordsObj.toolMinor);
        outRawPointerCoords.setAxisValue(8, pointerCoordsObj.orientation);
        long packedAxisBits = (Long)ReflectionHelpers.getField((Object)pointerCoordsObj, (String)"mPackedAxisBits");
        NativeBitSet64 bits = new NativeBitSet64(packedAxisBits);
        if (!bits.isEmpty() && (valuesArray = (float[])ReflectionHelpers.getField((Object)pointerCoordsObj, (String)"mPackedAxisValues")) != null) {
            int index = 0;
            do {
                int axis = bits.clearFirstMarkedBit();
                outRawPointerCoords.setAxisValue(axis, valuesArray[index++]);
            } while (!bits.isEmpty());
        }
        return outRawPointerCoords;
    }

    private static float[] obtainPackedAxisValuesArray(int minSize, MotionEvent.PointerCoords outPointerCoordsObj) {
        int size;
        float[] outValuesArray = (float[])ReflectionHelpers.getField((Object)outPointerCoordsObj, (String)"mPackedAxisValues");
        if (outValuesArray != null && minSize <= (size = outValuesArray.length)) {
            return outValuesArray;
        }
        for (size = 8; size < minSize; size *= 2) {
        }
        outValuesArray = new float[size];
        ReflectionHelpers.setField((Object)outPointerCoordsObj, (String)"mPackedAxisValues", (Object)outValuesArray);
        return outValuesArray;
    }

    private static void pointerCoordsFromNative(NativeInput.PointerCoords rawPointerCoords, float xOffset, float yOffset, MotionEvent.PointerCoords outPointerCoordsObj) {
        outPointerCoordsObj.x = rawPointerCoords.getAxisValue(0) + xOffset;
        outPointerCoordsObj.y = rawPointerCoords.getAxisValue(1) + yOffset;
        outPointerCoordsObj.pressure = rawPointerCoords.getAxisValue(2);
        outPointerCoordsObj.size = rawPointerCoords.getAxisValue(3);
        outPointerCoordsObj.touchMajor = rawPointerCoords.getAxisValue(4);
        outPointerCoordsObj.touchMinor = rawPointerCoords.getAxisValue(5);
        outPointerCoordsObj.toolMajor = rawPointerCoords.getAxisValue(6);
        outPointerCoordsObj.toolMinor = rawPointerCoords.getAxisValue(7);
        outPointerCoordsObj.orientation = rawPointerCoords.getAxisValue(8);
        long outBits = 0L;
        NativeBitSet64 bits = new NativeBitSet64(rawPointerCoords.getBits());
        bits.clearBit(0);
        bits.clearBit(1);
        bits.clearBit(2);
        bits.clearBit(3);
        bits.clearBit(4);
        bits.clearBit(5);
        bits.clearBit(6);
        bits.clearBit(7);
        bits.clearBit(8);
        if (!bits.isEmpty()) {
            float[] outValuesArray;
            int packedAxesCount = bits.count();
            float[] outValues = outValuesArray = ShadowMotionEvent.obtainPackedAxisValuesArray(packedAxesCount, outPointerCoordsObj);
            int index = 0;
            do {
                int axis = bits.clearFirstMarkedBit();
                outBits |= NativeBitSet64.valueForBit(axis);
                outValues[index++] = rawPointerCoords.getAxisValue(axis);
            } while (!bits.isEmpty());
        }
        ReflectionHelpers.setField((Object)outPointerCoordsObj, (String)"mPackedAxisBits", (Object)outBits);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeInitialize(int nativePtr, int deviceId, int source, int action, int flags, int edgeFlags, int metaState, int buttonState, float xOffset, float yOffset, float xPrecision, float yPrecision, long downTimeNanos, long eventTimeNanos, int pointerCount, MotionEvent.PointerProperties[] pointerIds, MotionEvent.PointerCoords[] pointerCoords) {
        return (int)ShadowMotionEvent.nativeInitialize((long)nativePtr, deviceId, source, action, flags, edgeFlags, metaState, buttonState, xOffset, yOffset, xPrecision, yPrecision, downTimeNanos, eventTimeNanos, pointerCount, pointerIds, pointerCoords);
    }

    @Implementation(minSdk=21, maxSdk=28)
    @HiddenApi
    protected static long nativeInitialize(long nativePtr, int deviceId, int source, int action, int flags, int edgeFlags, int metaState, int buttonState, float xOffset, float yOffset, float xPrecision, float yPrecision, long downTimeNanos, long eventTimeNanos, int pointerCount, MotionEvent.PointerProperties[] pointerPropertiesObjArray, MotionEvent.PointerCoords[] pointerCoordsObjArray) {
        NativeInput.MotionEvent event;
        ShadowMotionEvent.validatePointerCount(pointerCount);
        ShadowMotionEvent.validatePointerPropertiesArray(pointerPropertiesObjArray, pointerCount);
        ShadowMotionEvent.validatePointerCoordsObjArray(pointerCoordsObjArray, pointerCount);
        if (nativePtr > 0L) {
            event = (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
        } else {
            event = new NativeInput.MotionEvent();
            nativePtr = nativeMotionEventRegistry.register((Object)event);
        }
        NativeInput.PointerCoords[] rawPointerCoords = new NativeInput.PointerCoords[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            MotionEvent.PointerCoords pointerCoordsObj = pointerCoordsObjArray[i];
            Preconditions.checkNotNull((Object)pointerCoordsObj);
            rawPointerCoords[i] = ShadowMotionEvent.pointerCoordsToNative(pointerCoordsObj, xOffset, yOffset);
        }
        event.initialize(deviceId, source, action, 0, flags, edgeFlags, metaState, buttonState, xOffset, yOffset, xPrecision, yPrecision, downTimeNanos, eventTimeNanos, pointerCount, pointerPropertiesObjArray, rawPointerCoords);
        return nativePtr;
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected static long nativeInitialize(long nativePtr, int deviceId, int source, int displayId, int action, int flags, int edgeFlags, int metaState, int buttonState, int classification, float xOffset, float yOffset, float xPrecision, float yPrecision, long downTimeNanos, long eventTimeNanos, int pointerCount, MotionEvent.PointerProperties[] pointerIds, MotionEvent.PointerCoords[] pointerCoords) {
        return ShadowMotionEvent.nativeInitialize(nativePtr, deviceId, source, action, flags, edgeFlags, metaState, buttonState, xOffset, yOffset, xPrecision, yPrecision, downTimeNanos, eventTimeNanos, pointerCount, pointerIds, pointerCoords);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeDispose(int nativePtr) {
        ShadowMotionEvent.nativeDispose((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeDispose(long nativePtr) {
        nativeMotionEventRegistry.unregister(nativePtr);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeAddBatch(int nativePtr, long eventTimeNanos, MotionEvent.PointerCoords[] pointerCoordsObjArray, int metaState) {
        ShadowMotionEvent.nativeAddBatch((long)nativePtr, eventTimeNanos, pointerCoordsObjArray, metaState);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeAddBatch(long nativePtr, long eventTimeNanos, MotionEvent.PointerCoords[] pointerCoordsObjArray, int metaState) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerCoordsObjArray(pointerCoordsObjArray, pointerCount);
        NativeInput.PointerCoords[] rawPointerCoords = new NativeInput.PointerCoords[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            MotionEvent.PointerCoords pointerCoordsObj = pointerCoordsObjArray[i];
            Preconditions.checkNotNull((Object)pointerCoordsObj);
            rawPointerCoords[i] = ShadowMotionEvent.pointerCoordsToNative(pointerCoordsObj, event.getXOffset(), event.getYOffset());
        }
        event.addSample(eventTimeNanos, rawPointerCoords);
        event.setMetaState(event.getMetaState() | metaState);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeGetPointerCoords(int nativePtr, int pointerIndex, int historyPos, MotionEvent.PointerCoords outPointerCoordsObj) {
        ShadowMotionEvent.nativeGetPointerCoords((long)nativePtr, pointerIndex, historyPos, outPointerCoordsObj);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeGetPointerCoords(long nativePtr, int pointerIndex, int historyPos, MotionEvent.PointerCoords outPointerCoordsObj) {
        NativeInput.PointerCoords rawPointerCoords;
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        ShadowMotionEvent.validatePointerCoords(outPointerCoordsObj);
        if (historyPos == Integer.MIN_VALUE) {
            rawPointerCoords = event.getRawPointerCoords(pointerIndex);
        } else {
            int historySize = event.getHistorySize();
            ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
            rawPointerCoords = event.getHistoricalRawPointerCoords(pointerIndex, historyPos);
        }
        ShadowMotionEvent.pointerCoordsFromNative(rawPointerCoords, event.getXOffset(), event.getYOffset(), outPointerCoordsObj);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeGetPointerProperties(int nativePtr, int pointerIndex, MotionEvent.PointerProperties outPointerPropertiesObj) {
        ShadowMotionEvent.nativeGetPointerProperties((long)nativePtr, pointerIndex, outPointerPropertiesObj);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeGetPointerProperties(long nativePtr, int pointerIndex, MotionEvent.PointerProperties outPointerPropertiesObj) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        ShadowMotionEvent.validatePointerProperties(outPointerPropertiesObj);
        MotionEvent.PointerProperties pointerProperties = event.getPointerProperties(pointerIndex);
        outPointerPropertiesObj.copyFrom(pointerProperties);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeReadFromParcel(int nativePtr, Parcel parcelObj) {
        return (int)ShadowMotionEvent.nativeReadFromParcel((long)nativePtr, parcelObj);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static long nativeReadFromParcel(long nativePtr, Parcel parcelObj) {
        NativeInput.MotionEvent event;
        if (nativePtr == 0L) {
            event = new NativeInput.MotionEvent();
            nativePtr = nativeMotionEventRegistry.register((Object)event);
        } else {
            event = (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
        }
        boolean status = event.readFromParcel(parcelObj);
        if (!status) {
            if (nativePtr > 0L) {
                nativeMotionEventRegistry.unregister(nativePtr);
            }
            throw new RuntimeException("Failed to read MotionEvent parcel.");
        }
        return nativePtr;
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeWriteToParcel(int nativePtr, Parcel parcel) {
        ShadowMotionEvent.nativeWriteToParcel((long)nativePtr, parcel);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeWriteToParcel(long nativePtr, Parcel parcel) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        if (!event.writeToParcel(parcel)) {
            throw new RuntimeException("Failed to write MotionEvent parcel.");
        }
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static String nativeAxisToString(int axis) {
        for (Field field : MotionEvent.class.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            try {
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !field.getName().startsWith("AXIS_") || field.getInt(null) != axis) continue;
                return field.getName().substring(5);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeAxisFromString(String label) {
        try {
            String string = String.valueOf(label);
            Field constantField = MotionEvent.class.getDeclaredField(string.length() != 0 ? "AXIS_".concat(string) : new String("AXIS_"));
            return constantField.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return 0;
        }
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetPointerId(int nativePtr, int pointerIndex) {
        return ShadowMotionEvent.nativeGetPointerId((long)nativePtr, pointerIndex);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetPointerId(long nativePtr, int pointerIndex) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        return event.getPointerId(pointerIndex);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetToolType(int nativePtr, int pointerIndex) {
        return ShadowMotionEvent.nativeGetToolType((long)nativePtr, pointerIndex);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetToolType(long nativePtr, int pointerIndex) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        return event.getToolType(pointerIndex);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static long nativeGetEventTimeNanos(int nativePtr, int historyPos) {
        return ShadowMotionEvent.nativeGetEventTimeNanos((long)nativePtr, historyPos);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static long nativeGetEventTimeNanos(long nativePtr, int historyPos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        if (historyPos == Integer.MIN_VALUE) {
            return event.getEventTime();
        }
        int historySize = event.getHistorySize();
        ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
        return event.getHistoricalEventTime(historyPos);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static float nativeGetRawAxisValue(int nativePtr, int axis, int pointerIndex, int historyPos) {
        return ShadowMotionEvent.nativeGetRawAxisValue((long)nativePtr, axis, pointerIndex, historyPos);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static float nativeGetRawAxisValue(long nativePtr, int axis, int pointerIndex, int historyPos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        if (historyPos == Integer.MIN_VALUE) {
            return event.getRawAxisValue(axis, pointerIndex);
        }
        int historySize = event.getHistorySize();
        ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
        return event.getHistoricalRawAxisValue(axis, pointerIndex, historyPos);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static float nativeGetAxisValue(int nativePtr, int axis, int pointerIndex, int historyPos) {
        return ShadowMotionEvent.nativeGetAxisValue((long)nativePtr, axis, pointerIndex, historyPos);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static float nativeGetAxisValue(long nativePtr, int axis, int pointerIndex, int historyPos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        int pointerCount = event.getPointerCount();
        ShadowMotionEvent.validatePointerIndex(pointerIndex, pointerCount);
        if (historyPos == Integer.MIN_VALUE) {
            return event.getAxisValue(axis, pointerIndex);
        }
        int historySize = event.getHistorySize();
        ShadowMotionEvent.validateHistoryPos(historyPos, historySize);
        return event.getHistoricalAxisValue(axis, pointerIndex, historyPos);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeCopy(int destNativePtr, int sourceNativePtr, boolean keepHistory) {
        return (int)ShadowMotionEvent.nativeCopy((long)destNativePtr, (long)sourceNativePtr, keepHistory);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static long nativeCopy(long destNativePtr, long sourceNativePtr, boolean keepHistory) {
        NativeInput.MotionEvent destEvent = (NativeInput.MotionEvent)nativeMotionEventRegistry.peekNativeObject(destNativePtr);
        if (destEvent == null) {
            destEvent = new NativeInput.MotionEvent();
            destNativePtr = nativeMotionEventRegistry.register((Object)destEvent);
        }
        NativeInput.MotionEvent sourceEvent = ShadowMotionEvent.getNativeMotionEvent(sourceNativePtr);
        destEvent.copyFrom(sourceEvent, keepHistory);
        return destNativePtr;
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetDeviceId(int nativePtr) {
        return ShadowMotionEvent.nativeGetDeviceId((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetDeviceId(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getDeviceId();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetSource(int nativePtr) {
        return ShadowMotionEvent.nativeGetSource((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetSource(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getSource();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeSetSource(int nativePtr, int source) {
        ShadowMotionEvent.nativeSetSource((long)nativePtr, source);
        return 0;
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeSetSource(long nativePtr, int source) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setSource(source);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetAction(int nativePtr) {
        return ShadowMotionEvent.nativeGetAction((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetAction(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getAction();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeSetAction(int nativePtr, int action) {
        ShadowMotionEvent.nativeSetAction((long)nativePtr, action);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeSetAction(long nativePtr, int action) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setAction(action);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected static int nativeGetActionButton(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getActionButton();
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected static void nativeSetActionButton(long nativePtr, int button) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setActionButton(button);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static boolean nativeIsTouchEvent(int nativePtr) {
        return ShadowMotionEvent.nativeIsTouchEvent((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static boolean nativeIsTouchEvent(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.isTouchEvent();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetFlags(int nativePtr) {
        return ShadowMotionEvent.nativeGetFlags((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetFlags(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getFlags();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeSetFlags(int nativePtr, int flags) {
        ShadowMotionEvent.nativeSetFlags((long)nativePtr, flags);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeSetFlags(long nativePtr, int flags) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setFlags(flags);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetEdgeFlags(int nativePtr) {
        return ShadowMotionEvent.nativeGetEdgeFlags((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetEdgeFlags(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getEdgeFlags();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeSetEdgeFlags(int nativePtr, int edgeFlags) {
        ShadowMotionEvent.nativeSetEdgeFlags((long)nativePtr, edgeFlags);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeSetEdgeFlags(long nativePtr, int edgeFlags) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setEdgeFlags(edgeFlags);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetMetaState(int nativePtr) {
        return ShadowMotionEvent.nativeGetMetaState((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetMetaState(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getMetaState();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetButtonState(int nativePtr) {
        return ShadowMotionEvent.nativeGetButtonState((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetButtonState(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getButtonState();
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected static void nativeSetButtonState(long nativePtr, int buttonState) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setButtonState(buttonState);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeOffsetLocation(int nativePtr, float deltaX, float deltaY) {
        ShadowMotionEvent.nativeOffsetLocation((long)nativePtr, deltaX, deltaY);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeOffsetLocation(long nativePtr, float deltaX, float deltaY) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.offsetLocation(deltaX, deltaY);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static float nativeGetXOffset(int nativePtr) {
        return ShadowMotionEvent.nativeGetXOffset((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static float nativeGetXOffset(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getXOffset();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static float nativeGetYOffset(int nativePtr) {
        return ShadowMotionEvent.nativeGetYOffset((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static float nativeGetYOffset(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getYOffset();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static float nativeGetXPrecision(int nativePtr) {
        return ShadowMotionEvent.nativeGetXPrecision((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static float nativeGetXPrecision(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getXPrecision();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static float nativeGetYPrecision(int nativePtr) {
        return ShadowMotionEvent.nativeGetYPrecision((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static float nativeGetYPrecision(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getYPrecision();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static long nativeGetDownTimeNanos(int nativePtr) {
        return ShadowMotionEvent.nativeGetDownTimeNanos((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static long nativeGetDownTimeNanos(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getDownTime();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeSetDownTimeNanos(int nativePtr, long downTimeNanos) {
        ShadowMotionEvent.nativeSetDownTimeNanos((long)nativePtr, downTimeNanos);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeSetDownTimeNanos(long nativePtr, long downTimeNanos) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.setDownTime(downTimeNanos);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetPointerCount(int nativePtr) {
        return ShadowMotionEvent.nativeGetPointerCount((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetPointerCount(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getPointerCount();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeFindPointerIndex(int nativePtr, int pointerId) {
        return ShadowMotionEvent.nativeFindPointerIndex((long)nativePtr, pointerId);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeFindPointerIndex(long nativePtr, int pointerId) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.findPointerIndex(pointerId);
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static int nativeGetHistorySize(int nativePtr) {
        return ShadowMotionEvent.nativeGetHistorySize((long)nativePtr);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static int nativeGetHistorySize(long nativePtr) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        return event.getHistorySize();
    }

    @Implementation(maxSdk=20)
    @HiddenApi
    protected static void nativeScale(int nativePtr, float scale) {
        ShadowMotionEvent.nativeScale((long)nativePtr, scale);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected static void nativeScale(long nativePtr, float scale) {
        NativeInput.MotionEvent event = ShadowMotionEvent.getNativeMotionEvent(nativePtr);
        event.scale(scale);
    }

    private static NativeInput.MotionEvent getNativeMotionEvent(long nativePtr) {
        Preconditions.checkState((nativePtr > 0L ? 1 : 0) != 0, (Object)"MotionEvent has not been initialized. Ensure MotionEvent.obtain was used to create it, instead of creating it directly or via a Mocking framework");
        return (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
    }

    @Implementation
    protected final void transform(Matrix matrix) {
        Preconditions.checkNotNull((Object)matrix);
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        ShadowMatrix shadowMatrix = (ShadowMatrix)Shadow.extract((Object)matrix);
        float[] m = new float[9];
        shadowMatrix.getValues(m);
        event.transform(m);
    }

    private NativeInput.MotionEvent getNativeMotionEvent() {
        long nativePtr;
        if (RuntimeEnvironment.getApiLevel() <= 20) {
            Integer nativePtrInt = (Integer)ReflectionHelpers.getField((Object)this.realMotionEvent, (String)"mNativePtr");
            nativePtr = nativePtrInt.longValue();
        } else {
            nativePtr = (Long)ReflectionHelpers.getField((Object)this.realMotionEvent, (String)"mNativePtr");
        }
        return (NativeInput.MotionEvent)nativeMotionEventRegistry.getNativeObject(nativePtr);
    }

    @Deprecated
    public MotionEvent setPointer2(float pointer1X, float pointer1Y) {
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        List<NativeInput.PointerCoords> pointerCoords = event.getSamplePointerCoords();
        List<MotionEvent.PointerProperties> pointerProperties = event.getPointerProperties();
        ShadowMotionEvent.ensureTwoPointers(pointerCoords, pointerProperties);
        pointerCoords.get(1).setAxisValue(0, pointer1X);
        pointerCoords.get(1).setAxisValue(1, pointer1Y);
        return this.realMotionEvent;
    }

    private static void ensureTwoPointers(List<NativeInput.PointerCoords> pointerCoords, List<MotionEvent.PointerProperties> pointerProperties) {
        if (pointerCoords.size() < 2) {
            pointerCoords.add(new NativeInput.PointerCoords());
        }
        if (pointerProperties.size() < 2) {
            pointerProperties.add(new MotionEvent.PointerProperties());
        }
    }

    @Deprecated
    public void setPointerIndex(int pointerIndex) {
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        event.setAction(event.getAction() | (pointerIndex & 0xFF) << 8);
    }

    @Deprecated
    public void setPointerIds(int index0PointerId, int index1PointerId) {
        NativeInput.MotionEvent event = this.getNativeMotionEvent();
        List<NativeInput.PointerCoords> pointerCoords = event.getSamplePointerCoords();
        List<MotionEvent.PointerProperties> pointerProperties = event.getPointerProperties();
        ShadowMotionEvent.ensureTwoPointers(pointerCoords, pointerProperties);
        pointerProperties.get((int)0).id = index0PointerId;
        pointerProperties.get((int)1).id = index1PointerId;
    }
}

