/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPausedMessage;
import org.robolectric.shadows.ShadowPausedMessageQueue;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;

@Implements(value=Looper.class, isInAndroidSdk=false)
public final class ShadowPausedLooper
extends ShadowLooper {
    private static Set<Looper> loopingLoopers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    @RealObject
    private Looper realLooper;
    private boolean isPaused = false;
    private Executor looperExecutor;

    @Implementation
    protected void __constructor__(boolean quitAllowed) {
        Shadow.invokeConstructor(Looper.class, (Object)this.realLooper, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)quitAllowed)});
        loopingLoopers.add(this.realLooper);
        this.looperExecutor = new HandlerExecutor(new Handler(this.realLooper));
    }

    protected static Collection<Looper> getLoopers() {
        ArrayList<Looper> loopers = new ArrayList<Looper>(loopingLoopers);
        return Collections.unmodifiableCollection(loopers);
    }

    @Override
    public void quitUnchecked() {
        String string = String.valueOf(ShadowPausedLooper.looperMode());
        throw new UnsupportedOperationException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
    }

    @Override
    public boolean hasQuit() {
        String string = String.valueOf(ShadowPausedLooper.looperMode());
        throw new UnsupportedOperationException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
    }

    @Override
    public void idle() {
        this.executeOnLooper(new IdlingRunnable());
    }

    @Override
    public void idleFor(long time, TimeUnit timeUnit) {
        long endingTimeMs = SystemClock.uptimeMillis() + timeUnit.toMillis(time);
        long nextScheduledTimeMs = this.getNextScheduledTaskTime().toMillis();
        while (nextScheduledTimeMs != 0L && nextScheduledTimeMs <= endingTimeMs) {
            SystemClock.setCurrentTimeMillis((long)nextScheduledTimeMs);
            this.idle();
            nextScheduledTimeMs = this.getNextScheduledTaskTime().toMillis();
        }
        SystemClock.setCurrentTimeMillis((long)endingTimeMs);
    }

    @Override
    public boolean isIdle() {
        if (Thread.currentThread() == this.realLooper.getThread() || this.isPaused) {
            return this.shadowQueue().isIdle();
        }
        return this.shadowQueue().isIdle() && this.shadowQueue().isPolling();
    }

    @Override
    public void unPause() {
        if (this.realLooper == Looper.getMainLooper()) {
            throw new UnsupportedOperationException("main looper cannot be unpaused");
        }
        this.executeOnLooper(new UnPauseRunnable());
    }

    @Override
    public void pause() {
        if (!this.isPaused()) {
            this.executeOnLooper(new PausedLooperExecutor());
        }
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public boolean setPaused(boolean shouldPause) {
        if (shouldPause) {
            this.pause();
        } else {
            this.unPause();
        }
        return true;
    }

    @Override
    public void resetScheduler() {
        String string = String.valueOf(ShadowPausedLooper.looperMode());
        throw new UnsupportedOperationException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
    }

    @Override
    public void reset() {
        String string = String.valueOf(ShadowPausedLooper.looperMode());
        throw new UnsupportedOperationException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
    }

    @Override
    public void idleIfPaused() {
        this.idle();
    }

    @Override
    public void idleConstantly(boolean shouldIdleConstantly) {
        String string = String.valueOf(ShadowPausedLooper.looperMode());
        throw new UnsupportedOperationException(new StringBuilder(38 + String.valueOf(string).length()).append("this action is not supported in ").append(string).append(" mode.").toString());
    }

    @Override
    public void runToEndOfTasks() {
        this.idleFor(Duration.ofMillis(this.getLastScheduledTaskTime().toMillis() - SystemClock.uptimeMillis()));
    }

    @Override
    public void runToNextTask() {
        this.idleFor(Duration.ofMillis(this.getNextScheduledTaskTime().toMillis() - SystemClock.uptimeMillis()));
    }

    @Override
    public void runOneTask() {
        this.executeOnLooper(new RunOneRunnable());
    }

    @Override
    public boolean post(Runnable runnable, long delayMillis) {
        return new Handler(this.realLooper).postDelayed(runnable, delayMillis);
    }

    @Override
    public boolean postAtFrontOfQueue(Runnable runnable) {
        return new Handler(this.realLooper).postAtFrontOfQueue(runnable);
    }

    @Override
    public void runPaused(Runnable runnable) {
        if (!this.isPaused || Thread.currentThread() != this.realLooper.getThread()) {
            throw new UnsupportedOperationException();
        }
        runnable.run();
    }

    @Override
    public Duration getNextScheduledTaskTime() {
        return this.shadowQueue().getNextScheduledTaskTime();
    }

    @Override
    public Duration getLastScheduledTaskTime() {
        return this.shadowQueue().getLastScheduledTaskTime();
    }

    @Resetter
    public static synchronized void resetLoopers() {
        if (ShadowPausedLooper.looperMode() != LooperMode.Mode.PAUSED) {
            return;
        }
        ArrayList<Looper> loopersCopy = new ArrayList<Looper>(loopingLoopers);
        for (Looper looper : loopersCopy) {
            ShadowPausedMessageQueue shadowQueue = (ShadowPausedMessageQueue)Shadow.extract((Object)looper.getQueue());
            if (shadowQueue.isQuitAllowed()) {
                looper.quit();
                loopingLoopers.remove(looper);
                continue;
            }
            shadowQueue.reset();
        }
    }

    @Implementation
    protected static void prepareMainLooper() {
        Shadow.directlyOn(Looper.class, (String)"prepareMainLooper", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowPausedLooper pausedLooper = (ShadowPausedLooper)Shadow.extract((Object)Looper.getMainLooper());
        pausedLooper.isPaused = true;
    }

    @Implementation
    protected void quit() {
        if (this.isPaused()) {
            this.executeOnLooper(new UnPauseRunnable());
        }
        Shadow.directlyOn((Object)this.realLooper, Looper.class, (String)"quit", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation(minSdk=18)
    protected void quitSafely() {
        if (this.isPaused()) {
            this.executeOnLooper(new UnPauseRunnable());
        }
        Shadow.directlyOn((Object)this.realLooper, Looper.class, (String)"quitSafely", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Override
    public Scheduler getScheduler() {
        throw new UnsupportedOperationException(String.format("this action is not supported in %s mode.", ShadowPausedLooper.looperMode()));
    }

    private static ShadowPausedMessage shadowMsg(Message msg) {
        return (ShadowPausedMessage)Shadow.extract((Object)msg);
    }

    private ShadowPausedMessageQueue shadowQueue() {
        return (ShadowPausedMessageQueue)Shadow.extract((Object)this.realLooper.getQueue());
    }

    private void executeOnLooper(ControlRunnable runnable) {
        if (Thread.currentThread() == this.realLooper.getThread()) {
            runnable.run();
        } else {
            if (this.realLooper.equals(Looper.getMainLooper())) {
                throw new UnsupportedOperationException("main looper can only be controlled from main thread");
            }
            this.looperExecutor.execute(runnable);
            runnable.waitTillComplete();
        }
    }

    private void setLooperExecutor(Executor executor) {
        this.looperExecutor = executor;
    }

    private static class HandlerExecutor
    implements Executor {
        private final Handler handler;

        private HandlerExecutor(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void execute(Runnable runnable) {
            if (!this.handler.post(runnable)) {
                throw new IllegalStateException(String.format("post to %s failed. Is handler thread dead?", this.handler));
            }
        }
    }

    private class UnPauseRunnable
    extends ControlRunnable {
        private UnPauseRunnable() {
        }

        @Override
        public void run() {
            ShadowPausedLooper.this.isPaused = false;
            this.runLatch.countDown();
        }
    }

    private class PausedLooperExecutor
    extends ControlRunnable
    implements Executor {
        private final LinkedBlockingQueue<Runnable> executionQueue;

        private PausedLooperExecutor() {
            this.executionQueue = new LinkedBlockingQueue();
        }

        @Override
        public void execute(Runnable runnable) {
            this.executionQueue.add(runnable);
        }

        @Override
        public void run() {
            ShadowPausedLooper.this.setLooperExecutor(this);
            ShadowPausedLooper.this.isPaused = true;
            this.runLatch.countDown();
            while (true) {
                try {
                    Runnable runnable;
                    do {
                        runnable = this.executionQueue.take();
                        runnable.run();
                    } while (!(runnable instanceof UnPauseRunnable));
                    ShadowPausedLooper.this.setLooperExecutor(new HandlerExecutor(new Handler(ShadowPausedLooper.this.realLooper)));
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class RunOneRunnable
    extends ControlRunnable {
        private RunOneRunnable() {
        }

        @Override
        public void run() {
            Message msg = ShadowPausedLooper.this.shadowQueue().poll();
            if (msg != null) {
                SystemClock.setCurrentTimeMillis((long)ShadowPausedLooper.shadowMsg(msg).getWhen());
                msg.getTarget().dispatchMessage(msg);
            }
            this.runLatch.countDown();
        }
    }

    private class IdlingRunnable
    extends ControlRunnable {
        private IdlingRunnable() {
        }

        @Override
        public void run() {
            while (!ShadowPausedLooper.this.shadowQueue().isIdle()) {
                Message msg = ShadowPausedLooper.this.shadowQueue().getNext();
                msg.getTarget().dispatchMessage(msg);
                ShadowPausedLooper.shadowMsg(msg).recycleUnchecked();
            }
            this.runLatch.countDown();
        }
    }

    private static abstract class ControlRunnable
    implements Runnable {
        protected final CountDownLatch runLatch = new CountDownLatch(1);

        private ControlRunnable() {
        }

        public void waitTillComplete() {
            try {
                this.runLatch.await();
            }
            catch (InterruptedException e) {
                Log.w((String)"ShadowPausedLooper", (String)"wait till idle interrupted");
            }
        }
    }
}

